/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.core.search;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.ivy.core.module.id.ModuleId;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.core.search.ModuleEntry;
import org.apache.ivy.core.search.OrganisationEntry;
import org.apache.ivy.core.search.RevisionEntry;
import org.apache.ivy.core.settings.IvySettings;
import org.apache.ivy.plugins.matcher.Matcher;
import org.apache.ivy.plugins.matcher.MatcherHelper;
import org.apache.ivy.plugins.matcher.PatternMatcher;
import org.apache.ivy.plugins.namespace.NameSpaceHelper;
import org.apache.ivy.plugins.namespace.Namespace;
import org.apache.ivy.plugins.resolver.AbstractResolver;
import org.apache.ivy.plugins.resolver.DependencyResolver;
import org.apache.ivy.util.Message;

public class SearchEngine {
    private IvySettings settings;

    public SearchEngine(IvySettings ivySettings) {
        this.settings = ivySettings;
    }

    public String[] listTokenValues(String string, Map map) {
        LinkedHashSet linkedHashSet = new LinkedHashSet();
        for (DependencyResolver dependencyResolver : this.settings.getResolvers()) {
            Map[] mapArray = dependencyResolver.listTokenValues(new String[]{string}, map);
            for (int i = 0; i < mapArray.length; ++i) {
                linkedHashSet.add(mapArray[i].get(string));
            }
        }
        return linkedHashSet.toArray(new String[linkedHashSet.size()]);
    }

    public OrganisationEntry[] listOrganisationEntries() {
        HashSet<OrganisationEntry> hashSet = new HashSet<OrganisationEntry>();
        for (DependencyResolver dependencyResolver : this.settings.getResolvers()) {
            Map[] mapArray = dependencyResolver.listTokenValues(new String[]{"organisation"}, new HashMap());
            for (int i = 0; i < mapArray.length; ++i) {
                String string = (String)mapArray[i].get("organisation");
                hashSet.add(new OrganisationEntry(dependencyResolver, string));
            }
        }
        return hashSet.toArray(new OrganisationEntry[hashSet.size()]);
    }

    public String[] listOrganisations() {
        HashSet hashSet = new HashSet();
        for (DependencyResolver dependencyResolver : this.settings.getResolvers()) {
            Map[] mapArray = dependencyResolver.listTokenValues(new String[]{"organisation"}, new HashMap());
            for (int i = 0; i < mapArray.length; ++i) {
                hashSet.add(mapArray[i].get("organisation"));
            }
        }
        return hashSet.toArray(new String[hashSet.size()]);
    }

    public ModuleEntry[] listModuleEntries(OrganisationEntry organisationEntry) {
        HashSet<ModuleEntry> hashSet = new HashSet<ModuleEntry>();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("organisation", organisationEntry.getOrganisation());
        for (DependencyResolver dependencyResolver : this.settings.getResolvers()) {
            Map[] mapArray = dependencyResolver.listTokenValues(new String[]{"module"}, hashMap);
            for (int i = 0; i < mapArray.length; ++i) {
                String string = (String)mapArray[i].get("module");
                hashSet.add(new ModuleEntry(organisationEntry, string));
            }
        }
        return hashSet.toArray(new ModuleEntry[hashSet.size()]);
    }

    public String[] listModules(String string) {
        HashSet hashSet = new HashSet();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("organisation", string);
        for (DependencyResolver dependencyResolver : this.settings.getResolvers()) {
            Map[] mapArray = dependencyResolver.listTokenValues(new String[]{"module"}, hashMap);
            for (int i = 0; i < mapArray.length; ++i) {
                hashSet.add(mapArray[i].get("module"));
            }
        }
        return hashSet.toArray(new String[hashSet.size()]);
    }

    public RevisionEntry[] listRevisionEntries(ModuleEntry moduleEntry) {
        HashSet<RevisionEntry> hashSet = new HashSet<RevisionEntry>();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("organisation", moduleEntry.getOrganisation());
        hashMap.put("module", moduleEntry.getModule());
        for (DependencyResolver dependencyResolver : this.settings.getResolvers()) {
            Map[] mapArray = dependencyResolver.listTokenValues(new String[]{"revision"}, hashMap);
            for (int i = 0; i < mapArray.length; ++i) {
                String string = (String)mapArray[i].get("revision");
                hashSet.add(new RevisionEntry(moduleEntry, string));
            }
        }
        return hashSet.toArray(new RevisionEntry[hashSet.size()]);
    }

    public String[] listRevisions(String string, String string2) {
        HashSet hashSet = new HashSet();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("organisation", string);
        hashMap.put("module", string2);
        for (DependencyResolver dependencyResolver : this.settings.getResolvers()) {
            Map[] mapArray = dependencyResolver.listTokenValues(new String[]{"revision"}, hashMap);
            for (int i = 0; i < mapArray.length; ++i) {
                hashSet.add(mapArray[i].get("revision"));
            }
        }
        return hashSet.toArray(new String[hashSet.size()]);
    }

    public ModuleId[] listModules(ModuleId moduleId, PatternMatcher patternMatcher) {
        ArrayList<ModuleId> arrayList = new ArrayList<ModuleId>();
        HashMap hashMap = new HashMap();
        this.addMatcher(patternMatcher, moduleId.getOrganisation(), hashMap, "organisation");
        this.addMatcher(patternMatcher, moduleId.getName(), hashMap, "module");
        String[] stringArray = new String[]{"organisation", "module"};
        for (DependencyResolver dependencyResolver : this.settings.getResolvers()) {
            Map[] mapArray = dependencyResolver.listTokenValues(stringArray, hashMap);
            for (int i = 0; i < mapArray.length; ++i) {
                String string = (String)mapArray[i].get("organisation");
                String string2 = (String)mapArray[i].get("module");
                ModuleId moduleId2 = ModuleId.newInstance(string, string2);
                arrayList.add(NameSpaceHelper.transform(moduleId2, dependencyResolver.getNamespace().getToSystemTransformer()));
            }
        }
        return arrayList.toArray(new ModuleId[arrayList.size()]);
    }

    public ModuleRevisionId[] listModules(ModuleRevisionId moduleRevisionId, PatternMatcher patternMatcher) {
        ArrayList<ModuleRevisionId> arrayList = new ArrayList<ModuleRevisionId>();
        HashMap hashMap = new HashMap();
        for (Map.Entry object : moduleRevisionId.getAttributes().entrySet()) {
            this.addMatcher(patternMatcher, (String)object.getValue(), hashMap, (String)object.getKey());
        }
        String[] stringArray = moduleRevisionId.getAttributes().keySet().toArray(new String[moduleRevisionId.getAttributes().size()]);
        for (DependencyResolver dependencyResolver : this.settings.getResolvers()) {
            Map[] mapArray = dependencyResolver.listTokenValues(stringArray, hashMap);
            for (int i = 0; i < mapArray.length; ++i) {
                String string = (String)mapArray[i].get("organisation");
                String string2 = (String)mapArray[i].get("module");
                String string3 = (String)mapArray[i].get("branch");
                String string4 = (String)mapArray[i].get("revision");
                HashMap<String, String> hashMap2 = new HashMap<String, String>();
                Set set = moduleRevisionId.getQualifiedExtraAttributes().keySet();
                for (String string5 : set) {
                    String string6 = null;
                    int n = string5.indexOf(58);
                    string6 = n == -1 ? (String)mapArray[i].get(string5) : (String)mapArray[i].get(string5.substring(n + 1));
                    if (string6 == null) continue;
                    hashMap2.put(string5, string6);
                }
                ModuleRevisionId moduleRevisionId2 = ModuleRevisionId.newInstance(string, string2, string3, string4, hashMap2);
                arrayList.add(dependencyResolver.getNamespace().getToSystemTransformer().transform(moduleRevisionId2));
            }
        }
        return arrayList.toArray(new ModuleRevisionId[arrayList.size()]);
    }

    public ModuleRevisionId[] listModules(DependencyResolver dependencyResolver, ModuleRevisionId moduleRevisionId, PatternMatcher patternMatcher) {
        HashMap hashMap = new HashMap();
        for (Map.Entry mapArray2 : moduleRevisionId.getAttributes().entrySet()) {
            this.addMatcher(patternMatcher, (String)mapArray2.getValue(), hashMap, (String)mapArray2.getKey());
        }
        String[] stringArray = moduleRevisionId.getAttributes().keySet().toArray(new String[moduleRevisionId.getAttributes().size()]);
        Map[] mapArray = dependencyResolver.listTokenValues(stringArray, hashMap);
        LinkedHashSet<ModuleRevisionId> linkedHashSet = new LinkedHashSet<ModuleRevisionId>();
        for (int i = 0; i < mapArray.length; ++i) {
            String string = (String)mapArray[i].get("organisation");
            String string2 = (String)mapArray[i].get("module");
            String string3 = (String)mapArray[i].get("branch");
            String string4 = (String)mapArray[i].get("revision");
            HashMap<String, String> hashMap2 = new HashMap<String, String>();
            Set set = moduleRevisionId.getQualifiedExtraAttributes().keySet();
            for (String string5 : set) {
                String string6 = null;
                int n = string5.indexOf(58);
                string6 = n == -1 ? (String)mapArray[i].get(string5) : (String)mapArray[i].get(string5.substring(n + 1));
                if (string6 == null) continue;
                hashMap2.put(string5, string6);
            }
            ModuleRevisionId moduleRevisionId2 = ModuleRevisionId.newInstance(string, string2, string3, string4, hashMap2);
            linkedHashSet.add(dependencyResolver.getNamespace().getToSystemTransformer().transform(moduleRevisionId2));
        }
        return linkedHashSet.toArray(new ModuleRevisionId[linkedHashSet.size()]);
    }

    private void addMatcher(PatternMatcher patternMatcher, String string, Map map, String string2) {
        if (string == null) {
            return;
        }
        Matcher matcher = patternMatcher.getMatcher(string);
        if (matcher.isExact()) {
            map.put(string2, string);
        } else {
            map.put(string2, matcher);
        }
    }

    public Collection findModuleRevisionIds(DependencyResolver dependencyResolver, ModuleRevisionId moduleRevisionId, PatternMatcher patternMatcher) {
        Object object;
        Object object2;
        ArrayList<ModuleRevisionId> arrayList = new ArrayList<ModuleRevisionId>();
        String string = dependencyResolver.getName();
        Message.verbose("looking for modules matching " + moduleRevisionId + " using " + patternMatcher.getName());
        Namespace namespace = null;
        if (dependencyResolver instanceof AbstractResolver) {
            namespace = ((AbstractResolver)dependencyResolver).getNamespace();
        }
        ArrayList<ModuleEntry> arrayList2 = new ArrayList<ModuleEntry>();
        OrganisationEntry[] organisationEntryArray = dependencyResolver.listOrganisations();
        if (organisationEntryArray == null || organisationEntryArray.length == 0) {
            object2 = moduleRevisionId.getOrganisation();
            if (namespace != null) {
                object2 = NameSpaceHelper.transform(moduleRevisionId.getModuleId(), namespace.getFromSystemTransformer()).getOrganisation();
            }
            arrayList2.addAll(Arrays.asList(dependencyResolver.listModules(new OrganisationEntry(dependencyResolver, (String)object2))));
        } else {
            object2 = patternMatcher.getMatcher(moduleRevisionId.getOrganisation());
            for (int i = 0; i < organisationEntryArray.length; ++i) {
                String object3 = organisationEntryArray[i].getOrganisation();
                object = object3;
                if (namespace != null) {
                    object = NameSpaceHelper.transformOrganisation(object3, namespace.getToSystemTransformer());
                }
                if (!object2.matches((String)object)) continue;
                arrayList2.addAll(Arrays.asList(dependencyResolver.listModules(new OrganisationEntry(dependencyResolver, object3))));
            }
        }
        Message.debug("found " + arrayList2.size() + " modules for " + moduleRevisionId.getOrganisation() + " on " + string);
        boolean bl = false;
        for (ModuleEntry moduleEntry : arrayList2) {
            Object object3 = object = new ModuleId(moduleEntry.getOrganisation(), moduleEntry.getModule());
            if (namespace != null) {
                object3 = NameSpaceHelper.transform((ModuleId)object, namespace.getToSystemTransformer());
            }
            if (!MatcherHelper.matches(patternMatcher, moduleRevisionId.getModuleId(), (ModuleId)object3)) continue;
            bl = true;
            RevisionEntry[] revisionEntryArray = dependencyResolver.listRevisions(moduleEntry);
            Message.debug("found " + revisionEntryArray.length + " revisions for [" + moduleEntry.getOrganisation() + ", " + moduleEntry.getModule() + "] on " + string);
            boolean bl2 = false;
            for (int i = 0; i < revisionEntryArray.length; ++i) {
                ModuleRevisionId moduleRevisionId2;
                RevisionEntry revisionEntry = revisionEntryArray[i];
                ModuleRevisionId moduleRevisionId3 = moduleRevisionId2 = ModuleRevisionId.newInstance(moduleEntry.getOrganisation(), moduleEntry.getModule(), revisionEntry.getRevision());
                if (namespace != null) {
                    moduleRevisionId3 = namespace.getToSystemTransformer().transform(moduleRevisionId2);
                }
                if (!MatcherHelper.matches(patternMatcher, moduleRevisionId, moduleRevisionId3)) continue;
                bl2 = true;
                arrayList.add(moduleRevisionId3);
            }
            if (bl2) continue;
            Message.debug("no revision found matching " + moduleRevisionId + " in [" + moduleEntry.getOrganisation() + "," + moduleEntry.getModule() + "] using " + string);
        }
        if (!bl) {
            Message.debug("no module found matching " + moduleRevisionId + " using " + string);
        }
        return arrayList;
    }
}

