/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.util.Random;

public final class Math {
    private static Random rand;
    public static final double E = 2.718281828459045;
    public static final double PI = 3.141592653589793;

    public static final int abs(int i) {
        return i < 0 ? -i : i;
    }

    public static final long abs(long l) {
        return l < 0L ? -l : l;
    }

    public static final float abs(float f) {
        return f <= 0.0f ? 0.0f - f : f;
    }

    public static final double abs(double d) {
        return d <= 0.0 ? 0.0 - d : d;
    }

    public static final int min(int a, int b) {
        return a < b ? a : b;
    }

    public static final long min(long a, long b) {
        return a < b ? a : b;
    }

    public static final float min(float a, float b) {
        if (a != a) {
            return a;
        }
        if (a == 0.0f && b == 0.0f) {
            return -(-a - b);
        }
        return a < b ? a : b;
    }

    public static final double min(double a, double b) {
        if (a != a) {
            return a;
        }
        if (a == 0.0 && b == 0.0) {
            return -(-a - b);
        }
        return a < b ? a : b;
    }

    public static final int max(int a, int b) {
        return a > b ? a : b;
    }

    public static final long max(long a, long b) {
        return a > b ? a : b;
    }

    public static final float max(float a, float b) {
        if (a != a) {
            return a;
        }
        if (a == 0.0f && b == 0.0f) {
            return a - -b;
        }
        return a > b ? a : b;
    }

    public static final double max(double a, double b) {
        if (a != a) {
            return a;
        }
        if (a == 0.0 && b == 0.0) {
            return a - -b;
        }
        return a > b ? a : b;
    }

    public static final native double sin(double var0);

    public static final native double cos(double var0);

    public static final native double tan(double var0);

    public static final native double asin(double var0);

    public static final native double acos(double var0);

    public static final native double atan(double var0);

    public static final native double atan2(double var0, double var2);

    public static final native double exp(double var0);

    public static final native double log(double var0);

    public static final native double sqrt(double var0);

    public static final native double pow(double var0, double var2);

    public static final native double IEEEremainder(double var0, double var2);

    public static final native double ceil(double var0);

    public static final native double floor(double var0);

    public static final native double rint(double var0);

    public static final int round(float a) {
        if (a != a) {
            return 0;
        }
        return (int)Math.floor(a + 0.5f);
    }

    public static final long round(double a) {
        if (a != a) {
            return 0L;
        }
        return (long)Math.floor(a + 0.5);
    }

    public static final synchronized double random() {
        if (rand == null) {
            rand = new Random();
        }
        return rand.nextDouble();
    }

    public static final double toRadians(double degrees) {
        return degrees * Math.PI / 180.0;
    }

    public static final double toDegrees(double rads) {
        return rads * 180.0 / Math.PI;
    }

    private Math() {
    }

    static {
        System.loadLibrary("javalang");
    }
}

