/*
 * Decompiled with CFR 0.152.
 */
package org.sablecc.sablecc;

import java.util.HashSet;
import java.util.TreeMap;
import java.util.Vector;
import org.sablecc.sablecc.ConflictException;
import org.sablecc.sablecc.LR0Item;
import org.sablecc.sablecc.LR0ItemSet;
import org.sablecc.sablecc.LR1Collection;
import org.sablecc.sablecc.LR1Item;
import org.sablecc.sablecc.LR1ItemSet;
import org.sablecc.sablecc.Production;
import org.sablecc.sablecc.Symbol;
import org.sablecc.sablecc.SymbolSet;

public final class Grammar {
    private static TreeMap fastLr0Closure = new TreeMap();
    private static TreeMap fastLr1Closure = new TreeMap();
    static int startSymbol;
    static int startProduction;
    static int eof;
    static int dummy;
    static int[][][] action_;
    static int[][] goto_;
    static SymbolSet[] FIRST_Terminal;
    static SymbolSet[] FIRST_Nonterminal;
    static SymbolSet[] FOLLOW;

    private Grammar() {
    }

    public static int addTerminal(String name, String errorName) {
        return new Symbol((String)name, (String)errorName, (boolean)true).index;
    }

    public static int addNonterminal(String name) {
        return new Symbol((String)name, null, (boolean)false).index;
    }

    public static int addProduction(String nonterminal, String name) {
        Symbol symbol = Symbol.symbol(nonterminal);
        if (symbol.terminal) {
            throw new IllegalArgumentException("The symbol " + nonterminal + " is a terminal.");
        }
        return new Production((int)symbol.index, (String)name).index;
    }

    public static void addSymbolToProduction(String symbol, int production) {
        Production.production(production).addSymbol(Symbol.symbol(symbol));
    }

    public static void reinit() {
        fastLr0Closure = new TreeMap();
        fastLr1Closure = new TreeMap();
        startSymbol = 0;
        startProduction = -1;
        eof = -1;
        dummy = -1;
        action_ = null;
        goto_ = null;
    }

    public static void computeLALR() throws ConflictException {
        eof = Grammar.addTerminal("EOF", "EOF");
        dummy = Grammar.addTerminal("#", null);
        startSymbol = Grammar.addNonterminal("Start");
        Production start = new Production(startSymbol, "Start");
        start.addSymbol(Symbol.symbol(0, false));
        startProduction = start.index;
        Grammar.computeFirst();
        LR0ItemSet set = new LR0ItemSet();
        set.set(new LR0Item(startProduction, 0));
        LR1Collection collection = new LR1Collection(set);
        LR0ItemSet[] sets = collection.collection.sets();
        Symbol[] terminals = Symbol.terminals();
        Symbol[] nonterminals = Symbol.nonterminals();
        action_ = new int[sets.length][terminals.length - 1][];
        goto_ = new int[sets.length][nonterminals.length - 1];
        HashSet<String> listOfConflictualProds = new HashSet<String>();
        StringBuffer conflictMessage = new StringBuffer();
        for (int i = 0; i < sets.length; ++i) {
            Integer destination;
            int k;
            int j;
            System.out.print(".");
            LR1ItemSet state = new LR1ItemSet();
            Comparable[] items = sets[i].items();
            for (j = 0; j < items.length; ++j) {
                Symbol[] lookaheads = ((SymbolSet)collection.lookaheads[i].get(items[j])).getSymbols();
                for (k = 0; k < lookaheads.length; ++k) {
                    state.set(new LR1Item((LR0Item)items[j], lookaheads[k].index));
                }
            }
            state = Grammar.CLOSURE(state);
            items = state.items();
            for (j = 0; j < terminals.length; ++j) {
                destination = collection.collection.GOTO(i, terminals[j]);
                if (destination != null) {
                    Grammar.action_[i][j] = new int[]{0, destination};
                }
                for (k = 0; k < items.length; ++k) {
                    Production production = Production.production(((LR1Item)items[k]).lr0Item.production);
                    try {
                        production.rightside(((LR1Item)items[k]).lr0Item.position);
                        continue;
                    }
                    catch (Exception e) {
                        int[] action;
                        if (production.leftside != startSymbol) {
                            if (((LR1Item)items[k]).terminal != terminals[j].index) continue;
                            action = action_[i][j];
                            if (action != null) {
                                listOfConflictualProds.add(Symbol.symbol(production.leftside, false).toString());
                                switch (action[0]) {
                                    case 0: {
                                        conflictMessage.append("\n\nshift/reduce conflict in state [stack:" + collection.collection.names.elementAt(i) + "*] on " + terminals[j] + " in " + state.toString(terminals[j]));
                                        break;
                                    }
                                    case 1: {
                                        conflictMessage.append("\n\nreduce/reduce conflict in state [stack:" + collection.collection.names.elementAt(i) + "*] on " + terminals[j] + " in " + state.toString(terminals[j]));
                                        listOfConflictualProds.add(Symbol.symbol(Production.production((int)action[1]).leftside, false).toString());
                                        break;
                                    }
                                    case 2: {
                                        conflictMessage.append("\n\nreduce/accept conflict in state [stack:" + collection.collection.names.elementAt(i) + "*] on " + terminals[j] + " in " + state.toString(terminals[j]));
                                        listOfConflictualProds.add(Symbol.symbol(Production.production((int)action[1]).leftside, false).toString());
                                    }
                                }
                                continue;
                            }
                            Grammar.action_[i][j] = new int[]{1, ((LR1Item)items[k]).lr0Item.production};
                            continue;
                        }
                        if (terminals[j].index != eof) continue;
                        action = action_[i][j];
                        if (action != null) {
                            listOfConflictualProds.add(Symbol.symbol(production.leftside, false).toString());
                            switch (action[0]) {
                                case 0: {
                                    conflictMessage.append("shift/accept conflict in state [stack:" + collection.collection.names.elementAt(i) + "*] on " + terminals[j] + " in " + state);
                                    break;
                                }
                                case 1: {
                                    conflictMessage.append("reduce/accept conflict in state [stack:" + collection.collection.names.elementAt(i) + "*] on " + terminals[j] + " in " + state);
                                    listOfConflictualProds.add(Symbol.symbol(Production.production((int)action[1]).leftside, false).toString());
                                }
                            }
                            continue;
                        }
                        Grammar.action_[i][j] = new int[]{2};
                    }
                }
            }
            if (listOfConflictualProds.size() > 0) {
                throw new ConflictException(listOfConflictualProds, conflictMessage.toString());
            }
            for (j = 0; j < nonterminals.length - 1; ++j) {
                destination = collection.collection.GOTO(i, nonterminals[j]);
                Grammar.goto_[i][j] = destination != null ? destination : -1;
            }
        }
        System.out.println();
    }

    static void computeFirst() {
        boolean changed;
        int i;
        Symbol[] terminals = Symbol.terminals();
        Symbol[] nonterminals = Symbol.nonterminals();
        Production[] productions = Production.productions();
        FIRST_Terminal = new SymbolSet[terminals.length];
        for (i = 0; i < terminals.length; ++i) {
            Grammar.FIRST_Terminal[i] = new SymbolSet();
        }
        FIRST_Nonterminal = new SymbolSet[nonterminals.length];
        for (i = 0; i < nonterminals.length; ++i) {
            Grammar.FIRST_Nonterminal[i] = new SymbolSet();
        }
        for (i = 0; i < terminals.length; ++i) {
            FIRST_Terminal[i].setTerminal(terminals[i].index);
        }
        for (i = 0; i < productions.length; ++i) {
            if (productions[i].rightside().length != 0) continue;
            FIRST_Nonterminal[productions[i].leftside].setEmpty();
        }
        do {
            changed = false;
            for (int i2 = 0; i2 < productions.length; ++i2) {
                SymbolSet before = (SymbolSet)FIRST_Nonterminal[productions[i2].leftside].clone();
                FIRST_Nonterminal[productions[i2].leftside].or(Grammar.FIRST(productions[i2].rightside()));
                if (before.equals(FIRST_Nonterminal[productions[i2].leftside])) continue;
                changed = true;
            }
        } while (changed);
    }

    static SymbolSet FIRST(Symbol[] symbols) {
        return Grammar.FIRST(symbols, 0, symbols.length);
    }

    static SymbolSet FIRST(Symbol[] symbols, int begin) {
        return Grammar.FIRST(symbols, begin, symbols.length);
    }

    static SymbolSet FIRST(Symbol[] symbols, int begin, int end) {
        SymbolSet result = new SymbolSet();
        boolean previousContainsEmpty = true;
        for (int i = begin; i < end && previousContainsEmpty; ++i) {
            if (symbols[i].terminal) {
                result.or(FIRST_Terminal[symbols[i].index]);
                previousContainsEmpty = FIRST_Terminal[symbols[i].index].getEmpty();
                continue;
            }
            result.or(FIRST_Nonterminal[symbols[i].index]);
            previousContainsEmpty = FIRST_Nonterminal[symbols[i].index].getEmpty();
        }
        if (previousContainsEmpty) {
            result.setEmpty();
        } else {
            result.clearEmpty();
        }
        return result;
    }

    static void computeFollow() {
        boolean changed;
        int i;
        Symbol[] nonterminals = Symbol.nonterminals();
        Production[] productions = Production.productions();
        FOLLOW = new SymbolSet[nonterminals.length];
        for (i = 0; i < nonterminals.length; ++i) {
            Grammar.FOLLOW[i] = new SymbolSet();
        }
        FOLLOW[startSymbol].setTerminal(eof);
        for (i = 0; i < productions.length; ++i) {
            Symbol[] rightside = productions[i].rightside();
            for (int j = 0; j < rightside.length; ++j) {
                if (rightside[j].terminal) continue;
                SymbolSet set = Grammar.FIRST(rightside, j + 1);
                set.clearEmpty();
                FOLLOW[rightside[j].index].or(set);
            }
        }
        do {
            changed = false;
            for (int i2 = 0; i2 < productions.length; ++i2) {
                Symbol[] rightside = productions[i2].rightside();
                for (int j = 0; j < rightside.length; ++j) {
                    if (rightside[j].terminal) continue;
                    SymbolSet before = (SymbolSet)FOLLOW[rightside[j].index].clone();
                    if (Grammar.FIRST(rightside, j + 1).getEmpty()) {
                        FOLLOW[rightside[j].index].or(FOLLOW[productions[i2].leftside]);
                    }
                    if (before.equals(FOLLOW[rightside[j].index])) continue;
                    changed = true;
                }
            }
        } while (changed);
    }

    static SymbolSet FOLLOW(int nonterminal) {
        return FOLLOW[nonterminal];
    }

    static LR0ItemSet CLOSURE(LR0Item item) {
        boolean modified;
        LR0ItemSet result = (LR0ItemSet)fastLr0Closure.get(item);
        if (result != null) {
            return result;
        }
        result = new LR0ItemSet();
        result.set(item);
        LR0ItemSet newItems = result;
        do {
            modified = false;
            LR0Item[] items = newItems.items();
            newItems = new LR0ItemSet();
            for (int i = 0; i < items.length; ++i) {
                Production production = Production.production(items[i].production);
                Symbol[] rightside = production.rightside();
                if (items[i].position >= rightside.length) continue;
                Symbol symbol = rightside[items[i].position];
                if (symbol.terminal) continue;
                Production[] alternatives = Production.alternatives(symbol.index);
                for (int j = 0; j < alternatives.length; ++j) {
                    LR0Item newItem = new LR0Item(alternatives[j].index, 0);
                    if (result.get(newItem)) continue;
                    result.set(newItem);
                    newItems.set(newItem);
                    modified = true;
                }
            }
        } while (modified);
        fastLr0Closure.put(item, result);
        return result;
    }

    static LR0ItemSet CLOSURE(LR0ItemSet set) {
        LR0ItemSet result = new LR0ItemSet();
        LR0Item[] setItems = set.items();
        for (int i = 0; i < setItems.length; ++i) {
            LR0Item[] items = Grammar.CLOSURE(setItems[i]).items();
            for (int j = 0; j < items.length; ++j) {
                result.set(items[j]);
            }
        }
        return result;
    }

    static LR1ItemSet CLOSURE(LR1Item item) {
        boolean modified;
        LR1ItemSet result = (LR1ItemSet)fastLr1Closure.get(item);
        if (result != null) {
            return result;
        }
        result = new LR1ItemSet();
        result.set(item);
        LR1ItemSet newItems = result;
        do {
            modified = false;
            LR1Item[] items = newItems.items();
            newItems = new LR1ItemSet();
            for (int i = 0; i < items.length; ++i) {
                Production production = Production.production(items[i].lr0Item.production);
                Symbol[] rightside = production.rightside();
                if (items[i].lr0Item.position >= rightside.length) continue;
                Symbol symbol = rightside[items[i].lr0Item.position];
                if (symbol.terminal) continue;
                Vector<Symbol> tailVector = new Vector<Symbol>(0);
                for (int k = items[i].lr0Item.position + 1; k < rightside.length; ++k) {
                    tailVector.addElement(rightside[k]);
                }
                tailVector.addElement(Symbol.symbol(items[i].terminal, true));
                Object[] tail = new Symbol[tailVector.size()];
                tailVector.copyInto(tail);
                Symbol[] symbols = Grammar.FIRST((Symbol[])tail).getSymbols();
                Production[] alternatives = Production.alternatives(symbol.index);
                for (int k = 0; k < symbols.length; ++k) {
                    if (!symbols[k].terminal) continue;
                    for (int j = 0; j < alternatives.length; ++j) {
                        LR1Item newItem = new LR1Item(new LR0Item(alternatives[j].index, 0), symbols[k].index);
                        if (result.get(newItem)) continue;
                        result.set(newItem);
                        newItems.set(newItem);
                        modified = true;
                    }
                }
            }
        } while (modified);
        fastLr1Closure.put(item, result);
        return result;
    }

    static LR1ItemSet CLOSURE(LR1ItemSet set) {
        LR1ItemSet result = new LR1ItemSet();
        LR1Item[] setItems = set.items();
        for (int i = 0; i < setItems.length; ++i) {
            LR1Item[] items = Grammar.CLOSURE(new LR1Item(setItems[i].lr0Item, dummy)).items();
            for (int j = 0; j < items.length; ++j) {
                result.set(new LR1Item(items[j].lr0Item, items[j].terminal == dummy ? setItems[i].terminal : items[j].terminal));
            }
        }
        return result;
    }

    static LR0ItemSet GOTO(LR0ItemSet set, Symbol symbol) {
        set = Grammar.CLOSURE(set);
        LR0ItemSet result = new LR0ItemSet();
        LR0Item[] items = set.items();
        for (int i = 0; i < items.length; ++i) {
            Production production = Production.production(items[i].production);
            Symbol[] rightside = production.rightside();
            if (items[i].position >= rightside.length || !symbol.equals(rightside[items[i].position])) continue;
            result.set(new LR0Item(items[i].production, items[i].position + 1));
        }
        return result;
    }

    static {
        Grammar.reinit();
    }
}

