# Contributing to GLPI

:+1::tada: First off, thanks for taking the time to contribute! :tada::+1:

Please note that current repository is about GLPI core only. All related plugins are the responsibility of their respective owners and all requests must be done on their own systems.

**Please write only in English!**

## Security

**⚠️ Please never use standard issues to report security problems. See [security policy](https://github.com/glpi-project/glpi/security/policy) for more details. ⚠️**

## Bugs

Note that issues are handled on a best-effort basis. If you need a quick fix or any guarantee, take a look at **[profesional services](http://services.glpi-network.com/)** or [partners](https://glpi-project.org/partners/).

If you found a bug, the first steps to do are:
- check if you're using the latest version, and if not, upgrade to see if the problem remains unsolved,
- search in already existing tickets to see if someone else already reported the issue.

If the last release does not solve the issue and there are no existing tickets, create one using the bug report template. Be sure you provide all requested details, log entries, and whatever may be useful to understand and reproduce the issue.

If developers are not able to reproduce the issue, it may not be fixed.

## Features

If you want to work on a new feature, open a ticket using the feature template, so we can discuss on it.

If you're just asking for something to be added without doing it yourself, please consider adding (or upvoting) an enhancement on the [suggestion website](https//suggest.glpi-project.org).

## Support request

You have a question on GLPI usage, or want to know what are the capabilities.

Current repository is not the right place for that. You may try to ask your question on [the forums](https://forum.glpi-project.org), on the mailing lists, on telegram channels, ...

## Coding

If you want to contribute to the project code, please take a time to read the [project coding guidelines](https://glpi-developer-documentation.readthedocs.io).
