/*
 * Decompiled with CFR 0.152.
 */
package org.opensolaris.opengrok.jdbc;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import org.opensolaris.opengrok.jdbc.ConnectionManager;
import org.opensolaris.opengrok.jdbc.StatementCreator;

public class ConnectionResource {
    private final Connection conn;
    private final Map<StatementCreator, PreparedStatement> statements = new HashMap<StatementCreator, PreparedStatement>();

    ConnectionResource(ConnectionManager manager) throws SQLException {
        this.conn = manager.openConnection();
        this.conn.setAutoCommit(false);
    }

    public boolean isValid() throws SQLException {
        return this.conn.isValid(10);
    }

    public void commit() throws SQLException {
        this.conn.commit();
    }

    public void rollback() throws SQLException {
        this.conn.rollback();
    }

    public PreparedStatement getStatement(StatementCreator creator) throws SQLException {
        PreparedStatement ps = this.statements.get(creator);
        if (ps == null || ps.isClosed()) {
            ps = creator.create(this.conn);
            this.statements.put(creator, ps);
        }
        return ps;
    }

    public Statement createStatement() throws SQLException {
        return this.conn.createStatement();
    }

    public PreparedStatement prepareStatement(String sql) throws SQLException {
        return this.conn.prepareStatement(sql);
    }

    public DatabaseMetaData getMetaData() throws SQLException {
        return this.conn.getMetaData();
    }
}

