/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.rewrite.handler;

import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.rewrite.handler.PatternRule;

public class ResponsePatternRule
extends PatternRule {
    private String _code;
    private String _reason = "";

    public ResponsePatternRule() {
        this._handling = true;
        this._terminating = true;
    }

    public void setCode(String code) {
        this._code = code;
    }

    public void setReason(String reason) {
        this._reason = reason;
    }

    @Override
    public String apply(String target, HttpServletRequest request, HttpServletResponse response) throws IOException {
        int code = Integer.parseInt(this._code);
        if (code >= 400) {
            response.sendError(code, this._reason);
        } else {
            response.setStatus(code);
        }
        return target;
    }

    @Override
    public String toString() {
        return super.toString() + "[" + this._code + "," + this._reason + "]";
    }
}

