/*
 * Decompiled with CFR 0.152.
 */
package org.flexdock.dockbar;

import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import org.flexdock.dockbar.Dockbar;
import org.flexdock.dockbar.util.TextIcon;
import org.flexdock.docking.Dockable;
import org.flexdock.docking.DockingManager;
import org.flexdock.docking.props.DockablePropertySet;
import org.flexdock.plaf.common.border.RoundedLineBorder;

public class DockbarLabel
extends JLabel
implements MouseListener {
    private static final Insets[] INSETS = DockbarLabel.createInsets();
    private static final int[] ROTATIONS = DockbarLabel.createRotations();
    private String dockingId;
    private boolean mSelected = false;
    private RoundedLineBorder mBorder;
    private boolean mInPaint = false;
    private boolean mActive = false;
    private int mDefaultOrientation;

    private static Insets[] createInsets() {
        Insets[] insets = new Insets[5];
        insets[0] = new Insets(1, 1, 1, 1);
        insets[2] = new Insets(1, 1, 2, 1);
        insets[4] = new Insets(1, 1, 2, 1);
        insets[1] = new Insets(1, 1, 1, 2);
        insets[3] = new Insets(1, 1, 1, 2);
        return insets;
    }

    private static int[] createRotations() {
        int[] rotations = new int[5];
        rotations[0] = 1;
        rotations[2] = 2;
        rotations[4] = 4;
        rotations[1] = 1;
        rotations[3] = 1;
        return rotations;
    }

    public DockbarLabel(String dockableId) {
        this(dockableId, 2);
    }

    public DockbarLabel(String dockableId, int defaultOrientation) {
        this.dockingId = dockableId;
        this.mDefaultOrientation = Dockbar.getValidOrientation(defaultOrientation);
        this.mBorder = new RoundedLineBorder(Color.lightGray, 3);
        this.setBorder(new CompoundBorder(new EmptyBorder(new Insets(1, 1, 1, 1)), this.mBorder));
        this.addMouseListener(this);
        TextIcon icon = new TextIcon(this, 2, 1);
        this.setIcon(icon);
        this.updateIcon();
        icon.validate();
    }

    public Border getBorder() {
        return this.mInPaint ? null : super.getBorder();
    }

    public void paintComponent(Graphics g) {
        this.mInPaint = false;
        this.paintBorder(g);
        this.mInPaint = true;
        super.paintComponent(g);
    }

    public void paint(Graphics g) {
        this.mInPaint = true;
        super.paint(g);
        this.mInPaint = false;
    }

    public void setActive(boolean active) {
        if (this.mActive != active) {
            this.mActive = active;
            this.updateBorder();
            this.repaint();
        }
    }

    private void updateBorder() {
        this.mBorder.setFilled(this.mSelected || this.mActive);
    }

    protected void activate(boolean lock) {
        Dockbar dockbar = (Dockbar)SwingUtilities.getAncestorOfClass(Dockbar.class, this);
        if (dockbar != null) {
            dockbar.activate(this.dockingId, lock);
        }
    }

    private void setSelected(boolean selected) {
        if (this.mSelected != selected) {
            this.mSelected = selected;
            this.updateBorder();
            this.repaint();
        }
    }

    protected void validateTree() {
        this.updateBorderInsets();
        this.updateIcon();
        super.validateTree();
    }

    private void updateIcon() {
        DockablePropertySet p;
        Icon obj = this.getIcon();
        if (!(obj instanceof TextIcon)) {
            return;
        }
        Dockable d = this.getDockable();
        DockablePropertySet dockablePropertySet = p = d == null ? null : d.getDockingProperties();
        if (p == null) {
            return;
        }
        int orientation = this.getOrientation();
        int rotation = ROTATIONS[orientation];
        Icon dockIcon = p.getDockbarIcon();
        if (dockIcon == null) {
            dockIcon = p.getTabIcon();
        }
        String text = p.getDockableDesc();
        TextIcon icon = (TextIcon)obj;
        icon.setIcon(dockIcon);
        icon.setText(text);
        icon.setRotation(rotation);
    }

    public void setIcon(Icon icon) {
        Icon currIcon = this.getIcon();
        if (currIcon instanceof TextIcon) {
            ((TextIcon)currIcon).setIcon(icon);
        } else {
            super.setIcon(icon);
        }
        this.revalidate();
    }

    public void setText(String text) {
        Icon currIcon = this.getIcon();
        if (currIcon instanceof TextIcon) {
            ((TextIcon)currIcon).setText(text);
        } else {
            super.setText(text);
        }
        this.revalidate();
    }

    private void updateBorderInsets() {
        EmptyBorder insetBorder;
        Border border = super.getBorder();
        border = border instanceof CompoundBorder ? ((CompoundBorder)border).getOutsideBorder() : null;
        EmptyBorder emptyBorder = insetBorder = border instanceof EmptyBorder ? (EmptyBorder)border : null;
        if (insetBorder != null) {
            int orientation = this.getOrientation();
            Insets insets = INSETS[orientation];
            Insets borderInsets = insetBorder.getBorderInsets();
            borderInsets.top = insets.top;
            borderInsets.left = insets.left;
            borderInsets.bottom = insets.bottom;
            borderInsets.right = insets.right;
        }
    }

    public Dockable getDockable() {
        return DockingManager.getDockable(this.dockingId);
    }

    public int getOrientation() {
        Container cnt = this.getParent();
        if (cnt instanceof Dockbar) {
            return ((Dockbar)cnt).getOrientation();
        }
        return this.mDefaultOrientation;
    }

    public Dimension getPreferredSize() {
        Icon tmp = this.getIcon();
        if (!(tmp instanceof TextIcon)) {
            return super.getPreferredSize();
        }
        Insets insets = this.getInsets();
        TextIcon icon = (TextIcon)tmp;
        int w = insets.left + icon.getIconWidth() + insets.right;
        int h = insets.top + icon.getIconHeight() + insets.bottom;
        return new Dimension(w, h);
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void mouseClicked(MouseEvent e) {
        if (e.getButton() != 1) {
            return;
        }
        this.activate(true);
    }

    public void mouseEntered(MouseEvent e) {
        this.activate(false);
    }

    public void mouseExited(MouseEvent e) {
    }
}

