/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.authz.support;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.xcontent.DeprecationHandler;
import org.elasticsearch.common.xcontent.LoggingDeprecationHandler;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.script.Script;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.script.ScriptType;
import org.elasticsearch.script.TemplateScript;
import org.elasticsearch.xpack.core.security.user.User;

public final class SecurityQueryTemplateEvaluator {
    private SecurityQueryTemplateEvaluator() {
    }

    public static String evaluateTemplate(String querySource, ScriptService scriptService, User user) throws IOException {
        try (XContentParser parser = XContentFactory.xContent((CharSequence)querySource).createParser(NamedXContentRegistry.EMPTY, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, querySource);){
            XContentParser.Token token = parser.nextToken();
            if (token != XContentParser.Token.START_OBJECT) {
                throw new ElasticsearchParseException("Unexpected token [" + token + "]", new Object[0]);
            }
            token = parser.nextToken();
            if (token != XContentParser.Token.FIELD_NAME) {
                throw new ElasticsearchParseException("Unexpected token [" + token + "]", new Object[0]);
            }
            if ("template".equals(parser.currentName())) {
                token = parser.nextToken();
                if (token != XContentParser.Token.START_OBJECT) {
                    throw new ElasticsearchParseException("Unexpected token [" + token + "]", new Object[0]);
                }
                Script script = Script.parse((XContentParser)parser);
                HashMap params = new HashMap();
                if (script.getParams() != null) {
                    params.putAll(script.getParams());
                }
                HashMap<String, Object> userModel = new HashMap<String, Object>();
                userModel.put("username", user.principal());
                userModel.put("full_name", user.fullName());
                userModel.put("email", user.email());
                userModel.put("roles", Arrays.asList(user.roles()));
                userModel.put("metadata", Collections.unmodifiableMap(user.metadata()));
                params.put("_user", userModel);
                script = new Script(script.getType(), script.getType() == ScriptType.STORED ? null : "mustache", script.getIdOrCode(), script.getOptions(), params);
                TemplateScript compiledTemplate = ((TemplateScript.Factory)scriptService.compile(script, TemplateScript.CONTEXT)).newInstance(script.getParams());
                String string = compiledTemplate.execute();
                return string;
            }
            String string = querySource;
            return string;
        }
    }
}

