/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.cluster.tcp;

import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.catalina.cluster.tcp.WorkerThread;

public class ThreadPool {
    List idle = new LinkedList();
    Object mutex = new Object();
    Object interestOpsMutex = null;

    ThreadPool(int poolSize, Class threadClass, Object interestOpsMutex) throws Exception {
        this.interestOpsMutex = interestOpsMutex;
        for (int i = 0; i < poolSize; ++i) {
            WorkerThread thread = (WorkerThread)threadClass.newInstance();
            thread.setPool(this);
            thread.setName(threadClass.getName() + "[" + (i + 1) + "]");
            thread.setDaemon(true);
            thread.setPriority(10);
            thread.start();
            this.idle.add(thread);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    WorkerThread getWorker() {
        WorkerThread worker = null;
        Object object = this.mutex;
        synchronized (object) {
            while (worker == null) {
                if (this.idle.size() > 0) {
                    try {
                        worker = (WorkerThread)this.idle.remove(0);
                    }
                    catch (NoSuchElementException x) {
                        worker = null;
                    }
                    continue;
                }
                try {
                    this.mutex.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        return worker;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void returnWorker(WorkerThread worker) {
        Object object = this.mutex;
        synchronized (object) {
            this.idle.add(worker);
            this.mutex.notify();
        }
    }

    public Object getInterestOpsMutex() {
        return this.interestOpsMutex;
    }
}

