/*
 * Decompiled with CFR 0.152.
 */
package com.addthis.metrics3.reporter.config;

import com.addthis.metrics.reporter.config.AbstractReporterConfig;
import com.addthis.metrics3.reporter.config.ConsoleReporterConfig;
import com.addthis.metrics3.reporter.config.CsvReporterConfig;
import com.addthis.metrics3.reporter.config.GangliaReporterConfig;
import com.addthis.metrics3.reporter.config.GraphiteReporterConfig;
import com.addthis.metrics3.reporter.config.RiemannReporterConfig;
import com.codahale.metrics.MetricRegistry;
import java.io.IOException;
import java.util.List;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReporterConfig
extends AbstractReporterConfig {
    private static final Logger log = LoggerFactory.getLogger(ReporterConfig.class);
    @Valid
    private List<ConsoleReporterConfig> console;
    @Valid
    private List<CsvReporterConfig> csv;
    @Valid
    private List<GangliaReporterConfig> ganglia;
    @Valid
    private List<GraphiteReporterConfig> graphite;
    @Valid
    private List<RiemannReporterConfig> riemann;

    public List<ConsoleReporterConfig> getConsole() {
        return this.console;
    }

    public void setConsole(List<ConsoleReporterConfig> console) {
        this.console = console;
    }

    public List<CsvReporterConfig> getCsv() {
        return this.csv;
    }

    public void setCsv(List<CsvReporterConfig> csv) {
        this.csv = csv;
    }

    public List<GangliaReporterConfig> getGanglia() {
        return this.ganglia;
    }

    public void setGanglia(List<GangliaReporterConfig> ganglia) {
        this.ganglia = ganglia;
    }

    public List<GraphiteReporterConfig> getGraphite() {
        return this.graphite;
    }

    public void setGraphite(List<GraphiteReporterConfig> graphite) {
        this.graphite = graphite;
    }

    public List<RiemannReporterConfig> getRiemann() {
        return this.riemann;
    }

    public void setRiemann(List<RiemannReporterConfig> riemann) {
        this.riemann = riemann;
    }

    public boolean enableConsole(MetricRegistry registry) {
        boolean failures = false;
        if (this.console == null) {
            log.debug("Asked to enable console, but it was not configured");
            return false;
        }
        for (ConsoleReporterConfig consoleConfig : this.console) {
            if (consoleConfig.enable(registry)) continue;
            failures = true;
        }
        return !failures;
    }

    public boolean enableCsv(MetricRegistry registry) {
        boolean failures = false;
        if (this.csv == null) {
            log.debug("Asked to enable csv, but it was not configured");
            return false;
        }
        for (CsvReporterConfig csvConfig : this.csv) {
            if (csvConfig.enable(registry)) continue;
            failures = true;
        }
        return !failures;
    }

    public boolean enableGanglia(MetricRegistry registry) {
        boolean failures = false;
        if (this.ganglia == null) {
            log.debug("Asked to enable ganglia, but it was not configured");
            return false;
        }
        for (GangliaReporterConfig gangliaConfig : this.ganglia) {
            if (gangliaConfig.enable(registry)) continue;
            failures = true;
        }
        return !failures;
    }

    public boolean enableGraphite(MetricRegistry registry) {
        boolean failures = false;
        if (this.graphite == null) {
            log.debug("Asked to enable graphite, but it was not configured");
            return false;
        }
        for (GraphiteReporterConfig graphiteConfig : this.graphite) {
            if (graphiteConfig.enable(registry)) continue;
            failures = true;
        }
        return !failures;
    }

    public boolean enableRiemann(MetricRegistry registry) {
        boolean failures = false;
        if (this.riemann == null) {
            log.debug("Asked to enable riemann, but it was not configured");
            return false;
        }
        for (RiemannReporterConfig riemannConfig : this.riemann) {
            if (riemannConfig.enable(registry)) continue;
            failures = true;
        }
        return !failures;
    }

    public boolean enableAll(MetricRegistry registry) {
        boolean enabled = false;
        if (this.console != null && this.enableConsole(registry)) {
            enabled = true;
        }
        if (this.csv != null && this.enableCsv(registry)) {
            enabled = true;
        }
        if (this.ganglia != null && this.enableGanglia(registry)) {
            enabled = true;
        }
        if (this.graphite != null && this.enableGraphite(registry)) {
            enabled = true;
        }
        if (this.riemann != null && this.enableRiemann(registry)) {
            enabled = true;
        }
        if (!enabled) {
            log.warn("No reporters were succesfully enabled");
        }
        return enabled;
    }

    public static ReporterConfig loadFromFileAndValidate(String fileName) throws IOException {
        ReporterConfig config = ReporterConfig.loadFromFile(fileName);
        if (ReporterConfig.validate((Object)((Object)config))) {
            return config;
        }
        throw new AbstractReporterConfig.ReporterConfigurationException("configuration failed validation");
    }

    public static ReporterConfig loadFromFile(String fileName) throws IOException {
        return (ReporterConfig)((Object)AbstractReporterConfig.loadFromFile((String)fileName, ReporterConfig.class));
    }
}

