/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.functions;

import com.datastax.driver.core.DataType;
import java.lang.constant.Constable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.util.List;
import org.apache.cassandra.cql3.CQL3Type;
import org.apache.cassandra.db.marshal.AbstractType;

public final class UDHelper {
    static final MethodHandle methodParseOne;

    public static Class<?>[] javaTypes(DataType[] dataTypes, boolean calledOnNullInput) {
        Class[] paramTypes = new Class[dataTypes.length];
        for (int i = 0; i < paramTypes.length; ++i) {
            Class<Constable> clazz = dataTypes[i].asJavaClass();
            if (!calledOnNullInput) {
                if (clazz == Integer.class) {
                    clazz = Integer.TYPE;
                } else if (clazz == Long.class) {
                    clazz = Long.TYPE;
                } else if (clazz == Byte.class) {
                    clazz = Byte.TYPE;
                } else if (clazz == Short.class) {
                    clazz = Short.TYPE;
                } else if (clazz == Float.class) {
                    clazz = Float.TYPE;
                } else if (clazz == Double.class) {
                    clazz = Double.TYPE;
                } else if (clazz == Boolean.class) {
                    clazz = Boolean.TYPE;
                }
            }
            paramTypes[i] = clazz;
        }
        return paramTypes;
    }

    public static DataType[] driverTypes(List<AbstractType<?>> abstractTypes) {
        DataType[] argDataTypes = new DataType[abstractTypes.size()];
        for (int i = 0; i < argDataTypes.length; ++i) {
            argDataTypes[i] = UDHelper.driverType(abstractTypes.get(i));
        }
        return argDataTypes;
    }

    public static DataType driverType(AbstractType abstractType) {
        CQL3Type cqlType = abstractType.asCQL3Type();
        try {
            return methodParseOne.invoke(cqlType.getType().toString());
        }
        catch (Error | RuntimeException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new RuntimeException("cannot parse driver type " + cqlType.getType().toString(), e);
        }
    }

    public static boolean isNullOrEmpty(AbstractType<?> type, ByteBuffer bb) {
        return bb == null || bb.remaining() == 0 && type.isEmptyValueMeaningless();
    }

    static {
        try {
            Class<?> cls = Class.forName("com.datastax.driver.core.CassandraTypeParser");
            Method m = cls.getDeclaredMethod("parseOne", String.class);
            m.setAccessible(true);
            methodParseOne = MethodHandles.lookup().unreflect(m);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

