/*
 * Decompiled with CFR 0.152.
 */
package cycinf.cvars.usedtype;

import cycinf.cvars.usedtype.Identifier;
import cycinf.cvars.usedtype.UsedTypeList;
import cycinf.util.ParseException;
import cycinf.util.ParsingUtils;
import general.util.Validator;
import java.text.MessageFormat;

public class ConstructorArgumentList
extends UsedTypeList {
    private final Identifier datatype;
    private final Identifier constructor;
    private static final String l1 = "DD";
    private static final String l2 = "_DF";
    private static final MessageFormat prettyFormat = new MessageFormat("arg. #{0} to {1}.{2}");

    public final Identifier getDatatype() {
        return this.datatype;
    }

    public final Identifier getConstructor() {
        return this.constructor;
    }

    public ConstructorArgumentList(Identifier datatype, Identifier constructor) {
        this.datatype = (Identifier)Validator.nonnull((Object)datatype, (String)"datatype");
        this.constructor = (Identifier)Validator.nonnull((Object)constructor, (String)"constructor");
    }

    public final String fieldLocatorStringBase() {
        return l1 + this.getDatatype().bundle() + l2 + this.getConstructor().bundle() + "_";
    }

    public final String prettyStringForVariable(int varIndex) {
        return prettyFormat.format(new Object[]{varIndex + 1, this.getDatatype().getName(), this.getConstructor().getName()});
    }

    public static final ConstructorArgumentList parseBase1(String x) throws ParseException {
        String x1 = ParsingUtils.chopSuffix((String)x, (String)"_");
        if (x1 == null) {
            return null;
        }
        String x2 = ParsingUtils.chopIdentifierSuffix((String)x1);
        if (x2 == null) {
            return null;
        }
        Identifier constructor = ParsingUtils.ival;
        String x3 = ParsingUtils.chopSuffix((String)x2, (String)l2);
        if (x3 == null) {
            return null;
        }
        String x4 = ParsingUtils.chopIdentifierSuffix((String)x3);
        if (x4 == null) {
            throw new ParseException("ConstructorArgumentList missing datatype name: " + x);
        }
        Identifier datatype = ParsingUtils.ival;
        if (!x4.equals(l1)) {
            throw new ParseException("ConstructorArgumentList should have exactly DD in front: " + x);
        }
        return new ConstructorArgumentList(datatype, constructor);
    }
}

