/*
 * Decompiled with CFR 0.152.
 */
package cycinf.cvars;

import cycinf.cvars.Cvalue;
import cycinf.cvars.Cvar;
import cycinf.infstats.BelongsToInfstats;
import cycinf.infstats.DirInfstats;
import cycinf.util.Markable;
import cycinf.util.SourceLocation;
import general.util.Validator;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;

public abstract class Decision
implements Markable,
BelongsToInfstats {
    private final DirInfstats owningInfstats;
    private final SourceLocation location;
    private IMarker marker = null;
    private static Map<IMarker, Decision> decisionMarkerCache = new HashMap();
    private static final String markerType = "cycinf.DecisionMarker";

    public abstract Cvar getCvar();

    public abstract Cvalue getCvalue();

    public String decisionName() {
        return this.getCvalue().prettyString();
    }

    public final DirInfstats getOwningInfstats() {
        return this.owningInfstats;
    }

    public String description() {
        return String.valueOf(this.decisionName()) + ": " + this.getCvar().prettyString();
    }

    public final SourceLocation getLocation() {
        return this.location;
    }

    public final IMarker getMarker() {
        return this.marker;
    }

    public Decision(DirInfstats owningInfstats, SourceLocation location) {
        this.owningInfstats = (DirInfstats)Validator.nonnull((Object)owningInfstats, (String)"owningInfstats");
        this.location = location;
    }

    public void mark() throws CoreException {
        if (this.marker == null) {
            this.marker = this.getLocation().findFileInDir(this.getOwningInfstats().getDir()).createMarker(markerType);
            this.marker.setAttribute("lineNumber", this.getLocation().getLine());
            this.marker.setAttribute("message", (Object)this.description());
            this.marker.setAttribute("priority", 1);
            this.marker.setAttribute("severity", 0);
            decisionMarkerCache.put(this.marker, this);
        }
    }

    public void unmark() throws CoreException {
        if (this.marker != null) {
            decisionMarkerCache.remove(this.marker);
            this.marker.delete();
            this.marker = null;
        }
    }

    public static Decision lookupMarker(IMarker m) {
        return (Decision)decisionMarkerCache.get(m);
    }
}

