// -*- C++ -*- generated by wxGlade 0.3.2 on Wed Apr 14 15:59:52 2004

#include <wx/wx.h>
#include <wx/image.h>
// begin wxGlade: ::dependencies
#include <wx/spinctrl.h>
#include <wx/statline.h>
#include <wx/notebook.h>
// end wxGlade

// begin byHand
#include <wx/menu.h>
#include <wx/dynarray.h>
#include <zphoto.h>
// end

#ifndef WXZPHOTO_H
#define WXZPHOTO_H

// begin byHand


class wxZphotoProgressDialog: public wxDialog {
public:
    // begin wxGlade: wxZphotoProgressDialog::ids
    // end wxGlade

    wxZphotoProgressDialog(wxWindow* parent, int id, const wxString& title, const wxPoint& pos=wxDefaultPosition, const wxSize& size=wxDefaultSize, long style=wxDEFAULT_DIALOG_STYLE);

    // begin byHand
    void OnClose(wxCloseEvent& event);
    void OnOK(wxCommandEvent& event);
    void Start(ZphotoConfig *config, wxArrayString files, const char *path);
    void UpdateStatus(ZphotoProgress *progress);
    DECLARE_EVENT_TABLE()
    // end byHand

private:
    // begin wxGlade: wxZphotoProgressDialog::methods
    void set_properties();
    void do_layout();
    // end wxGlade

    // begin byHand
    wxWindowDisabler *disableOtherWindows;
    int total;
    const char *indexPath;
    Zphoto *zphoto;
    char **inputFiles;
    bool busyP;

    char** ConvertArrayString(wxArrayString arrayString);
    void FreeStrings(char **strings, size_t n);
    // end byHand

protected:
    // begin wxGlade: wxZphotoProgressDialog::attributes
    wxStaticText* progressStatusLabel;
    wxGauge* progressBarCurrent;
    wxStaticText* progressStatusLabelTotal;
    wxGauge* progressBarTotal;
    wxCheckBox* launchCheckBox;
    wxButton* progressOKButton;
    wxPanel* progressPanel;
    // end wxGlade
};


class wxZphotoSubject;

class wxZphotoObserver {
public:
    virtual void Update(wxZphotoSubject *subject) = 0;
    virtual void Subscribe(wxZphotoSubject *subject) = 0;
};

class wxZphotoSubject
{
public:
    virtual void Attach(wxZphotoObserver* observer) = 0;
    virtual void Notify()  = 0;
};

class wxZphotoPanel;
class wxZphotoListBox : public wxListBox, public wxZphotoSubject
{
public:
    wxZphotoListBox(wxWindow *parent, 
                    wxWindowID id,
                    const wxPoint& pos = wxDefaultPosition,
                    const wxSize& size = wxDefaultSize,
                    int n = 0, 
                    const wxString choices[] = NULL,
                    long style = 0,
                    const wxValidator& validator = wxDefaultValidator,
                    const wxString& name = wxListBoxNameStr)
        : wxListBox(parent, id, pos, size, n, choices, style, validator, name)
    {
    };

    virtual void Attach(wxZphotoObserver* observer);
    virtual void Notify();

    void Append(const wxString&  item);
    void Delete(int n);
    void Clear();
    wxString GetInputFile(int n);

    void OnChar(wxKeyEvent& event);
    void OnOpenFile(wxCommandEvent& event);
    void OnOpenDirectory(wxCommandEvent& event);
    void OnClearAll(wxCommandEvent& event);
    void OnClearSelected(wxCommandEvent& event);
    void OnContextMenu(wxContextMenuEvent& event);
    void OnListbox(wxCommandEvent& event);
    void DeleteSelectedItem(void);

private:
    wxList observers;
    wxArrayString inputFiles;

    DECLARE_EVENT_TABLE()
};

class wxZphotoStatusBar : public wxStatusBar, public wxZphotoObserver
{
public:
    wxZphotoStatusBar(wxWindow* parent, 
                      wxWindowID id,
                      long style = wxST_SIZEGRIP,
                      const wxString& name = "statusBar")
        : wxStatusBar(parent, id, style, name) 
    {
        defaultMessage = _("Please open input files");
        inputFilesListBox = NULL;
        SetFieldsCount(1);
        SetStatusText(defaultMessage, 0);
    };

    virtual void Update(wxZphotoSubject *subject);
    virtual void Subscribe(wxZphotoSubject* subject);
    virtual void UpdateMessage();

private:
    wxString defaultMessage;
    wxZphotoListBox* inputFilesListBox;
};

class wxZphotoPanel : public wxPanel, public wxZphotoObserver, public wxZphotoSubject
{
public:
    wxZphotoPanel(wxWindow* parent, 
                  wxWindowID id = -1, 
                  const wxPoint& pos = wxDefaultPosition, 
                  const wxSize& size = wxDefaultSize, 
                  long style = wxTAB_TRAVERSAL, 
                  const wxString& name = "panel") 
        : wxPanel(parent, id, pos, size, style, name)
    {
        inputFilesListBox = NULL;
        thumbnails = wxHashTable(wxKEY_STRING);
        originalSizes = wxHashTable(wxKEY_STRING);
    };

    virtual void Attach(wxZphotoObserver* observer);
    virtual void Notify();

    virtual void Update(wxZphotoSubject *subject);
    virtual void Subscribe(wxZphotoSubject* subject);

    void SetPreviewSize(int width, int height);
    void ClearPreview(wxDC &dc);
    void DrawLoadingMessage(wxDC &dc);
    wxBitmap* ResizeImage(wxBitmap bitmap);
    bool IsInputFileSelected();
    wxString GetInputFileName();
    wxBitmap* GetThumbnail();
    wxSize GetOriginalSize();

    void OnPaint(wxPaintEvent &event);
    DECLARE_EVENT_TABLE()

private:
    wxList observers;
    int previewWidth;
    int previewHeight;
    wxZphotoListBox* inputFilesListBox;
    wxHashTable thumbnails;
    wxHashTable originalSizes;
};

class wxZphotoInfoLabel : public wxStaticText, public wxZphotoObserver
{
public:
    wxZphotoInfoLabel(wxWindow* parent, 
                      wxWindowID id,
                      const wxString& label,
                      const wxPoint& pos = wxDefaultPosition,
                      const wxSize& size = wxDefaultSize,
                      long style = 0,
                      const wxString& name = "staticText") :
        wxStaticText(parent, id, label, pos, size, style, name)
    {
        Hide();
    };

    virtual void Update(wxZphotoSubject *subject);
    virtual void Subscribe(wxZphotoSubject* subject);

private:
    wxZphotoPanel *previewPanel;
};

class wxZphotoInfoContentLabel : public wxStaticText, public wxZphotoObserver
{
public:
    wxZphotoInfoContentLabel(wxWindow* parent, 
                             wxWindowID id,
                             const wxString& label,
                             const wxPoint& pos = wxDefaultPosition,
                             const wxSize& size = wxDefaultSize,
                             long style = 0,
                             const wxString& name = "staticText") :
        wxStaticText(parent, id, label, pos, size, style, name)
    {
        Hide();
    };

    virtual void Update(wxZphotoSubject *subject);
    virtual void Subscribe(wxZphotoSubject* subject);

private:
    wxZphotoPanel *previewPanel;
};

// For validating "gamma correction" value.
class wxZphotoTextCtrl : public wxTextCtrl
{
public:
    wxZphotoTextCtrl(wxWindow* parent, 
                     wxWindowID id, 
                     const wxString& value = "",
                     const wxPoint& pos = wxDefaultPosition, 
                     const wxSize& size = wxDefaultSize, 
                     long style = 0,
                     const wxValidator& validator = wxDefaultValidator,
                     const wxString& name = wxTextCtrlNameStr) 
        : wxTextCtrl(parent, id, value, pos, size, style, validator, name)
    {
        previousValue = "";
    };

    void OnFocusGot(wxFocusEvent& event);
    void OnFocusLost(wxFocusEvent& event);
    DECLARE_EVENT_TABLE()

private:
    wxString previousValue;
};
// end byhand

// For validating integer values.
class wxZphotoSpinCtrl : public wxSpinCtrl
{
public:
    wxZphotoSpinCtrl(wxWindow* parent, 
                     wxWindowID id = -1, 
                     const wxString& value = wxEmptyString, 
                     const wxPoint& pos = wxDefaultPosition, 
                     const wxSize& size = wxDefaultSize,
                     long style = wxSP_ARROW_KEYS,
                     int min = 0,
                     int max = 100,
                     int initial = 0,
                     const wxString& name = _T("wxSpinCtrl"))
        : wxSpinCtrl(parent, id, value, pos, size, style, min, max, initial, name)
    {
    };

    void OnFocusLost(wxFocusEvent& event);
    DECLARE_EVENT_TABLE()

private:
    wxString previousValue;
};
// end byhand

class wxZphotoFrame: public wxFrame {
public:
    // begin wxGlade: wxZphotoFrame::ids
    // end wxGlade

    wxZphotoFrame(wxWindow* parent, int id, const wxString& title, const wxPoint& pos=wxDefaultPosition, const wxSize& size=wxDefaultSize, long style=wxDEFAULT_FRAME_STYLE);


    // begin byHand
    void OnFocusLostValidateValues(wxFocusEvent& event);
    void OnUpdateUIHasFiles(wxUpdateUIEvent& event);
    void OnUpdateUIIsSelected(wxUpdateUIEvent& event);

    void OpenInputFiles();
    void OpenInputDirectory();

    void OnOpenFile(wxCommandEvent& event);
    void OnOpenDirectory(wxCommandEvent& event);
    void OnClearSelected(wxCommandEvent& event);
    void OnClearAll(wxCommandEvent& event);
    void OnQuit(wxCommandEvent& event);
    void OnClose(wxCloseEvent& event);
    void OnMenuClose(wxMenuEvent& event);
    void OnAbout(wxCommandEvent& event);
    void OnCreatePhotoAlbum(wxCommandEvent& event);

    void OnChooseFlashFont(wxCommandEvent& event);
    void OnChooseOutputDirectory(wxCommandEvent& event);
    void OnChooseTemplateDirectory(wxCommandEvent& event);

    void OnChooseBackgroundColor(wxCommandEvent& event);
    void OnChooseBorderActiveColor(wxCommandEvent& event);
    void OnChooseBorderInactiveColor(wxCommandEvent& event);
    void OnChooseShadowColor(wxCommandEvent& event);
    void OnChooseCaptionBorderColor(wxCommandEvent& event);
    void OnChooseCaptionFrameColor(wxCommandEvent& event);
    void OnChooseCaptionTextColor(wxCommandEvent& event);
    void OnChooseProgressBarColor(wxCommandEvent& event);
    void OnChooseProgressBarTextColor(wxCommandEvent& event);
    void OnChooseProgressBarHousingColor(wxCommandEvent& event);
    void OnResetFlashColors(wxCommandEvent& event);
    void OnResetCSSColors(wxCommandEvent& event);

    void OnChooseCSSBackgroundColor(wxCommandEvent& event);
    void OnChooseCSSTextColor(wxCommandEvent& event);
    void OnChooseCSSFooterColor(wxCommandEvent& event);
    void OnChooseCSSHorizontalLineColor(wxCommandEvent& event);
    void OnChooseCSSPhotoBorderColor(wxCommandEvent& event);
    void OnChooseCSSThumbnailBorderColor(wxCommandEvent& event);
    void OnChooseCSSNaviLinkColor(wxCommandEvent& event);
    void OnChooseCSSNaviVisitedColor(wxCommandEvent& event);
    void OnChooseCSSNaviBorderColor(wxCommandEvent& event);
    void OnChooseCSSNaviHoverColor(wxCommandEvent& event);

    bool IsNoExif();

private:
    // begin wxGlade: wxZphotoFrame::methods
    void set_properties();
    void do_layout();
    // end wxGlade

    // begin byHand
    bool ConfirmOverwrite();
    bool EnsureOutputDirectoryIsSane();
    bool EnsureAllPathsAreSane();

    void ZphotoInit();
    void CollectFiles();
    void ImportColor(const char *colorString, 
                     wxButton *button, wxZphotoSpinCtrl *spinctrl);
    void ImportConfig();
    void ExportColor(char **colorString, 
                     wxButton *button, wxZphotoSpinCtrl *spinctrl);
    void ExportConfig(void);

    void EnableCreation(bool flag);
    void UpdatePreview(wxDC& dc);

    void ChooseColorGeneric(wxButton* button);
    wxString OpenDirectoryGeneric(wxString default_dir = "");

    wxLocale locale;
    char *initial_dir;
    wxString lastVisitedDirectory;
    wxColourData colorData;
    int previewWidth;
    int previewHeight;
    ZphotoConfig* zphotoConfig;
    DECLARE_EVENT_TABLE()
    // end byHand

protected:
    // begin wxGlade: wxZphotoFrame::attributes
    wxMenuBar* mainFrameMenuBar;
    wxZphotoListBox* inputFilesListBox;
    wxPanel* leftPanel;
    wxStaticText* titleLabel;
    wxTextCtrl* titleTextCtrl;
    wxStaticText* outputDirectoryLabel;
    wxTextCtrl* outputDirectoryTextCtrl;
    wxButton* outputDirectoryButton;
    wxStaticLine* basicPanelLine;
    wxButton* createButton;
    wxZphotoPanel* previewPanel;
    wxZphotoInfoLabel* infoLabel;
    wxZphotoInfoContentLabel* infoContentLabel;
    wxPanel* basicPanel;
    wxCheckBox* includeOriginalCheckBox;
    wxCheckBox* sequentialCheckBox;
    wxCheckBox* sortByFilenameCheckBox;
    wxCheckBox* disableCaptionsCheckBox;
    wxCheckBox* noExifCheckBox;
    wxStaticLine* advancedPanelLine;
    wxStaticText* photoWidthLabel;
    wxZphotoSpinCtrl* photoWidthSpinCtrl;
    wxStaticText* flashSizeLabel;
    wxZphotoSpinCtrl* flashWidthSpinCtrl;
    wxZphotoSpinCtrl* flashHeightSpinCtrl;
    wxStaticText* gammaLabel;
    wxZphotoTextCtrl* gammaTextCtrl;
    wxStaticText* templateDirectoryLabel;
    wxTextCtrl* templateDirectoryTextCtrl;
    wxButton* templateDirectoryButton;
    wxStaticText* flashFontLabel;
    wxTextCtrl* flashFontTextCtrl;
    wxButton* flashFontButton;
    wxPanel* advancedPanel;
    wxStaticText* bacgroundColorLabel;
    wxButton* backgroundColorButton;
    wxStaticText* borderActiveColorLabel;
    wxButton* borderActiveColorButton;
    wxZphotoSpinCtrl* borderActiveColorSpinCtrl;
    wxStaticText* opacityLabel;
    wxStaticText* borderInactiveColorLabel;
    wxButton* borderInactiveColorButton;
    wxZphotoSpinCtrl* borderInactiveColorSpinCtrl;
    wxStaticText* shadoColorLabel;
    wxButton* shadowColorButton;
    wxZphotoSpinCtrl* shadowColorSpinCtrl;
    wxStaticText* captionBorderColorLabel;
    wxButton* captionBorderColorButton;
    wxZphotoSpinCtrl* captionBorderColorSpinCtrl;
    wxStaticText* captionFrameColorLabel;
    wxButton* captionFrameColorButton;
    wxZphotoSpinCtrl* captionFrameColorSpinCtrl;
    wxStaticText* captionTextColorLabel;
    wxButton* captionTextColorButton;
    wxZphotoSpinCtrl* captionTextColorSpinCtrl;
    wxStaticText* progressBarColorLabel;
    wxButton* progressBarColorButton;
    wxZphotoSpinCtrl* progressBarColorSpinCtrl;
    wxStaticText* progressBarTextColorLabel;
    wxButton* progressBarTextColorButton;
    wxZphotoSpinCtrl* progressBarTextColorSpinCtrl;
    wxStaticText* progressBarHousingColorLabel;
    wxButton* progressBarHousingColorButton;
    wxZphotoSpinCtrl* progressBarHousingColorSpinCtrl;
    wxStaticLine* colorPanelLine;
    wxButton* resetColorsButton;
    wxPanel* colorsPanel;
    wxStaticText* cssBacgroundColorLabel;
    wxButton* cssBackgroundColorButton;
    wxStaticText* cssTextColorLabel;
    wxButton* cssTextColorButton;
    wxStaticText* cssFooterColorLabel;
    wxButton* cssFooterColorButton;
    wxStaticText* cssHorizontalLineColorLabel;
    wxButton* cssHorizontalLineColorButton;
    wxStaticText* cssPhotoBorderColorLabel;
    wxButton* cssPhotoBorderColorButton;
    wxStaticText* cssThumbnailBorderLabel;
    wxButton* cssThumbnailBorderColorButton;
    wxStaticText* cssNaviLinkColorLabel;
    wxButton* cssNaviLinkColorButton;
    wxStaticText* cssNaviVisitedColorLabel;
    wxButton* cssNaviVisitedColorButton;
    wxStaticText* cssNaviBorderColorLabel;
    wxButton* cssNaviBorderColorButton;
    wxStaticText* cssNaviHoverColorLabel;
    wxButton* cssNaviHoverColorButton;
    wxStaticLine* cssColorPanelLine;
    wxButton* cssResetColorsButton;
    wxPanel* cssColorsPanel;
    wxNotebook* rightNotebook;
    wxPanel* mainPanel;
    // end wxGlade

    // begin byHand
    wxZphotoStatusBar* statusBar;
    // end byHand
};


#endif // WXZPHOTO_H
