/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.test;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXConnectorServer;
import javax.management.remote.JMXConnectorServerFactory;
import javax.management.remote.JMXServiceURL;
import junit.framework.TestCase;
import org.apache.zookeeper.jmx.MBeanRegistry;
import org.junit.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JMXEnv {
    protected static final Logger LOG = LoggerFactory.getLogger(JMXEnv.class);
    private static JMXConnectorServer cs;
    private static JMXConnector cc;

    public static void setUp() throws IOException {
        MBeanServer mbs = MBeanRegistry.getInstance().getPlatformMBeanServer();
        JMXServiceURL url = new JMXServiceURL("service:jmx:rmi://");
        cs = JMXConnectorServerFactory.newJMXConnectorServer(url, null, mbs);
        cs.start();
        JMXServiceURL addr = cs.getAddress();
        cc = JMXConnectorFactory.connect(addr);
    }

    public static void tearDown() {
        try {
            if (cc != null) {
                cc.close();
            }
        }
        catch (IOException e) {
            LOG.warn("Unexpected, ignoring", (Throwable)e);
        }
        cc = null;
        try {
            if (cs != null) {
                cs.stop();
            }
        }
        catch (IOException e) {
            LOG.warn("Unexpected, ignoring", (Throwable)e);
        }
        cs = null;
    }

    public static MBeanServerConnection conn() throws IOException {
        return cc.getMBeanServerConnection();
    }

    public static Set<ObjectName> ensureAll(String ... expectedNames) throws IOException, InterruptedException {
        Set<ObjectName> beans;
        HashSet<ObjectName> found;
        int nTry = 0;
        do {
            if (nTry++ > 0) {
                Thread.sleep(100L);
            }
            try {
                beans = JMXEnv.conn().queryNames(new ObjectName("org.apache.ZooKeeperService:*"), null);
            }
            catch (MalformedObjectNameException e) {
                throw new RuntimeException(e);
            }
            found = new HashSet<ObjectName>();
            for (String name : expectedNames) {
                LOG.info("expect:" + name);
                for (ObjectName bean : beans) {
                    if (!bean.toString().contains(name)) continue;
                    LOG.info("found:" + name + " " + bean);
                    found.add(bean);
                    break;
                }
                beans.removeAll(found);
            }
        } while (expectedNames.length != found.size() && nTry < 600);
        TestCase.assertEquals((String)("expected " + Arrays.toString(expectedNames)), (int)expectedNames.length, (int)found.size());
        return beans;
    }

    public static Set<ObjectName> ensureOnly(String ... expectedNames) throws IOException, InterruptedException {
        LOG.info("ensureOnly:" + Arrays.toString(expectedNames));
        Set<ObjectName> beans = JMXEnv.ensureAll(expectedNames);
        for (ObjectName bean : beans) {
            LOG.info("unexpected:" + bean.toString());
        }
        TestCase.assertEquals((int)0, (int)beans.size());
        return beans;
    }

    public static void ensureNone(String ... expectedNames) throws IOException, InterruptedException {
        Set<ObjectName> beans;
        int nTry = 0;
        boolean foundUnexpected = false;
        String unexpectedName = "";
        block2: do {
            if (nTry++ > 0) {
                Thread.sleep(100L);
            }
            try {
                beans = JMXEnv.conn().queryNames(new ObjectName("org.apache.ZooKeeperService:*"), null);
            }
            catch (MalformedObjectNameException e) {
                throw new RuntimeException(e);
            }
            foundUnexpected = false;
            for (String name : expectedNames) {
                for (ObjectName bean : beans) {
                    if (!bean.toString().contains(name)) continue;
                    LOG.info("didntexpect:" + name);
                    foundUnexpected = true;
                    unexpectedName = name + " " + bean.toString();
                    break;
                }
                if (foundUnexpected) continue block2;
            }
        } while (foundUnexpected && nTry < 600);
        if (foundUnexpected) {
            LOG.info("List of all beans follows:");
            for (ObjectName bean : beans) {
                LOG.info("bean:" + bean.toString());
            }
            TestCase.fail((String)unexpectedName);
        }
    }

    public static void dump() throws IOException {
        Set<ObjectName> beans;
        LOG.info("JMXEnv.dump() follows");
        try {
            beans = JMXEnv.conn().queryNames(new ObjectName("org.apache.ZooKeeperService:*"), null);
        }
        catch (MalformedObjectNameException e) {
            throw new RuntimeException(e);
        }
        for (ObjectName bean : beans) {
            LOG.info("bean:" + bean.toString());
        }
    }

    public static Set<ObjectName> ensureParent(String ... expectedNames) throws IOException, InterruptedException {
        Set<ObjectName> beans;
        LOG.info("ensureParent:" + Arrays.toString(expectedNames));
        int nTry = 0;
        HashSet<ObjectName> found = new HashSet<ObjectName>();
        do {
            if (nTry++ > 0) {
                Thread.sleep(500L);
            }
            try {
                beans = JMXEnv.conn().queryNames(new ObjectName("org.apache.ZooKeeperService:*"), null);
            }
            catch (MalformedObjectNameException e) {
                throw new RuntimeException(e);
            }
            found.clear();
            for (String name : expectedNames) {
                LOG.info("expect:" + name);
                for (ObjectName bean : beans) {
                    if (!JMXEnv.compare(bean.toString(), name)) continue;
                    LOG.info("found:" + name + " " + bean);
                    found.add(bean);
                    break;
                }
                beans.removeAll(found);
            }
        } while (expectedNames.length != found.size() && nTry < 120);
        TestCase.assertEquals((String)("expected " + Arrays.toString(expectedNames)), (int)expectedNames.length, (int)found.size());
        return beans;
    }

    private static boolean compare(String bean, String name) {
        String[] names = bean.split("=");
        return names.length > 0 && names[names.length - 1].contains(name);
    }

    public static Object ensureBeanAttribute(String expectedName, String expectedAttribute) throws Exception {
        String value = "";
        LOG.info("ensure bean:{}, attribute:{}", new Object[]{expectedName, expectedAttribute});
        int nTry = 0;
        do {
            Set<ObjectName> beans;
            if (nTry++ > 0) {
                Thread.sleep(500L);
            }
            try {
                beans = JMXEnv.conn().queryNames(new ObjectName("org.apache.ZooKeeperService:*"), null);
            }
            catch (MalformedObjectNameException e) {
                throw new RuntimeException(e);
            }
            LOG.info("expect:" + expectedName);
            for (ObjectName bean : beans) {
                if (!bean.toString().equals(expectedName)) continue;
                LOG.info("found:{} {}", new Object[]{expectedName, bean});
                return JMXEnv.conn().getAttribute(bean, expectedAttribute);
            }
        } while (nTry < 120);
        Assert.fail((String)("Failed to find bean:" + expectedName + ", attribute:" + expectedAttribute));
        return value;
    }
}

