/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.test;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeoutException;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.Op;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZKTestCase;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.test.ClientBase;
import org.apache.zookeeper.test.ClientTest;
import org.apache.zookeeper.test.QuorumUtil;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FollowerTest
extends ZKTestCase {
    private static final Logger LOG = LoggerFactory.getLogger(FollowerTest.class);
    public static final long CONNECTION_TIMEOUT = ClientTest.CONNECTION_TIMEOUT;
    volatile int counter = 0;
    volatile int errors = 0;

    @Test
    public void testFollowersStartAfterLeader() throws Exception {
        QuorumUtil qu = new QuorumUtil(1);
        ClientBase.CountdownWatcher watcher = new ClientBase.CountdownWatcher();
        qu.startQuorum();
        int index = 1;
        while (qu.getPeer((int)index).peer.leader == null) {
            ++index;
        }
        ZooKeeper zk = new ZooKeeper("127.0.0.1:" + qu.getPeer((int)(index == 1 ? 2 : 1)).peer.getClientPort(), ClientBase.CONNECTION_TIMEOUT, (Watcher)watcher);
        watcher.waitForConnected(CONNECTION_TIMEOUT);
        qu.shutdown(index);
        watcher.waitForDisconnected(CONNECTION_TIMEOUT);
        qu.start(index);
        try {
            watcher.waitForConnected(30000L);
        }
        catch (TimeoutException e) {
            Assert.fail((String)"client could not connect to reestablished quorum: giving up after 30+ seconds.");
        }
        zk.close();
        qu.tearDown();
    }

    @Test
    public void testMultiToFollower() throws Exception {
        QuorumUtil qu = new QuorumUtil(1);
        ClientBase.CountdownWatcher watcher = new ClientBase.CountdownWatcher();
        qu.startQuorum();
        int index = 1;
        while (qu.getPeer((int)index).peer.leader == null) {
            ++index;
        }
        ZooKeeper zk = new ZooKeeper("127.0.0.1:" + qu.getPeer((int)(index == 1 ? 2 : 1)).peer.getClientPort(), ClientBase.CONNECTION_TIMEOUT, (Watcher)watcher);
        watcher.waitForConnected(CONNECTION_TIMEOUT);
        List results = new ArrayList();
        results = zk.multi(Arrays.asList(Op.create((String)"/multi0", (byte[])new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, (CreateMode)CreateMode.PERSISTENT), Op.create((String)"/multi1", (byte[])new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, (CreateMode)CreateMode.PERSISTENT), Op.create((String)"/multi2", (byte[])new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, (CreateMode)CreateMode.PERSISTENT)));
        zk.getData("/multi0", false, null);
        zk.getData("/multi1", false, null);
        zk.getData("/multi2", false, null);
        zk.close();
        qu.tearDown();
    }
}

