/*
 * ZIDRAV, file corruption repairer
 * Copyright (C) 1999  Ben Wilhelm
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

#include <sys/stat.h>
#include <stdio.h>

#include "flayer.h"
#include "core.h"

void MakeChecksumFLayer( char inputFName[], char outputFName[], int blocksize) {

	struct stat	filespecs;

	ifstream	inFile;
	fstream		outFile;				// possibly a bit misleading, but it's easier than copying the data to a buffer

    cout << "Processing...\n";

	stat( inputFName, &filespecs );

	inFile.open( inputFName, ios::binary | ios::in );
	if( !inFile ) {
		cout << "Error opening input file '" << inputFName << "'\n";
		return; }					// Open input file

	outFile.open( outputFName, ios::binary | ios::in | ios::out | ios::trunc );
	if( !outFile ) {
        cout << "Error opening output file '" << outputFName << "'\n";
        inFile.close();
		return; }					// Open output file

    if (!(filespecs.st_size % blocksize))
    {
        cout << "Warning: filesize is multiple of blocksize, older windows "
                "version of Zidrav\ncan't handle such files. You can "
                "use '-b' to change blocksize (which is now " << blocksize 
             << ")\n";
    }
        
	MakeChecksumCore( inFile, outFile, blocksize, filespecs.st_size);

	inFile.close();
	outFile.close();

    cout << "Completed\n";
}

void MakePatchFLayer( char cdtFName[], char vfileFName[], char outputFName[] ) {

	struct stat	cdspecs;
	struct stat	vspecs;

	int			efound;

	ifstream	cdtFile;
	ifstream	vFile;
	fstream		outFile;				// possibly a bit misleading, but it's easier than copying the data to a buffer

    cout << "Processing...\n";

	stat( cdtFName, &cdspecs );
	stat( vfileFName, &vspecs );

	cdtFile.open( cdtFName, ios::binary | ios::in );
	if( !cdtFile ) {
        cout << "Error opening .CDT file '" << cdtFName << "'\n";
		return; }		// Open input file

	vFile.open( vfileFName, ios::binary | ios::in );
	if( !vFile ) {
		cdtFile.close();
        cout << "Error opening verified file '" << vfileFName << "'\n";
		return; }		// Open verified file

	outFile.open( outputFName, ios::binary | ios::in | ios::out | ios::trunc );
	if( !outFile ) {
		cdtFile.close();
		vFile.close();
        cout << "Error opening output file '" << outputFName << "'\n";
		return; }		// Open output file

	MakePatchCore( cdtFile, vFile, outFile, cdspecs.st_size, vspecs.st_size, &efound );

	cdtFile.close();
	vFile.close();
	outFile.close();

	if( efound )
        cout << "Completed, .CDP file generated\n";
	  else {
        remove(outputFName); 
        cout << "Completed, no corruption detected\n";
	}

}

void ApplyPatchFLayer( char cdpFName[], char pfileFName[]) {

	struct stat	cdspecs;
	struct stat	pspecs;

	ifstream	cdpFile;
	fstream		pFile;

    cout << "Processing...\n";

	stat( cdpFName, &cdspecs );
	stat( pfileFName, &pspecs );

	cdpFile.open( cdpFName, ios::binary | ios::in );
	if( !cdpFile ) {
        cout << "Error opening .CDP file '" << cdpFName << "'\n";
		return; }		// Open input file

	pFile.open( pfileFName, ios::binary | ios::in | ios::out );
	if( !pFile ) {
		cdpFile.close();
        cout << "Error opening target file '" << pfileFName << "'\n";
		return; }		// Open output file

	ApplyPatchCore( cdpFile, pFile, cdspecs.st_size, pspecs.st_size);

	cdpFile.close();
	pFile.close();

    cout << "Completed, file patched\n";
}

