/*
 *  PrintCB()   -   callback routine for printing
 *
 *  RCS:
 *      $Revision: 1.1 $
 *      $Date: 1995/05/07 19:34:10 $
 *
 *  Security:
 *      Unclassified
 *
 *  Description:
 *      text
 *
 *  Input Parameters:
 *      type    identifier  description
 *
 *      text
 *
 *  Output Parameters:
 *      type    identifier  description
 *
 *      text
 *
 *  Return Values:
 *      value   description
 *
 *  Side Effects:
 *      text
 *
 *  Limitations and Comments:
 *      text
 *
 *  Development History:
 *      who                 when        why
 *      muquit@semcor.com   25-Mar-95   first cut
 */


#include "xhead.h"
#include "defines.h"
#include "xymrolo.h"

void PrintCB (widget, client_data, call_data)
Widget
    widget;
XtPointer
    client_data,
    call_data;
{
    XmString
    xmstr;

        switch ((int) client_data)
        {
            case 1: /* displayed card */
            {
                if (XtIsSensitive(GEditPbW) == True)
                    GprintDisplayedCard = True;
                else
                {
                    WriteStatus(1,rolomessageTextW,
                        "No Card is Currently being viewed!");    
                    return;
                }
                break;
            }
            
            case 2: /* entire database */
            {
                GprintDisplayedCard = False;
                break;
            }
        }

    if (GnumberOfCards > 0)
    {
        SetCautionCursorState (w_special[MAINWINDOW_W], True);

        if (GprintDisplayedCard == True)
        {
            xmstr = XmStringCreateSimple ("Print Displayed Card");
            XtVaSetValues (GprintDialogW,
                XmNdialogTitle, xmstr,
                NULL);
            XmStringFree (xmstr);

        }
        else
        {
            xmstr = XmStringCreateSimple ("Print All Cards");
            XtVaSetValues (GprintDialogW,
                XmNdialogTitle, xmstr,
                NULL);
            XmStringFree (xmstr);
        }

        XtManageChild (GprintDialogW);
        XtSetSensitive(GprintCommandTextW, True);
        XtSetSensitive(GprintToFileTextW, True);

        if (XmToggleButtonGadgetGetState(GprintToFileTbW))
            XtSetSensitive(GprintCommandTextW, False);
         else
            XtSetSensitive(GprintToFileTextW, False);
            
    }
    else
        WriteStatus(1,rolomessageTextW, "Nothing to Print!");
}
