/*
 *  InfoButtonCB()  -   callback routine for buttons in info dialog
 *
 *  RCS:
 *      $Revision: 1.1 $
 *      $Date: 1995/05/07 19:34:10 $
 *
 *  Security:
 *      Unclassified
 *
 *  Description:
 *      text
 *
 *  Input Parameters:
 *      type    identifier  description
 *
 *      text
 *
 *  Output Parameters:
 *      type    identifier  description
 *
 *      text
 *
 *  Return Values:
 *      value   description
 *
 *  Side Effects:
 *      text
 *
 *  Limitations and Comments:
 *      text
 *
 *  Development History:
 *      when    who     why
 *  11/13/94    muquit  first cut
 */

#include "xhead.h"
#include "xymrolo.h"
#include "defines.h"


void InfoButtonCB(widget, client_data, call_data)
Widget
    widget;
XtPointer
    client_data;
XtPointer
    call_data;
{
    char
        *a = (char *) NULL;

    char
        *b = (char *) NULL;

    char
        *c = (char *) NULL;

    char
        *d = (char *) NULL;
    
    char
        *e = (char *) NULL;

    char
        *f = (char *) NULL;

    char
        *g = (char *) NULL;

    char
        *h = (char *) NULL;

    char
        *i = (char *) NULL;

    int
        same;


    switch((int) client_data)
    {
        case EDIT_OR_ADD_CARD: /* Accept */
        {
            a = XmTextGetString(w_special[NAME_TEXT_W]);
            b = XmTextGetString(GEcompanyTextW);
            c = XmTextGetString(GEaddressTextW);
            d = XmTextGetString(GEaddressText2W);
            e = XmTextGetString(w_special[PHONE_1_TEXT_W]);
            f = XmTextGetString(w_special[PHONE_2_TEXT_W]);
            g = XmTextGetString(GEfaxTextW);
            h = XmTextGetString(w_special[EMAIL_TEXT_W]);
            i = XmTextGetString(w_special[COMMENT_TEXT_W]);

            if (Gthiscard < 0)
            {
                int
                    answer;

                answer = AskUser (w_special[ROLOVIEWFD_W],
                    "Add the Card?");

                switch (answer)
                {
                    case YES:
                    {
                        MakeNewRolo(a,b,c,d,e,f,g,h,i,1);
                        WriteList(rolofile);
                        PutListOnScreen();
                        XtUnmanageChild(w_special[ROLOVIEWFD_W]);
                        XmListSelectPos (w_special[ADDRESSLIST_W],
                            GetIndex(a)+1, True);
                        XmListSetPos(w_special[ADDRESSLIST_W],
                            GetIndex(a)+1);
                        XmTextSetString(w_special[MESSAGE_TEXT_W], "");
                        Gthiscard = 0;
                        break;
                    }

                    case NO:
                    {
                        break;
                    }
                }
                goto ExitProcessing;

            }
            else
            {
                same=(strcmp(a,GetCardName(DisplayedCard)) == 0 ) &&
                     (strcmp(b,GetCompanyName(DisplayedCard)) == 0 ) &&
                     (strcmp(c,GetAddress(DisplayedCard)) == 0 ) &&
                     (strcmp(d,GetAddress2(DisplayedCard)) == 0 ) &&
                     (strcmp(e,GetNumber1(DisplayedCard)) == 0 ) &&
                     (strcmp(f,GetNumber2(DisplayedCard)) == 0 ) &&
                     (strcmp(g,GetNumber3(DisplayedCard)) == 0 ) &&
                     (strcmp(h,GetEmail(DisplayedCard)) == 0 ) &&
                     (strcmp(i,GetText(DisplayedCard)) == 0 );
                if (!same)
                {
                    int
                        answer;

                        answer = AskUser(w_special[ROLOVIEWFD_W],
                            "Accept the Changes?");
                        switch(answer)
                        {
                            case YES:
                            {
                                /*
                                ** call the same routine..recursive
                                */
                                DeleteCard(DisplayedCard);
                                Gthiscard=0;
                                PutCard();
                                XtUnmanageChild(w_special[ROLOVIEWFD_W]);
                                break;
                            }
                            
                            case NO:
                            {
                                break;
                            }
                        }
                }
                else
                {
                    WriteStatus(1,rolomessageTextW,
                        "Nothing changed in this card!");
                }
            }
            break;
        }

        case DISMISS_WINDOW: /* dismiss */
        {
            XtUnmanageChild (w_special[ROLOVIEWFD_W]);
            break;
        }

        case DELETE_CARD: /* delete card */
        {
            int
                answer;
            
#ifdef DEBUG2
(void) fprintf(stderr,
    "DesplayedCard: %d\n", DisplayedCard);  
#endif

            if (DisplayedCard < 0)
                break;

            answer = AskUser(w_special[ROLOVIEWFD_W],
                "Delete The Card?");

            switch(answer)
            {
                case YES:
                {
                        DeleteCard(DisplayedCard);
                        XmListDeletePos(w_special[ADDRESSLIST_W],
                            DisplayedCard+1);
                        WriteList(rolofile);
                        PutListOnScreen();

                        /*
                        ** in ClearFields() routine, all the fields in the
                        ** view area are blanked out, sensitivity of
                        ** delete and sendmail button is set to False,
                        ** DisplayedCard is set to -1
                        */

                        ClearFields();
                        break;
                }

                case NO:
                {
                    break;
                }
            }
            break;
        }

        case SEND_MAIL: /* sendmail */
        {
            a = XmTextGetString(GVemailTextW);
            XmTextSetString(w_special[TO_TEXT_W], a);
            XtManageChild (w_special[MAIL_FORMD_W]);
            break;
        }
    }

ExitProcessing:
    if (a != (char *)NULL)
        (void) free ((char *) a);
    if (b != (char *)NULL)
        (void) free ((char *) b);
    if (c != (char *)NULL)
        (void) free ((char *) c);
    if (d != (char *)NULL)
        (void) free ((char *) d);
    if (e != (char *)NULL)
        (void) free ((char *) e);
    if (f != (char *)NULL)
        (void) free ((char *) f);
    if (g != (char *) NULL)
        (void) free ((char *) g);
    if (h != (char *) NULL)
        (void) free ((char *) h);
    if (i != (char *) NULL)
        (void) free ((char *) i);

/*    SetBusyCursorState (w_special[MAINWINDOW_W], False);*/
    SetCautionCursorState (w_special[MAINWINDOW_W], False);
}
