/*                                                                                                                                       
// YAP2LC - an LDAP migration tool                                                                                                        
//                                                                                                                                       
// yap2lc.h                                                                                                                               
// License: GPL                                                                                                                           
// Author: Radu Negut <radun@romsys.ro>                                                                                                   
// Version: 0.5.9 [23.12.2003]                                                                                                            
// Section: the yap2lc header file                                                                                                             
*/

#include <sys/types.h>
#include <regex.h>
#include "config.h"
#if HAVE_SHADOW_H == 1
#include <shadow.h>
#endif
#include <pwd.h>
#ifdef BDB
#include <db.h>
#endif
#ifdef NDBM
#include <ndbm.h>
#endif

/* size defines */
#define MAX_CONFLINE_LEN	1024
#define MAX_LDIF_NAME		1024
#define MAX_NAME_LEN		1024
#define MAX_PATH_LEN		1024
#define MAX_INDEX_SIZ		256
#define MAX_LDIF_SIZ		32768
#define MAX_VAR_ALLOC		512
#define MAX_MALS_SIZ		16384
#define MIDLINE			1
#define LOWLINE			2
#define MSECS			1
#define SECS			2
#define RGXUNAME		1
#define RGXRNAME		2

/* aliases & database defines */
#define YAP2LC_DB_UNDEF		0
#define YAP2LC_DB_NDBM		1
#define YAP2LC_DB_BDB		2
#define YAP2LC_DB_CDB		3

/* we need the stuff below, because the DB API changed access methods around 4.1/4.0 */                                                      
#if DB_VERSION_MAJOR >= 4 && DB_VERSION_MINOR < 2                                                                                        
#define YAP2LC_DBAPI_SHORT_OPEN 1                                                                                                        
#else                                                                                                                                    
#define YAP2LC_DBAPI_SHORT_OPEN 0                                                                                                        
#endif

/* log codes */
#define NOCN		1
#define NOPWD		2
#define NOGRP		3
#define DUPLICATE	4
#define WRONGCN		5
#define LOCKEDOUT	6
#define RGXFAIL		7
#define UGIDFAIL	8

typedef struct					/* yap2lc globals */
{
    char outfile[MAX_LDIF_NAME];		/* outfile name */
    char locshadow[MAX_NAME_LEN];		/* shadow path */
    char locpasswd[MAX_NAME_LEN];		/* passwd path */
    char localiases[MAX_NAME_LEN];		/* aliases path */
    char ldftpl[MAX_NAME_LEN];			/* ldif template path */
    char logfile[MAX_NAME_LEN];			/* log path */
    char ldifbuf[MAX_LDIF_SIZ + MAX_MALS_SIZ];	/* template read-in buffer */
    char assembly[MAX_LDIF_SIZ];		/* ldif write-out buffer */
    char cryptscheme[MAX_NAME_LEN];		/* crypt scheme string */
    char malstring[MAX_NAME_LEN];		/* alias ldif string */
    int exgids[10];				/* excluded gids list */
    regex_t *reg_struct;			/* compiled regex struct */
    u_long min_uid;				/* min uid filter */
    u_long max_uid;				/* max uid filter */
    int sanitize;				/* filter master switch */
    int igngrperr;				/* group error filter switch */
    int lognocn;				/* log real name absence switch */
    int lognopwd;				/* password absence log switch */
    int logugids;				/* filtered gids log switch */
    int logregexp;				/* regex filtered log switch */
    int logduplicates;				/* duplicate real names log switch */
    int remduplicates;				/* duplicate real name filter switch */
    int impdup;					/* ??? */
    int allownopwd;				/* permit passwordless entries */
    int allowlockedout;				/* permit locked out entries */
    int regexpfilter;				/* regex filter switch */
    int regextarget;				/* what to apply regex filter onto */
    int idacstat;				/* auto id account status switch */
    int accstat;				/* current entry account status */
    int malswitch;				/* mail alias processing switch */
    int malsdbtype;				/* mail alias database type */
    int dbsupport;				/* what kind of db api is available */
    int havemals;				/* does the current account have an alias? */
#ifdef NDBM
    DBM *ndbm_handle;				/* ndbm db handle */
#endif
#ifdef BDB
    DB *db_handle;				/* db db handle */
    DB *preproc_dbhandle;			/* nested alias processing db handle */
    DBC *cursor;				/* db db cursor */
    DBC *preproc_cursor;			/* preprocessing db db cursor */
#endif
#ifdef CDB
    struct cdb *cdb_handle;			/* cdb db handle */
    int cdb_fd;					/* cdb db descriptor */
#endif
    u_long counter;				/* global entry counter */
    u_long baddies;				/* global rejected entries counter */
    u_long lockedout;				/* locked out entry counter */
    u_long nocn;				/* missing real name entry counter */
    u_long unpassworded;			/* passwordless entry counter */
    u_long duplicates;				/* duplicate real name counter */
    u_long regexpfiltered;			/* regex filtered counter */
    u_long gidexcluded;				/* gid excluded counter */
    FILE *logfp;				/* log file file handle */
    int pipelined;				/* pipeline mode switch */
} global_t;

typedef struct maqnode_s
{
    int nestlevel;
    char el[MAX_NAME_LEN];
    struct maqnode_s *next;
    struct maqnode_s *prev;
} maqnode_t;

typedef struct
{
    char origin[MAX_NAME_LEN];
    maqnode_t *entry;
} alq_t;

void
usage(void);

int
fill_global(void);

int
ident_opt(const char *line);

#if HAVE_SHADOW_H == 1
void
ldif_assembly(struct passwd *pwd, struct spwd *shadow, FILE *ldifp);
#else
void
ldif_assembly(struct passwd *pwd, FILE *ldifp);
#endif

#if HAVE_SHADOW_H == 1
int
sanity_check(struct passwd *pwd, struct spwd *shadow);
#else
int
sanity_check(struct passwd *pwd);
#endif

#if HAVE_SHADOW_H == 1
inline void
fillvar(u_long pos, struct passwd *pwd, struct spwd *shadow);
#else
inline void
fillvar(u_long pos, struct passwd *pwd);
#endif

int
commit_log(char *uname, int uid, int code);

int
check_duplicate(char *cname);

void
vanity_table(u_long time, int code);

void
print_line(int code);

regex_t *
regex_compiler(const char *string);

int
regex_filter(regex_t *pattern, const char *text);

int
pipe_defs(void);

void
mals_assembly(char *uname, char *apdx, char *assembly);

void
yap2lc_dbopen(void);

void
db_fatal(int errcode, const char *errstr);

void
yap2lc_dbclose(void);

#ifdef BDB
int
yap2lc_cond_dbopen(void);

int
yap2lc_dbupgrade(void);

int
unnest(int flag, char *mals, char *shifter, char *domain);

void
printdb(DB *handle);
#endif

