
:- use_module(library(yapr)).
:- use_module(library(readutil)).

% from Nicos
rtest :-
	y <- rnorm(50),
	r_print( y ),
	x <- rnorm(y),
	r_in( x11(width=5,height=3.5) ),
	r_in( plot(x,y) ),
	write( 'Press Return to continue...' ), nl,
	read_line_to_codes( user_input, _ ),
	r( dev:off ),
	Y <- y,
	write( y(Y) ), nl,
	findall( Zx, between(1,9,Zx), Z ),
	z <- Z,
	r_print( z ),
	cars <- c(1, 3, 6, 4, 9),
	r_in(pie(cars)),
	write( 'Press Return to continue...' ), nl,
	read_line_to_codes( user_input, _ ),
	r( dev:off ).

% Intrinsic attributes: mode and length
tut1 :-
	z <- 0:9,
	r_print(z),
	digits <- as..character(z),
	r_print(digits),
	d <- as..integer(digits),
	r_print(d).

% changing the length of an object
tut2 :-
	e <- numeric,
	e^[3] <- 17,
	r_print(e),
	alpha <- 1:10,
	alpha <- alpha^[2 * 1:5],
	length(alpha) <- 3,
	r_print(alpha).

% Getting and setting attributes
tut3 :-
	z <- 1:100,
	attr(z, "dim") <- c(10,10),
	r_print(z).

% factors and tapply.
tut4 :-
	state <- c("tas", "sa",  "qld", "nsw", "nsw", "nt",  "wa",  "wa",
                  "qld", "vic", "nsw", "vic", "qld", "qld", "sa",  "tas",
                  "sa",  "nt",  "wa",  "vic", "qld", "nsw", "nsw", "wa",
                  "sa",  "act", "nsw", "vic", "vic", "act"),
	r_print(state),
	statef <- factor(state),
	r_print(statef),
	r_print(levels(statef)),
	incomes <- c(60, 49, 40, 61, 64, 60, 59, 54, 62, 69, 70, 42, 56,
                    61, 61, 61, 58, 51, 48, 65, 49, 49, 41, 48, 52, 46,
                    59, 46, 58, 43),
	incmeans <- tapply(incomes, statef, mean),
	% notice the function definition.
	stderr <- ( function(x) :-  sqrt(var(x)/length(x)) ),
	incster <- tapply(incomes, statef, stderr),
	r_print(incster).

tut5 :-
	z <- 1:1500,
	dim(z) <- c(3,5,100),
	a <- 1:24,
	dim(a) <- c(3,4,2),
	r_print(a^[2,*,*]),
	r_print(dim(a)),
	x <- array(1:20, dim=c(4,5)),
	r_print(x),
	i <- array(c(1:3,3:1), dim=c(3,2)),
	r_print(i),
	x^[i] <- 0,
	r_print(x),
	h <- 1:10,
	z <- array(h, dim=c(3,4,2)),
	r_print(z),
	a <- array(0, dim=c(3,4,2)),
	r_print(a),
	ab <- z '%o%' a,
	r_print(ab),
        f <- ( function(x, y) :- cos(y)/(1 + x^2) ),
	w <- outer(z, a, f),
	r_print(w).

tut6 :-
	d <- outer(0:9, 0:9),
	fr <- table(outer(d, d, "-")),
	r(plot(as.numeric(names(fr)), fr, type="h",
            xlab="Determinant", ylab="Frequency")).



	