/*
 * $Id: camp.cpp,v 1.27 2005/10/03 05:57:31 andrewtaylor Exp $
 */

#include "vc6.h" // Fixes things if you're using VC6, does nothing if otherwise

#include "u4.h"

#include "camp.h"

#include "annotation.h"
#include "city.h"
#include "combat.h"
#include "context.h"
#include "conversation.h"
#include "event.h"
#include "game.h"
#include "location.h"
#include "map.h"
#include "mapmgr.h"
#include "creature.h"
#include "music.h"
#include "names.h"
#include "object.h"
#include "person.h"
#include "player.h"
#include "screen.h"
#include "settings.h"
#include "stats.h"
#include "tileset.h"
#include "utils.h"

void campTimer(void *data);
void campEnd(void);
int campHeal(HealType heal_type);
void innTimer(void *data);

CampController::CampController() {
    MapId id;

    /* setup camp (possible, but not for-sure combat situation */
    if (c->location->context & CTX_DUNGEON)
        id = MAP_CAMP_DNG;
    else
        id = MAP_CAMP_CON;

    map = getCombatMap(mapMgr->get(id));
    game->setMap(map, true, NULL);
}

void CampController::init(Creature *m) {
    CombatController::init(m);
    camping = true;
}

void CampController::begin() {
    // make sure everyone's asleep
    for (int i = 0; i < c->party->size(); i++)
        c->party->member(i)->putToSleep();            

    CombatController::begin();

    musicMgr->camp();

    screenMessage("Resting...\n");
    screenDisableCursor();

    EventHandler::wait_msecs(settings.campTime * 1000);

    screenEnableCursor();

    /* Is the party ambushed during their rest? */
    if (settings.campingAlwaysCombat || (xu4_random(8) == 0)) {        
        const Creature *m = creatureMgr->randomAmbushing();
                
        musicMgr->play();        
        screenMessage("Ambushed!\n");
        
        /* create an ambushing creature (so it leaves a chest) */
        setCreature(c->location->prev->map->addCreature(m, c->location->prev->coords));
        
        /* fill the creature table with creatures and place them */
        fillCreatureTable(m);
        placeCreatures();

        /* creatures go first! */
        finishTurn();
    }
    else {
        /* Wake everyone up! */    
        for (int i = 0; i < c->party->size(); i++)
            c->party->member(i)->wakeUp();    

        /* Make sure we've waited long enough for camping to be effective */
        bool healed = false;
        if (((c->saveGame->moves / CAMP_HEAL_INTERVAL) >= 0x10000) || (((c->saveGame->moves / CAMP_HEAL_INTERVAL) & 0xffff) != c->saveGame->lastcamp))
            healed = heal();

        screenMessage(healed ? "Party Healed!\n" : "No effect.\n");
        c->saveGame->lastcamp = (c->saveGame->moves / CAMP_HEAL_INTERVAL) & 0xffff;
    
        eventHandler->popController();
        game->exitToParentMap();
        musicMgr->fadeIn(CAMP_FADE_IN_TIME, true);
    }
}

void CampController::end(bool adjustKarma) {
    // wake everyone up!
    for (int i = 0; i < c->party->size(); i++)
        c->party->member(i)->wakeUp();        
    CombatController::end(adjustKarma);
}

bool CampController::heal() {
    // restore each party member to max mp, and restore some hp
    bool healed = false;
    for (int i = 0; i < c->party->size(); i++) {
        PartyMember *m = c->party->member(i);
        m->setMp(m->getMaxMp());
        if ((m->getHp() < m->getMaxHp()) && m->heal(HT_CAMPHEAL))
            healed = true;
    }

    return healed;
}

InnController::InnController() {
    map = NULL;
    /*
     * Normally in cities, only one opponent per encounter; inn's
     * override this to get the regular encounter size.
     */
    forceStandardEncounterSize = true;
}

void InnController::begin() {
    /* first, show the avatar before sleeping */
    gameUpdateScreen();

    /* in the original, the vendor music plays straight through sleeping */
    if (settings.enhancements)
        musicMgr->fadeOut(INN_FADE_OUT_TIME); /* Fade volume out to ease into rest */
    
    EventHandler::wait_msecs(INN_FADE_OUT_TIME);

    /* show the sleeping avatar */
    c->party->setTransport(c->location->map->tileset->getByName("corpse")->id);
    gameUpdateScreen();

    screenDisableCursor();

    EventHandler::wait_msecs(settings.innTime * 1000);

    screenEnableCursor();

    /* restore the avatar to normal */
    c->party->setTransport(c->location->map->tileset->getByName("avatar")->id);
    gameUpdateScreen();

    /* the party is always healed */
    heal();

    /* Is there a special encounter during your stay? */
    if (settings.innAlwaysCombat || (xu4_random(8) == 0)) {
        MapId mapid;
        Creature *creature;
        bool showMessage = true;
            
        /* Rats seem much more rare than meeting rogues in the streets */
        if (xu4_random(4) == 0) {
            /* Rats! */
            mapid = MAP_BRICK_CON;
            creature = c->location->map->addCreature(creatureMgr->getById(RAT_ID), c->location->coords);
        } else {
            /* While strolling down the street, attacked by rogues! */
            mapid = MAP_INN_CON;
            creature = c->location->map->addCreature(creatureMgr->getById(ROGUE_ID), c->location->coords);
            screenMessage("\nIn the middle of the night while out on a stroll...\n\n");
            showMessage = false;
        }


        map = getCombatMap(mapMgr->get(mapid));
        game->setMap(map, true, NULL);

        init(creature);
        showCombatMessage(showMessage);  
        CombatController::begin();
    }
    
    else {
        screenMessage("\nMorning!\n");
        screenPrompt();
        screenRedrawScreen();

        // Does Isaac the Ghost pay a visit to the Avatar?
        if (c->location->map->id == 11) {// && (xu4_random(4) == 0)) {
            City *city = dynamic_cast<City*>(c->location->map);

            if (city->extraDialogues.size() == 1 &&
                city->extraDialogues[0]->getName() == "Isaac") {

                Coords coords(27, xu4_random(3) + 10, c->location->coords.z);

                // If Isaac is already around, just bring him back to the inn
                for (ObjectDeque::iterator i = c->location->map->objects.begin();
                     i != c->location->map->objects.end();
                     i++) {
                    Person *p = dynamic_cast<Person*>(*i);
                    if (p && p->name == "Isaac") {                
                        p->setCoords(coords);
                        return;
                    }
                }

                // Otherwise, we need to create Isaac
                Person *Isaac;
                Isaac = new Person;

                Isaac->setMovementBehavior(MOVEMENT_WANDER);

                Isaac->dialogue = city->extraDialogues[0];
                Isaac->name = city->extraDialogues[0]->getName();
                Isaac->start = coords;
                Isaac->npcType = NPC_TALKER;
                Isaac->setTile(creatureMgr->getById(GHOST_ID)->getTile());
                Isaac->setPrevTile(Isaac->getTile());

                // Add Isaac near the Avatar
                city->addPerson(Isaac);
            }
        }
    }
    
    musicMgr->fadeIn(INN_FADE_IN_TIME, true);

}

bool InnController::heal() {
    // restore each party member to max mp, and restore some hp
    bool healed = false;
    for (int i = 0; i < c->party->size(); i++) {
        PartyMember *m = c->party->member(i);
        m->setMp(m->getMaxMp());
        if ((m->getHp() < m->getMaxHp()) && m->heal(HT_INNHEAL))
            healed = true;
    }

    return healed;
}

void InnController::awardLoot() {
    // never get a chest from inn combat
}
