typedef enum {
    EVENT_NONE,
    EVENT_MESSAGE,
    EVENT_TELEPORT,
    EVENT_ENDLEVEL,
    EVENT_DAMAGE,
    NUM_EVENTS
} event_type_t;

typedef struct {
    char text[TEXTMESSAGE_STRLEN];
} event_message;

typedef struct {
    int x;
    int y;
    int dir;
    int speed;
} event_teleport;

typedef struct {
    char map[NETMSG_STRLEN];
} event_endlevel;

typedef struct {
    int damage;
    char map[NETMSG_STRLEN];
} event_damage;

typedef union {
    event_message  message;
    event_teleport teleport;
    event_endlevel endlevel;
    event_damage   damage;
} eventdata_t;

typedef struct {
    event_type_t type;
    int repeat;
    int active;
    int visible;
    eventdata_t data;
} event_t;

void event_reset(void);
int event_setup_layer(void);
int event_trigger(entity *ent, byte id);
void read_event(const char *line);
void event_send_initial_effects(client_t *cl);
