#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <time.h>

#include "xtux.h"
#include "client.h"
#include "win.h"
#include "input.h"
#include "menu.h"
#include "misc.h"
#include "cl_net.h"
#include "entity.h"
#include "image.h"
#include "draw.h"
#include "cl_netmsg_send.h"
#include "particle.h"


extern float sin_lookup[DEGREES]; /*  from ../common/math.c */
extern float cos_lookup[DEGREES];

map_t *map;
client_t client;
netmsg my_entity;

void client_init(void);
void netstats(void);

int main(void)
{
    byte keypress;

    calc_lookup_tables(DEGREES);

    win_init();
    entity_init();
    weapon_type_init();
    cl_network_init();
    particle_init();

    client_init();
    menu_init();

    for( ; ; ) {
	switch( client.state ) {
	case MENU:
	    menu_driver();
	    break;

	case GAME_LOAD:
	    win_set_properties(VERSION, client.view_w, client.view_h+STATUS_H);
	    wait_till_expose(5);

	    /* Finished loading, we are ready to play */
	    cl_change_map(client.map);
	    break;

	case GAME_RESUME: /* Resume game from menu */
	    win_set_properties(VERSION, client.view_w, client.view_h+STATUS_H);
	    wait_till_expose(5);
	    draw_status_bar();
	    cl_netmsg_send_ready(); /* Tell server new details */
	    client.state = GAME_JOIN;
	    break;

	case GAME_JOIN:
	case GAME_PLAY:
	    cl_net_update();

	    if( client.state == GAME_PLAY ) {
		draw_crosshair( my_entity.entity );
		draw_game_messages();
		if( client.netstats )
		    netstats();

		win_update();

		/* Keyboard Input */
		client.dir = my_entity.entity.dir;
		keypress = get_input();
		cl_netmsg_send_cl_update(keypress, client.dir);
	    }

	    cap_fps(client.fps);
	    break;

	case QUIT:
	    game_close();
	    image_close(); /* Free all the images */
	    win_close();
	    write_config_file(&client);
	    exit(0);
	    break;
	}

    }

    return 0;

}

/* Set a bunch of defaults... */
void client_init(void)
{

    client.fps = DEFAULT_FPS;
    client.color1 = COL_YELLOW;
    client.color2 = COL_STEELBLUE;
    strcpy(client.map, DEFAULT_MAP);
    client.health = 100;
    client.player_name = get_login_name();
    client.movement_mode = NORMAL;
    client.state = MENU;
    client.gamemode = SAVETHEWORLD;
    client.sniper_mode = 0;
    client.netstats = NS_NONE;
    client.debug = DEBUG;
    client.crosshair_radius = 100;
    client.turn_rate = 4;
    client.loadscreen = BLUEPRINT;
    client.textentry = 0;
    client.x_tiles = X_TILES;
    client.y_tiles = Y_TILES;
    client.ep_expire = 30;

    /* Load client preferences from file */
    read_config_file( &client );
    /* Set view dimensions, which are calculated by tile width & heights */
    client.view_w = client.x_tiles * TILE_W;
    client.view_h = client.y_tiles * TILE_H;

}


/* Put things back to normal */
void game_close(void)
{

    cl_network_disconnect();
    particle_clear();
    if( map )
      map_close(&map);

}


void netstats(void)
{
    static vector_t NS; /* Network stats */
    static time_t t_last;

    time_t t_now;

    t_now = time(NULL);
    /* Only update net stats once a second */
    if( t_now != t_last ) {
	t_last = t_now;
	NS = net_stats(client.netstats);
    }
    draw_netstats(NS);

}


extern win_t win;

int cl_change_map(char *map_name)
{

    client.screenpos.x = 0;
    client.screenpos.y = 0;
    client.health = 0; /* To make sure statusbar updates */

    draw_load_screen(client.loadscreen);

    /* Load the map */
    if( !(map = map_load(client.map, L_BASE|L_OBJECT|L_TOPLEVEL|L_TEXT, MAP))){
	printf("** ERROR LOADING MAP %s! **\n", client.map);
	cl_network_disconnect();
	client.state = MENU; /* Go back to menu */
	return 0;
    }

    /* Load tileset and store pixmap id's in tileset tables  */
    maptext_init(map->text_root);
    tileset_load(map->tileset);
    client.state = GAME_JOIN;  /* Status of JOINING on the server */
    cl_netmsg_send_ready();    /* Request to be ACTIVE on the server */
    return 1;

}
