package com.jclark.xsl.sax;

import org.xml.sax.Parser;
import org.xml.sax.SAXException;
import org.xml.sax.InputSource;
import java.io.IOException;

public interface XSLProcessor extends Parser {
  /* setParser must be called before any other methods */
  void setParser(Parser parser);
  void setParser(Parser sourceParser, Parser stylesheetParser);
  void setOutputMethodHandler(OutputMethodHandler handler);
  /* loadStylesheet must be called before parse but after setParser */
  void loadStylesheet(InputSource stylesheet) throws IOException, SAXException;
  Object clone();
  void setParameter(String name, Object obj);
}
