// xsc: Copyright (c) 1993-2005 by Mark B. Hanson (mbh@panix.com).

static const char *const file_id =
	"@(#)$Id: xything.C,v 3.5 2005/01/02 19:11:17 mark Exp $";

#include "global.h"

#include "trig.h"
#include "xsc.h"

#include "xything.h"

using namespace Trig;


Xything::Xything(void)
{
    //fprintf(stderr, "Xything::Xything()\n");
    dx = dy = 0.0;
} // Xything::Xything


Xything::~Xything(void)
{
    //fprintf(stderr, "Xything::~Xything()\n");
} // Xything::~Xything


void
Xything::move(void)
{
    x += dx;
    if (x < 0) {
	x += wwidth;
    } else if (x >= wwidth) {
	x -= wwidth;
    }

    y += dy;
    if (y < 0) {
	y += gwheight;
    } else if (y >= gwheight) {
	y -= gwheight;
    }
} // Xything::move


void
Xything::resize(const int nwidth, const int nheight)
{
    dx *= (float)nwidth / wwidth;
    dy *= (float)nheight / gwheight;
    Thing::resize(nwidth, nheight);
} // Xything::resize


void
Xything::bounce(const float phi)
{
    const float cos_phi = xcos(phi);
    const float sin_phi = xsin(phi);

    // see: http://www.psky.com/prog/2dcollision.htm

    // translate the coordinate system so the object can be
    // bounced by merely negating the y portion of its vector
    const float ndx = (dx * cos_phi) + (dy * -sin_phi);
    const float ndy = (dx * sin_phi) + (dy * cos_phi);

    // translate the coordinates back to the original orientation
    // by negating the sin() terms in the above translation
    // (the use of -ndy instead of ndy is the bounce negation mentioned above)
    dx = (ndx * cos_phi) + (-ndy * sin_phi);
    dy = (ndx * -sin_phi) + (-ndy * cos_phi);
} // Xything::bounce
