// xsc: Copyright (c) 1993-2005 by Mark B. Hanson (mbh@panix.com).

// @(#)$Id: text.h,v 3.3 2005/01/02 19:11:17 mark Exp $

#ifdef	XSC_TEXT_H

class Text;

#else	// XSC_TEXT_H
#define	XSC_TEXT_H

#include "thing.h"

class Text : public Thing {
private:
    const char *message;
    int length;

public:
    Text(void);
    ~Text(void);

    void render(const bool);

    void set_position(const float, const float);

    void set_message(const char *);
};


inline void
Text::set_message(const char *msg)
{
    message = msg;
    length = message ? strlen(message) : 0;
} // Text::set_message

#endif	// XSC_TEXT_H
