// xsc: Copyright (c) 1993-2005 by Mark B. Hanson (mbh@panix.com).

static const char *const file_id =
	"@(#)$Id: text.C,v 3.4 2005/01/02 19:11:17 mark Exp $";

#include "global.h"

#include "font.h"
#include "util.h"
#include "xsc.h"

#include "text.h"


Text::Text(void)
{
    //fprintf(stderr, "Text::Text()\n");
    set_scale(6.0);
    set_gc(fetch_gc(GC_BLUE));
} // Text::Text


Text::~Text(void)
{
    //fprintf(stderr, "Text::~Text()\n");
} // Text::~Text


void
Text::set_position(const float xpos, const float ypos)
{
    if (xpos == -1) {
	const float charwidth = size / 6.0;
	float width = 0;

	for (int i = 0; i < length; i++) {
	    if ((message[i] >= '0' && message[i] <= '9') ||
		    (message[i] >= 'A' && message[i] <= 'Z') ||
		    (message[i] >= 'a' && message[i] <= 'z') ||
		    message[i] == ' ') {
		width += charwidth;
	    } else if (message[i] == ',') {
		width += charwidth / 2.0;
	    } else {
		continue;
	    }
	}

	x = wwidth2 + (charwidth / 2.0) - (width / 2.0);
    } else {
	x = xpos;
    }

    y = ypos;
} // Text::set_position


void
Text::render(const bool ink)
{
    const float charwidth = size / 6.0;
    const float savex = x;
    float width;
    int offset;

    for (int i = 0; i < length; i++) {
	width = charwidth;
	if (message[i] >= '0' && message[i] <= '9') {
	    offset = font_digit_offset + message[i] - '0';
	} else if (message[i] >= 'A' && message[i] <= 'Z') {
	    offset = font_upper_offset + message[i] - 'A';
	} else if (message[i] >= 'a' && message[i] <= 'z') {
	    offset = font_lower_offset + message[i] - 'a';
	} else if (message[i] == ',') {
	    offset = font_comma_offset;
	    width /= 2.0;
	} else if (message[i] == ' ') {
	    x += width;
	    continue;
	} else {
	    continue;
	}

	set_points(romans_points[offset], romans_count[offset]);
	set_xpoints();
	paint_points(ink);

	x += width;
    }

    x = savex;
} // Text::render
