// xsc: Copyright (c) 1993-2005 by Mark B. Hanson (mbh@panix.com).

static const char *const file_id =
	"@(#)$Id: args.C,v 3.3 2005/01/02 19:11:17 mark Exp $";

#include <X11/keysym.h>

#include "global.h"

#include "xsc.h"

#include "args.h"


void
Args::init(struct info *const a)
{
    a->ccw = XK_d;
    a->cw = XK_f;
    a->thrust = XK_j;
    a->fire = XK_k;
    a->pause = XK_p;
    a->iconify = XK_i;
    a->quit = XK_q;
    a->start = XK_space;
    a->fps = DEFAULT_FPS;
    a->x = -1;	// no specified position
    a->y = -1;	// no specified position
    a->percent = 90;
    a->nowarp = false;
    a->nobeep = false;
    a->nopause = false;
    a->stats = false;
    a->bw = false;
} // Args::init


void
Args::set(struct info *const a, const int argc,
	const char *const argv[])
{
    for (int i = 1; i < argc; i++) {
	if (!strcmp(argv[i], "--ccw")) {
	    if (++i < argc) {
		if ((a->ccw = XStringToKeysym(argv[i])) == NoSymbol) {
		    fprintf(stderr, "%s: cannot convert `%s' to a KeySym!\n",
			    program, argv[i]);
		    exit(1);
		}
	    } else {
		fprintf(stderr, "%s: no argument for `%s'!\n",
			program, "--ccw");
		exit(1);
	    }
	} else if (!strcmp(argv[i], "--cw")) {
	    if (++i < argc) {
		if ((a->cw = XStringToKeysym(argv[i])) == NoSymbol) {
		    fprintf(stderr, "%s: cannot convert `%s' to a KeySym!\n",
			    program, argv[i]);
		    exit(1);
		}
	    } else {
		fprintf(stderr, "%s: no argument for `%s'!\n",
			program, "--cw");
		exit(1);
	    }
	} else if (!strcmp(argv[i], "--thrust")) {
	    if (++i < argc) {
		if ((a->thrust = XStringToKeysym(argv[i])) == NoSymbol) {
		    fprintf(stderr, "%s: cannot convert `%s' to a KeySym!\n",
			    program, argv[i]);
		    exit(1);
		}
	    } else {
		fprintf(stderr, "%s: no argument for `%s'!\n",
			program, "--thrust");
		exit(1);
	    }
	} else if (!strcmp(argv[i], "--fire")) {
	    if (++i < argc) {
		if ((a->fire = XStringToKeysym(argv[i])) == NoSymbol) {
		    fprintf(stderr, "%s: cannot convert `%s' to a KeySym!\n",
			    program, argv[i]);
		    exit(1);
		}
	    } else {
		fprintf(stderr, "%s: no argument for `%s'!\n",
			program, "--fire");
		exit(1);
	    }
	} else if (!strcmp(argv[i], "--pause")) {
	    if (++i < argc) {
		if ((a->pause = XStringToKeysym(argv[i])) == NoSymbol) {
		    fprintf(stderr, "%s: cannot convert `%s' to a KeySym!\n",
			    program, argv[i]);
		    exit(1);
		}
	    } else {
		fprintf(stderr, "%s: no argument for `%s'!\n",
			program, "--pause");
		exit(1);
	    }
	} else if (!strcmp(argv[i], "--iconify")) {
	    if (++i < argc) {
		if ((a->iconify = XStringToKeysym(argv[i])) == NoSymbol) {
		    fprintf(stderr, "%s: cannot convert `%s' to a KeySym!\n",
			    program, argv[i]);
		    exit(1);
		}
	    } else {
		fprintf(stderr, "%s: no argument for `%s'!\n",
			program, "--iconify");
		exit(1);
	    }
	} else if (!strcmp(argv[i], "--quit")) {
	    if (++i < argc) {
		if ((a->quit = XStringToKeysym(argv[i])) == NoSymbol) {
		    fprintf(stderr, "%s: cannot convert `%s' to a KeySym!\n",
			    program, argv[i]);
		    exit(1);
		}
	    } else {
		fprintf(stderr, "%s: no argument for `%s'!\n",
			program, "--quit");
		exit(1);
	    }
	} else if (!strcmp(argv[i], "--start")) {
	    if (++i < argc) {
		if ((a->start = XStringToKeysym(argv[i])) == NoSymbol) {
		    fprintf(stderr, "%s: cannot convert `%s' to a KeySym!\n",
			    program, argv[i]);
		    exit(1);
		}
	    } else {
		fprintf(stderr, "%s: no argument for `%s'!\n",
			program, "--start");
		exit(1);
	    }
	} else if (!strcmp(argv[i], "--fps")) {
	    if (++i < argc) {
		if ((a->fps = atoi(argv[i])) <= 0) {
		    fprintf(stderr, "%s: bad argument for `%s' to an !\n",
			    program, "--fps");
		    exit(1);
		}
	    } else {
		fprintf(stderr, "%s: no argument for `%s'!\n",
			program, "--fps");
		exit(1);
	    }
	} else if (!strcmp(argv[i], "--x")) {
	} else if (!strcmp(argv[i], "--y")) {
	} else if (!strcmp(argv[i], "--percent")) {
	    if (++i < argc) {
		if ((a->percent = atoi(argv[i])) <= 0 || a->percent > 100) {
		    fprintf(stderr, "%s: bad argument for `%s'!\n",
			    program, "--percent");
		    exit(1);
		}
	    } else {
		fprintf(stderr, "%s: no argument for `%s'!\n",
			program, "--percent");
		exit(1);
	    }
	} else if (!strcmp(argv[i], "--nowarp")) {
	    a->nowarp = true;
	} else if (!strcmp(argv[i], "--nobeep")) {
	    a->nobeep = true;
	} else if (!strcmp(argv[i], "--nopause")) {
	    a->nopause = true;
	} else if (!strcmp(argv[i], "--stats")) {
	    a->stats = true;
	} else if (!strcmp(argv[i], "--bw")) {
	    a->bw = true;
	} else {
	    fprintf(stderr, "%s: unknown argument `%s'!\n", program, argv[i]);
	    exit(1);
	}
    }
} // Args::set
