%define name xrmap
%define version 2.29
%define release 1
%define prefix /usr

Summary: A tool to manipulate and create Earth maps.
Summary(fr): Un outil pour manipuler et gnrer des cartes de la Terre.
Name: %{name}
Version: %{version}
Release: %{release}
Serial: 0
Copyright: GPL
Group: Sciences/Astronomy
# Source: ftp://ftp.ac-grenoble.fr/ge/geosciences/%{name}-%{version}%{release}.tar.bz2
Source: ftp://ftp.ac-grenoble.fr/ge/geosciences/%{name}-%{version}.tar.bz2
# Source: ftp://ftp.ac-grenoble.fr/ge/geosciences/%{name}-%{version}.tgz
URL: http://freshmeat.net/projects/sunclock/
BuildRoot: %{_tmppath}/%{name}-buildroot
Prefix: %{_prefix}
Requires: libc.so.6(GLIBC_2.0)

%description
The Xrmap program is a user-friendly X client for manipulating the CIA
World data bank II global vector data and for generating maps  of the Earth. 
The maps can be very accurately zoomed in, up to a factor of 100 or more. 
The whole Earth can be explored by just pointing and clicking, and the maps 
can be printed and (somewhat) edited at any scale.

Xrmap is derived from the original command line program
'rmap' by Reza Naima (http://www.reza.net/rmap/).
However, Xrmap has many more features than 'rmap', especially it implements 
8 different projections (Spherical, Rectangular, Cylindrical, Mercator, 
Miller, Sinusoidal, Elliptic, Mollweide). It includes data bases for cities,
mountains, airports, observatories, and also extensive information on world 
countries and other data (hymns, anthems, local maps, ...). 

%description -l fr
The Xrmap program is a user-friendly X client for manipulating the CIA
World data bank II global vector data and for generating maps  of the Earth. 
The maps can be very accurately zoomed in, up to a factor of 100 or more. 
The whole Earth can be explored by just pointing and clicking, and the maps 
can be printed and (somewhat) edited at any scale.

Xrmap is derived from the original command line program
'rmap' by Reza Naima (http://www.reza.net/rmap/).
However, Xrmap has many more features than 'rmap', especially it implements 
8 different projections (Spherical, Rectangular, Cylindrical, Mercator, 
Miller, Sinusoidal, Elliptic, Mollweide). It includes data bases for cities,
mountains, airports, observatories, and also extensive information on world 
countries and other data (hymns, anthems, local maps, ...). 

%prep
rm -rf $RPM_BUILD_ROOT
%setup -q

%build
xmkmf
make CDEBUGFLAGS="$RPM_OPT_FLAGS" CXXDEBUGFLAGS="$RPM_OPT_FLAGS"

# %install
make install DESTDIR=$RPM_BUILD_ROOT%{prefix}
make install.man DESTDIR=$RPM_BUILD_ROOT%{prefix}
if [ -f $RPM_BUILD_ROOT%{prefix}/X11R6/man/man1/xrmap.1x ]; then
find $RPM_BUILD_ROOT%{prefix}/X11R6/man/man1/xrmap.1x -type f -exec bzip2 -9f {} \;
fi
mkdir -p $RPM_BUILD_ROOT/usr/share/icons
install xrmap.xpm -m 644 $RPM_BUILD_ROOT/usr/share/icons/xrmap.xpm
# toujours le mme pb avec le fichier emx
install editkit/emx $RPM_BUILD_ROOT%{prefix}/X11R6/bin


	# ajout les deux lignes suivantes le 14/08/2001 pour inclure la carte de la CIA
	# install /home/fm/RPM/SOURCES/CIA_map.rez.gz -m 644 $RPM_BUILD_ROOT/usr/share/rmap/CIA_map.rez.gz
	# gunzip $RPM_BUILD_ROOT/usr/share/rmap/CIA_map.rez.gz

%clean
rm -rf $RPM_BUILD_ROOT

%files
%defattr(-,root,root,0755)
%doc CHANGES INSTALL LICENSE MAPEDIT README TODO VECTORMAP WARNING EXAMPLE.rc midi_cfg/*
%{prefix}/share/icons/xrmap.xpm
%{prefix}/share/rmap/Locations
# %{prefix}/share/rmap/peaks
%{prefix}/share/rmap/Xrmaprc
%{prefix}/share/rmap/i18n/*
%{prefix}/share/rmap/themes/*
%{prefix}/share/rmap/pixmaps/*
%{prefix}/share/rmap/picons/*
%{prefix}/X11R6/bin/emx
%{prefix}/X11R6/bin/xrmap
%{prefix}/X11R6/man/man1/xrmap.1*
	# ajout la ligne suivante le 14/08/2001 pour inclure la carte de la CIA
	# %{prefix}/share/rmap/CIA_*

%postun
# $1 = 0 is remove; $1 = 1 is update
if [ "$1" = "0" ]; then
	# We delete the directories
	rmdir %{prefix}/share/rmap/anthems
	rmdir %{prefix}/share/rmap/factbook
	rmdir %{prefix}/share/rmap/flags
	rmdir %{prefix}/share/rmap/hymns
	rmdir %{prefix}/share/rmap/i18n
#	rmdir %{prefix}/share/rmap
fi

%changelog
* Fri Apr 05 2002 Francois Massonneau <frmas@free.fr>
- Added post uninstalled settings
* Tue Aug 14 2001 Francois Massonneau <frmas@free.fr>
- First spec file
