'\" t
.\" ** The above line should force tbl to be a preprocessor **
.\" Man page for man
.\"
.\" Copyright (C), 1994, 1995, Graeme W. Wilford. (Wilf.)
.\"
.\" You may distribute under the terms of the GNU General Public
.\" License as specified in the file COPYING that comes with the
.\" man_db distribution.
.\"
.\" Sat Oct 29 13:09:31 GMT 1994  Wilf. (G.Wilford@ee.surrey.ac.uk) 
.\" 
.TH xrmap 1x "May 15, 2003" "Xrmap-2.29" "manual page"
.SH "NAME"
xrmap \- Maps portions of the Earth from vector map datalongitude/latitude info
.SH "SYNOPSIS"
.PP
xrmap +cities -zoom 20 -category all -latitude 45 
      -longitude -80 -continent all -projection 3 
      -color "riv2,+blue"

.SH "DESCRIPTION"
This manual page documents the X11 xrmap program. Xrmap is a GIS
(Geographic Information System) that can read a custom format of the
CIA world data bank II global vector information to generate images of
the Earth under the X Window system. Features include coast lines,
political boundaries, rivers, lakes, glaciers, canals, major cities,
major airports, mountain peaks, etc. The images can be very accurately
zoomed in, up to a factor of 100 or more.  There is a variety of
options and parameters to control the output of the image, including
for instance the selection of geographic features to be displayed and
their colors. In addition to the standard Spherical projection, Xrmap
implements Rectangular, Cylindrical, Mercator, Miller, Sinusoidal,
Elliptic and Mollweide projections. All parameters can be adjusted
interactively from the builtin mouse driven menu, or from the command
line, or by editing a script. Up to some extent, the maps can be
edited or enriched by user defined features (pixmaps, labels, etc).
Xrmap includes extensive geographic or political data (as well as
flags, hymns, anthems, etc) concerning all world countries. For the
larger part, these data are extracted from the CIA World Fact Book,
which is in the public domain.
.PP
Xrmap was originally derived from the earlier program 'rmap' by Reza
Naima, a console mode program capable of producing png, jpeg or gif 
images of the Earth form the CIA World Data Base. However, xrmap now 
has many more features.
.SH "OPTIONS"
The following options are available. They can be abbreviated to 1,2 or 3
letters following the - (or +) sign, whenever the abbreviation is not
ambiguous. A double minus sign (--) is equivalent to a single one
(minus signs are not required when the options are entered in X mode from
the builtin command line).
.TP
.BI "-h"
Display a brief help page, then terminate.
.TP
.BI "-v"
Display the version of code.
.TP
.BI "-language \fIid\fR"
Sets the file of menu dialog messages to be xrmap_msg.id, where
id is the standard 2-letter identificator of a language. The default 
language is set from the environment LANG parameter, and falls back
to English if the corresponding language is not available in the
xrmap distribution.
.TP
.BI "-projection \fInumber\fR"
Select the type of projection. Possible numbers are 0=Spherical,
1=Rectangular, 2=Cylindrical, 3=Mercator, 4=Miller, 5=Sinusoidal, 
6=Elliptic, 7=Mollweide. Projection types 2, 5, 7 are area preserving,
while 3 (Mercator) is conformal (angles are preserved, but not areas
nor lengths). Sperical projection is by definition invariant by rotation
and is very accurate under large zoom values. The other types don't 
preserve anything (although Elliptic approximately preserves areas with 
maximal error 8% by excess near the Equator).
.TP
.BI "-accuracy \fInumber\fR"
Set the value of the accuracy parameter. When the value is smaller, the 
points interpolating polygonal lines of the vector map are more densely
spread. This produces more accurate details, at the expense of a longer 
calculation time. Practical values are in the range 0.1 ... 10.0, with 
1.0 being the default value.
.TP
.BI "-width \fInumber\fR"
The width of the image to generate, in pixels.
.TP
.BI "-height \fInumber\fR"
The height of the image to generate, in pixels.
.TP
.BI "-zoom \fInumber\fR"
Zoom level of the Earth.  Default is 1, which shows the whole Earth adjusted
to the window size.
.TP
.BI "-aspect \fInumber\fR"
Value of the aspect factor (= ratio height/width in modes other than
Spherical). Default is 1. Larger values will stretch the map in
the vertical direction. The option has no effect in Spherical mode.
.TP
.BI "-inclination \fInumber\fR"
Produce a map with given inclination of the Equator with respect
to horizontal direction (value in degrees).
.TP
.BI "-latitude \fInumber\fR "
Select point of given latitude as the center of map (Latitude value in 
degrees, + for North, - for South). Default latitude is 0 degree.
.TP
.BI "-longitude \fInumber\fR    "
Select point of given longitude as the center of map (longitude value in 
degrees, + for East, - for West). Default longitude is 0 degree.
.TP
.BI "-search \fIlocation\fR    "
Select coordinates of 'location' to be the center of the map. Default is
void location (no search performed at startup). If several identical or
different names match the location request (e.g. when a wildcard) has
been used, xrmap pops up a selection window at startup.
.TP
.BI "-field \fInumber\fR    "
Select the number of the field to be searched (1=name(default), 2=country,
3=region). This takes effect only when a search is performed.
.TP
.BI "-field \fIlocation\fR    "
Select coordinates of 'location' to be the center of the map. Default is
void location (no search performed at startup).
.TP
.BI "-gspacing \fInumber\fR"
Specify the grid spacing (in degrees) between consecutive meridians or 
parallels.
.TP
.BI "-gslat \fInumber\fR"
Specify the grid spacing (in degrees) between consecutive parallels.
.TP
.BI "-gslon \fInumber\fR"
Specify the grid spacing (in degrees) between consecutive meridians.
.TP
.BI "-coordinates \fIxy\fR"
Specifies how coordinates of grid lines (meridians, parallels) should be
written on the map. If xy=00, nothing is drawn; if xy=LB, latitudes are
written on the Left and longitudes at the Bottom. The xy string should
have exactly two letters, valid letters are 0=none, L=left, R=right, 
T=top, B=bottom. Default is 00.
.TP
.BI "-marksteps \fIt_1,t_2,t_3,t_4,t_5\fR"
Set the values of "thresholds" t_i for the virtual size of the Earth (i.e.,
the actual width of the window multiplied by the zoom factor), above which
markers of objects of magnitude i become visible (see below). Normally the 
t_i is an increasing sequence of integers, by default 150,1200,3000,6000,10000 
(for instance, objects of magnitude 1 and 2 will appear if the zoom is 
set to 1.5 and the window width is larger than 800, since 1.5*800 >= 1200).
.TP
.BI "-namesteps \fIt_1,t_2,t_3,t_4,t_5\fR"
Set the values of "thresholds" t_i for the virtual size of the Earth (i.e.,
the actual width of the window multiplied by the zoom factor), above which
names of objects of magnitude i become visible (see below). Normally the t_i 
is an increasing sequence of integers, by default 400,3000,8000,15000,25000 
(for instance, names of objects of magnitude 1 and 2 will appear if the zoom
is set to 4 and the window width is larger than 800, since 4*800 >= 3000).
.TP
.BI "-peakmarks \fIs_1,s_2,s_3,s_4,s_5\fR"
Set the sizes s_i of marks representing peaks of magnitude 1,2,3,4,5
(by decreasing importance). A size s_i equal to 0 means that the peaks
of magnitude i will not appear. If one sets e.g. -peakmarks 3,3,3,3,3
all peaks - whatever their magnitude - will be attributed a mark of
magnitude 3. If one sets -peakmarks 5,4,3,2,1 the size of the mark will be
inversely proportional to the magnitude of the city (just to give a
stupid example...)
.TP
.BI "-peaksizes \fIp_1,p_2,p_3,p_4,p_5\fR"
Specify the height over which a peak will be considered as of magnitude 
1,2,3,4,5 respectively by decreasing importance. The default
values are p_1=3000000, p_2=700000, p_3=300000, p_4=100000, p_5=1.
.TP
.BI "-citymarks \fIs_1,s_2,s_3,s_4,s_5\fR"
Set the sizes s_i of marks representing cities of magnitude 1,2,3,4,5
(by decreasing importance). A size s_i equal to 0 means that the cities 
of magnitude i will not appear. If one sets e.g. -citymarks 3,3,3,3,3
all cities - whatever their magnitude - will be attributed a mark of
magnitude 3. If one sets -citymarks 5,4,3,2,1 the size of the mark will be
inversely proportional to the magnitude of the city (just to give a
stupid example...)
.TP
.BI "-citysizes \fIp_1,p_2,p_3,p_4,p_5\fR"
Specify the population numbers over which a city will be considered as
of magnitude 1,2,3,4,5 respectively by decreasing importance. The default
values are p_1=3000000, p_2=700000, p_3=300000, p_4=100000, p_5=1.
.TP
.BI "-cityfilter \fIspecification\fR"
The specification is a string of at most three characters C,R,* (respectively
for Capital cities, Regional capital cities and ordinary cities). Only
those cities for which the corresponding category has been set will be
shown.
.TP
.BI "-locfilter \fIspecification\fR"
The specification is a string of a number of characters among the letters
B,C,I,K,L,O,R,S,T,V,* (respectively for Bay/gulfs, Countries, Islands, laKes,
Lands, Oceans, Reefs, Seas, sTraits, riVers, others). Only the locations
whose type is listed will appear.
.TP
.BI "-define \fIfeature_definition\fR"
Each 'define' creates a new feature to be linked with a geographic 
position in xrmap. This can be a pixmap, a polygonal line or region, an 
ellitic region, a system call, a new text label or a modification of an
existing label, etc. All defines are ranked according to the order in
which they have been set. A priori, the list of defines is empty. 
This option is provided as a way to introduce user defined objects or
system calls. The -secure option is there to disable system calls (for 
obvious security reasons).
.TP
.BI "-undefine \fIrank\fR"
This cancels the feature of the given rank (if any).
.TP
.BI "-rcfile \fIfilename\fR"
The path to the configuration rcfile which, among other things, defines 
the colors of various items that will be displayed, and whether they will 
be displayed at all. If the -rcfile value is not specified, the system wide
Xrmaprc will be parsed first, and the user defined \fI~/.xrmaprc\fR will 
be checked in second place if it exists. If the -rcfile value is set
the user defined \fI~/.xrmaprc\fR will be replaced by the specified file.
.TP
.BI "-mapfile \fIfilename\fR "
The path to the CIA map vector data file.  The default path of this 
file is specified in xrmap.h and is `SHAREDIR/CIA_WDB2.jpd'.
.TP
.BI "-locfile \fIfilename\fR "
The path to a file containing a list of timezones, cities or locations to 
display. The default path of this file is specified in xrmap.h,
and is `SHAREDIR/Locations'.
.TP
.BI "-outfile \fIfilename\fR "
The name of the file to which an output is to be written. Allowed formats
are PPM, XPM, PostScript or RcFile format, and corresponding file 
suffixes .ppm, .xpm, .ps, .eps or .rc should then be used (this is crucial 
since xrmap uses the suffix to determine which format it should use). With 
the ZLIB compilation option, xrmap will compress the output whenever option 
+compress is set. If filename is left NULL, xrmap will instead write the 
data to stdout (if any data are to be written). In that case, the data 
will *not* be compressed.
.TP
.BI "-pixmap \fIdestination|filename\fR "
Sets X pixmap file 'filename' to destination. Destination is one of:
data (data window background), cmd (command window background),
button0, button1, button2 (buttons in mode 0=normal, 1=highlighted,
2=pressed). 'filename' should point to a XPM file, or possibly a .xpm.gz
gzipped XPM file.
.TP
.BI "-theme \fIfilename\fR "
Loads theme file 'filename', so that the color menus and backgrounds can
be changed randomly. If 'filename' is not an absolute path, then xrmap
searches 'filename' in the current directory, and if it is not found,
then looks in the systemwide SHAREDIR/themes subdirectory.
.TP
.BI "-ppmout "
Write a PPM image at startup (after reading the config files and command
line options) and exit xrmap afterwards, without entering into the GUI.
.TP
.BI "-xpmout "
Write a XPM image at startup (after reading the config files and command
line options) and exit xrmap afterwards, without entering into the GUI.
.TP
.BI "-epsout "
Write an Encapsulated PostScript file at startup (after reading the config 
files and command line options) and exit xrmap afterwards, without entering 
into the GUI.
.TP
.BI "-psout "
Write a PostScript image at startup (after reading the config files and command
line options) and exit xrmap afterwards, without entering into the GUI.
.TP
.BI "-rcout "
Read the config files and command line options, output those parameters and 
the other defaults in RcFile format and exit xrmap afterwards, without 
entering into the GUI.
.TP
.BI "-preview \fItime\fR "
In the -ppmout, -xpmout, -epsout, -psout, -rcout modes, preview the 
corresponding image during 'time' (expressed in seconds), before exiting 
the program. The default is not to preview the image.
.TP
.BI "-arc \fIread|filename\fR "
Read 'filename' as arcinfo data. There are also some other exotic suboptions
to deal with arcinfo data. Chech the ARCINFO file for more details.
.TP
.BI "-dump \fIwrite|filename\fR "
Dump the vector map data into 'filename', and exit xrmap. If the
-category and -continent options are set, only the data which are
matching the selection will be dumped.  The data can be dumped either
in JPD format (dafault), or in ASCII format.  These choices can be
specified by -dump JPD or -dump ASCII, respectively.  The ASCII output
is more or less arcinfo-compatible, and can be fed back to xrmap via
the option 'xrmap -arc read|XXX'.
.TP
.BI "-pswidth \fIvalue\fR"
Set width of the PostScript output, in millimeters.
.TP
.BI "-pslinewidth \fIvalue\fR"
Set line width of the PostScript output, in PostScript points (1/72 inch).
.TP
.BI "-psleftmargin \fIvalue\fR"
Set width of the left margin of the PostScript output, in millimeters.
.TP
.BI "-psbottommargin \fIvalue\fR"
Set height of the bottom margin of the PostScript output, in millimeters.
.TP
.BI "-psrotate \fIangle\fR"
Rotate the PostScript output by <angle>. This parameter can only take
values 0,90 or -90.
.TP
.BI "-pscolor "
Use color for PostScript output (default).
.TP
.BI "-psgrayscale "
Use color for PostScript output.
.TP
.BI "-psviewer \fIname\fR "
Select the PostScript viewer (gv by default). If xrmap has been compiled
with the ZLIB option, the PostScript viewer should be able to decompress 
files on the fly.
.TP
.BI "-imviewer \fIname\fR "
Select the generic image viewer (display, from the ImageMagick package, 
by default). 
.TP
.BI "-printcmd \fIstring\fR "
Specify the printing command (lpr -Plocal by default).
.TP
.BI "-editor \fIstring\fR "
Specify the command line of the text editor (emacs by default).
.TP
.BI "-musicplayer \fIstring\fR "
Specify the command line of the music player, used to play National hymns
(timidity by default, with default music format MIDI).
.TP
.BI "-continent \fIlist\fR"
Sets the list of continents for which features are to be shown.
Either the word `\fBall\fR' or a list of comma separated numbers/items 
where
1=(Af)rica, 2=(As)ia, 3=(Eu)rope, 4=N.America (NA), 5=S.America (SA),
6=(Oc)eanic.  
[In case letters as used, e.g. EU or EUR... for Europe, upper or lower case 
do not matter, and a longer string will be accepted]. If no option is 
specified then `\fBall\fR' is assumed. The 6th item (Oceanic) is
meant only for labels of seas and oceans, and does not represent a
continent in itself.
.TP
.BI "-category \fIlist\fR"
Sets the list of categories for which features are to be shown.
Either the word `\fBall\fR' or a list of comma separated numbers where
1=(int)ernational boundaries, 2=(nat)ional state boundaries, 3=(riv)ers, 
4=Coasts, Islands, Lakes (cil).
[In case letters as used, e.g. RIV for rivers, upper or lower case 
do not matter, and a longer string will be accepted]. 
If no option is specified then `\fBall\fR' is assumed.
.TP
.BI "-hierarchy \fIabcde\fR"
Specify the permutation abcde of 01234, e.g. 34021, which will define
the precedence of features: riv=3 will overwrite cil=4, which overwrite
cfg=0 which overwrite nat=2 which overwrite int=1 (the result of such
an ordering is maybe absurd... just try). The default is 01234.
.TP
.BI "-color \fIi,colorname\fR"
Sets parameters of color[i] in the internal table of items/colors to be 
displayed. The parameter string colorname should be composed optionally of
a sign + or - followed (without any blank space) by a color specification. 
The sign is a flag specifying whether the item will be displayed or not, 
and the color is of course the color in which the item will be drawn. 
The color specification should be either one of the conventional colors 
from the rgb.txt file, or an hexadecimal value #uvwxyz with 6 places 
(indicating the three RGB bytes, respectively). The index `i' stands for 
the type of object (i=0..2 for International boundaries, i=3,4 for
National State boundaries, i=5..16 for River types, i=17..27 for
Coasts, Islands and Lakes of various types, i=28..34 for Earth/Gridline
colors, i=35..42 for Mark/Label colors, i=43..51 for Menu/widget colors 
(foreground/background of text menus, widgets, etc). The precise list of 
item numbers is explained below. For easier manipulation, the index i can also
be specified e.g. as int, nat, riv, cil, ear, lab, mnu (which have respective 
offsets int->0, nat->3, riv->5, cil->16, ear->28, lab->35, mnu->45) 
e.g. int2=2, nat1=4, riv3=8, cil5=21, lab6=41.
.TP
.BI "-font \fIi,fontname\fR"
Define the i-th font (i=1,2,3,4,5) to be used for cities and locations 
mentioned on the map, for the magnitude i. Index i=0 is also admitted,
and stands for the font used in the builtin menus.
.TP
.BI "-menu \fItype\fR"
Start xrmap in menu mode 'type', specified as one character. Then xrmap 
just loads a blank image and does not show any map.
.TP
.BI "-reverse "
Reverse the colors (white and black exchanged and so on).
.TP
.BI "-resetcolors "
Change the colormap and reset all colors. This is effective (and useful)
only in pseudo-color mode, when the colormap is full, for instance after
many national flags involving too many colors have been viewed.
.TP
.BI "-ranking "
Recalculate the country/continent/worldwide ranks of cities and peaks,
and output the result to stdout. This is useful in case more entries
have been added in the list, so that the ranks have to be recalculated.
.TP
.BI "dms "
Use (+) or do not use (-) degree-minute-second mode for the output of
angle values. If -dms is set, angles are shown with 3 decimal places.
.TP
.BI "memory "
Store (+) or do not store (-) the vector map in RAM. Storing the vector
map in RAM requires 10 Mbytes of memory and speeds up a little bit
xrmap's operation.
.TP
.BI "secure "
Set (+) or unset (-) secure mode. Under the secure mode, user defined system
calls (such as those set via -define "exec|...") are disabled. Default is
"unsecure" mode, which allows e.g. to use xrmap as a presentation tool.
.TP
.BI "compress "
Use (+) or do not use (-) gzip compression for output files. Default is 
no compression (-).
.TP
.BI "tropics "
Display (+) or do not display (-) tropics/equator/polar circles on the map.
By default they are drawn in brown4.
.TP
.BI "gridlines "
Display (+) or do not display (-) gridlines on the map.  By default they 
are drawn in orange, spaced at 15 degrees.
.BI "earthcontour "
Display (+) or do not display (-) the Earth contour on the map. 
By default it is displayed.
.TP
.BI "cities "
Display or do not display cities (from the system wide or user specified 
-locfile) on the map. Option ++cities displays also city names. 
Default is +cities.
.TP
.BI "airports "
Display or do not display airports (from the system wide or user specified 
-locfile) on the map. Option ++airports displays also airport names. 
Default is -airports.
.TP
.BI "observatories "
Display or do not display observatories (from the system wide or user 
specified -locfile) on the map. Option ++observatories displays also
observatory names. Default is -observatories.
.TP
.BI "peaks "
Display or do not display mountain peaks (from the system wide or user 
specified -locfile) on the map. Option ++peaks also displays peak names.
Default is +peaks.
.TP
.BI "locations "
Display or do not display names of other locations (from the system wide 
or user specified -locfile). Default is -locations.
.TP
.BI "placename "
Vary (or do not vary) the position of the city name according to the
position of the city on the map. In case the flag is not set, the name
always appears above the city mark, on the right. In case the flag is
set, the name may appear on the left of the mark, or below, if the
mark appears in the right half (resp. upper half) of the window.
Default is -placename.
.TP
.BI "smartlabels "
When +smartlabels is set, any label that would overlap a label previously 
drawn on the map is omitted. This requires a small amount of additional 
memory, and is the default. The option is disabled when -smartlabels is set.
.TP
.BI "transparent "
In Spherical mode, represent (+) or not (-) the continents appearing on
the opposite hemisphere, as if the Earth was transparent. By default
this option is not set, and it has no effect in non spherical modes.
.SH "GUI COMMANDS"
Xrmap has internal keyboard shortcuts that allow to change interactively most
of the settings. These shortcuts are:
.PP
   ! ?  M F D S O C N @ H V Q I A B P L E G T R K
.BR
   < + - & * <Arrows> <Space> <Escape>
.PP
Key '!' enables the command line mode (see below). Key '?' displays the 
available keyboard shortcuts. Keys 'M', 'F', 'D', 'S', 'O', 'C', 'N', '@' 
open  respectively  the general menu, the file menu, the command menu, the 
search menu, the option menu, the color menu, the map edition menu, the file
explorer. 
.BR
Key 'H' opens an xterm showing the xrmap manpage, key 'V' shows the version 
number and date of package, key 'Q' quits the program. 
.BR
Keys 'I', 'A', 'B', 'P' 'L', 'E', 'G', 'T' are toggles to be used to 
show or not to show cIties, Airports, oBservatories, Peaks, Locations, 
Earth contour, Gridlines and Tropics/Equator/Polar circles, respectively.
.BR
Key 'R' reverses the colors, key 'K' closes the city/location data window,
key '<' recalculates/redisplays the image (xrmap reads again the locfile, 
so that you can possibly see changes made in that file). Keys '+' and '-' 
zoom in or zoom out the image by a factor equal to square root of 2. 
Arrows can be used to change the point at which the map is centered
(concurrently with the right mouse button), changing the latitude or
longitude by some amount which depends on the zoom factor. 
Key '&' saves the map as an encapsulated PostScript file and loads it
into a PostScript viewer for printing.
Key '*' exports the parameters into a .rc file, in a format which can be fed
back to xrmap through a command line 'xrmap -rcfile xyz.rc'
Space or escape keys can be used to erase the top and bottom text mentions.
.SH "COMMAND LINE MODE"
The command line mode allows a more precise and complete handling 
of the options. The user has to edit the command line, and the modification
take place only when <Return> has been pressed (one can also escape the
command line mode without taking any action by pressing <Escape>). Several
parameters can be set simultaneously. The available abbreviated keys or 
keywords are
.PP
   +ci(ties) -ci(ties) +air(ports) -air(ports) 
.BR
   +obser(vatories) -obser(vatories)
.BR
   +pea(ks) -pea(ks) +l(ocations) -l(ocations)
.BR
   +e(arthcontour) -e(arthcontour)
.BR
   +g(ridlines) -g(ridlines) +trop(ics) -trop(ics)
.BR
   +tran(sparency) -tran(sparency)
.PP
which are respectively switches for cities, locations, peaks, Earth contour,
gridlines, tropics and the transparent mode. Other parameters are set by 
prescribing
.PP
   p <type>  w <value>  h <value>  z <value>  a <value>  
.BR
   f <i,name>
.PP
respectively for projection type, width, height of window, zoom, aspect 
(the aspect parameter is used only in modes other than Spherical), 
and font of index i;
.PP
   lon <value>  lat <value>  
.BR
   gspacing <value>  slat <value>  slon <value>
.PP
respectively for longitude, latitude (of point at which the map will be
centered), and spacing (spacing in latitude or longitude). Categories
and continents are set by
.PP
   cat(egory) <list>  con(tinent) <list>
.PP
as above. Item colors and display flags can be changed by setting
.PP
   col(or) i,()colorname
.PP
which then attributes color[i]=()colorname [See below for the table of
items and their indices. Colors can be globally reversed with the single 
command 'r' or 'rev' or 'reverse' without any parameter.
.SH "FEATURES"
The following features are available for plotting. To each of these features
is associated a color, indexed as color[i], possibly specified e.g. as
CIL2, which stands for <start of CIL section>+2.
.PP
.BI "International Boundaries [int]"
.PP
   Demarcated or delimited boundary [0]
.BR
   Indefinite or in Dispute [1]
.BR
   Other lines of separation of sovereignty on land [2]
.PP
.BI "National (US) State Boundaries [nat]"
.PP
   State boundary lines on land [3]
.BR
   State boundary lines on water [4]
.PP 
.BI "Rivers [riv]"
.PP
   Permanent major rivers [5]
.BR
   Additional major rivers [6]
.BR
   Additional rivers [7]
.BR
   Minor rivers [8]
.BR
   Double lined rivers [9]
.BR
   Intermittent rivers - major [10]
.BR
   Intermittent rivers - additional [11]
.BR
   Intermittent rivers - minor [12]
.BR
   Major canals [13]
.BR
   Canals of lesser importance [14]
.BR
   Canals - irrigation type [15]
.PP
.BI "Coasts, Islands and Lakes [cil]"
.PP
   Coasts, major islands and lakes [16]
.BR
   Additional major islands and lakes [17]
.BR
   Intermediate islands and lakes [18]
.BR
   Minor islands and lakes [19]
.BR
   Intermittent major lakes [20]
.BR
   Intermittent minor lakes [21]
.BR
   Reefs [22]
.BR
   Salt pans - major [23]
.BR
   Salt pans - minor [24]
.BR
   Ice Shelves - major [25]
.BR
   Ice Shelves - minor [26]
.BR
   Glaciers [27]
.PP
.BI "Earth/Grid features [ear]"
.PP
   Background color of map [28]
.BR
   Background color of sky [29]
.BR
   Foreground color of stars [30]
.BR
   Color of Equator, Tropics and Polar circles [31]
.BR
   Color of Parallel gridlines [32]
.BR
   Color of Meridian gridlines [33]
.BR
   Color of Earth contour [34]
.PP
.BI "Marks and labels [lab]"
.PP
   Color of circular city marks [35]
.BR
   Color of text of city names [36]
.BR
   Color of symbols representing airports [37]
.BR
   Color of text of airport names [38]
.BR
   Color of symbols representing observatories [39]
.BR
   Color of text of observatory names [40]
.BR
   Color of triangles representing peaks [41]
.BR
   Color of text of peak names [42]
.BR
   Color of text of location labels (land) [43]
.BR
   Color of text of location labels (water) [44]
.PP
.BI "Menu/Widget colors [mnu]"
.PP
   Foreground color of text menus [45]
.BR
   Background color of text menus [46]
.BR
   Foreground color of text caret [47]
.BR
   Background color of command window [48]
.BR
   Background color of Escape button [49]
.BR
   Foreground color of triangular ticks [50]
.BR
   Foreground color of directory labels [51]
.BR
   Foreground color of image labels [52]
.BR
   Color of cross representing a marked point [53]
.BR
   Foreground color of the selection rectangle [54]
.BR
   Foreground color of the current selected point [55]
.PP
.SH "AUTHOR"
Jean-Pierre Demailly <demailly@ujf-grenoble.fr>
.SH "HISTORY"
Xrmap is loosely derived from 'rmap' by Reza Naima <reza@reza.net>
It no longer shares much code with the original program.
.SH "BUGS"
Xrmap seems to work pretty well in most cases, however it might
still have problems related to incorrect command line options being
entered while the program runs (especially, check segfaults or buffer
overflows). 
.PP
Xrmap still needs the X environment even when the user merely asked an
image output; this is unlikely to be fixed any time soon -- just use
`rmap' if you need to operate without a GUI running, e.g. for web
serving.
