/*
 * Copyright 1991 The University of Newcastle upon Tyne
 * 
 * Permission to use, copy, modify and distribute this software and its
 * documentation for any purpose other than its commercial exploitation
 * is hereby granted without fee, provided that the above copyright
 * notice appear in all copies and that both that copyright notice and
 * this permission notice appear in supporting documentation, and that
 * the name of The University of Newcastle upon Tyne not be used in
 * advertising or publicity pertaining to distribution of the software
 * without specific, written prior permission. The University of
 * Newcastle upon Tyne makes no representations about the suitability of
 * this software for any purpose. It is provided "as is" without express
 * or implied warranty.
 * 
 * THE UNIVERSITY OF NEWCASTLE UPON TYNE DISCLAIMS ALL WARRANTIES WITH
 * REGARD TO THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL THE UNIVERSITY OF
 * NEWCASTLE UPON TYNE BE LIABLE FOR ANY SPECIAL, INDIRECT OR
 * CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF
 * USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
 * OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 * 
 * Author:  Gerry Tomlinson (gerry.tomlinson@newcastle.ac.uk)
 *          Computing Laboratory, University of Newcastle upon Tyne, UK
 */

/*
 * text.c - operations on text widget
 *
 */

#include <stdio.h>
#include <ctype.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Shell.h>
#include <X11/Xaw/AsciiText.h>

#include "text.h"

/*
 * setinsertionpoint
 *
 * sets the insertionpoint and scrolls &  centres  if
 * not on screen
 *
 * go to some lengths to figure this out & have to unmap & map
 * to avoid drawing twice with nasty flicker
 */

void
setinsertionpoint(text,newpos)
    Widget text;
    XawTextPosition newpos;
{
    Widget textsrc = XawTextGetSource(text);
    Widget textsink ;
    XawTextPosition displaypos, offdisplaypos;
    Dimension height, tm, bm;			/* of text sink */
    int lines;				/* displayable  by textsink */

/*    XtVaSetValues(text,XtNdisplayPosition,
				XawTextSourceScan(textsrc, newpos, XawstEOL,
				XawsdLeft, 1, False),
		NULL);
    XawTextSetInsertionPoint(text, newpos);
    return;
*/
    XtVaGetValues(text,XtNdisplayPosition,&displaypos, 
			XtNheight,&height,
			XtNtopMargin, &tm,
                        XtNbottomMargin, &bm,
			XtNtextSink, &textsink,
			NULL);

    lines = XawTextSinkMaxLines(textsink,height -tm -bm);
    offdisplaypos =  XawTextSourceScan(textsrc, displaypos, XawstEOL,
				XawsdRight, lines, True);

   

    if ((newpos < displaypos) || (newpos >= offdisplaypos)) {
	XtUnmapWidget(text); 
	XawTextSetInsertionPoint(text, newpos);
	XtCallActionProc(text,"redraw-display",NULL,NULL,0);
 	XtMapWidget(text); 
    }
    else 
       XawTextSetInsertionPoint(text, newpos);

}



/*
 * GotoLine
 *
 * set caret to beginning of line 
 * 
 */ 
void
GotoLine(text, line)
     Widget text;
     int line;
{
    Widget textSrc = XawTextGetSource(text);
    XawTextPosition target;

    target = XawTextSourceScan(textSrc, (XawTextPosition) 0, XawstEOL,
                               XawsdRight, line - 1, True);

    setinsertionpoint(text,target);

}

int
Where(ed)
    Widget ed;

{
    Widget textSrc;
    XawTextPosition caret, eol, nexteol;
    int where = 1;

    textSrc = XawTextGetSource(ed);

    caret = XawTextGetInsertionPoint(ed);
    eol = XawTextSourceScan(textSrc, 0, XawstEOL, XawsdRight, 1, False);
    nexteol = XawTextSourceScan(textSrc, eol + 1, XawstEOL, XawsdRight, 1, False);
   while (eol < caret)
    {
        eol = nexteol;
        nexteol = XawTextSourceScan(textSrc, eol + 1, XawstEOL, XawsdRight, 1, False);
        ++where;
    }
    return where;
}


/*
 * given a text widget return the textsink widget
 *
 */
Widget getsink(text)
    Widget text;
{
    XtVaGetValues(text, XtNtextSink,&text, NULL);
    return (text);
}

/*
 * SetSelection
 *
 * set the selection, set the caret to before or after
 *
 */
void SetSelection(text, from, to, after)
     Widget text;
     XawTextPosition from, to;
     Boolean after;
{
    extern Display *display;
    int length = (int) (to - from);
    XawTextBlock block;

    block.firstPos = 0;
    block.length = length;
    block.format = FMT8BIT;
    XawTextSourceRead(XawTextGetSource(text), from, &block, length);

    XawTextSetSelection(text,from, to);		/* PRIMARY */
    XStoreBytes(display, block.ptr, length); /* CUT_BUFFER0 */
    setinsertionpoint(text, after ? to : from);
}

/*
 * outputselection
 *
 * write selection to a file 
 *
 */
void
outputselection(text,file,data)
    Widget text;
    FILE* file;
    char* data;
{
	XawTextPosition  from,to; 
	int length;

	XawTextGetSelectionPos(text,&from,&to);
	length = (int) (to - from);
	write(fileno(file),data + from,length);
}
