// Copyright 2019 The Xorm Authors. All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

package names

import (
	"strings"
	"testing"
)

func TestGonicMapperFromObj(t *testing.T) {
	testCases := map[string]string{
		"HTTPLib":             "http_lib",
		"id":                  "id",
		"ID":                  "id",
		"IDa":                 "i_da",
		"iDa":                 "i_da",
		"IDAa":                "id_aa",
		"aID":                 "a_id",
		"aaID":                "aa_id",
		"aaaID":               "aaa_id",
		"MyREalFunkYLONgNAME": "my_r_eal_funk_ylo_ng_name",
	}

	for in, expected := range testCases {
		out := gonicCasedName(in)
		if out != expected {
			t.Errorf("Given %s, expected %s but got %s", in, expected, out)
		}
	}
}

func TestGonicMapperToObj(t *testing.T) {
	testCases := map[string]string{
		"http_lib":                  "HTTPLib",
		"id":                        "ID",
		"ida":                       "Ida",
		"id_aa":                     "IDAa",
		"aa_id":                     "AaID",
		"my_r_eal_funk_ylo_ng_name": "MyREalFunkYloNgName",
	}

	for in, expected := range testCases {
		out := LintGonicMapper.Table2Obj(in)
		if out != expected {
			t.Errorf("Given %s, expected %s but got %s", in, expected, out)
		}
	}
}

func BenchmarkSnakeCasedName(b *testing.B) {
	b.ReportAllocs()
	b.ResetTimer()

	s := strings.Repeat("FooBar", 32)
	for i := 0; i < b.N; i++ {
		_ = snakeCasedName(s)
	}
}

func BenchmarkTitleCasedName(b *testing.B) {
	b.ReportAllocs()
	b.ResetTimer()

	s := strings.Repeat("foo_bar", 32)
	for i := 0; i < b.N; i++ {
		_ = titleCasedName(s)
	}
}
