/**
 * @file	viewer.h
 * @brief	DebugUty pr[ NX̐錾уC^[tFCX̒`܂
 */

#pragma once

#include "..\misc\WndProc.h"

class CDebugUtyItem;

//! r[ő吔
#define NP2VIEW_MAX		8

/**
 * @brief r[ NX
 */
class CDebugUtyView : public CWndProc
{
public:
	static void Initialize(HINSTANCE hInstance);
	static void New();
	static void AllClose();
	static void AllUpdate(bool bForce);

	CDebugUtyView();
	virtual ~CDebugUtyView();
	void UpdateCaption();
	UINT32 GetVScrollPos() const;
	void SetVScrollPos(UINT nPos);
	void SetVScroll(UINT nPos, UINT nLines);
	void UpdateVScroll();

protected:
	virtual LRESULT WindowProc(UINT message, WPARAM wParam, LPARAM lParam);
	virtual BOOL OnCommand(WPARAM wParam, LPARAM lParam);
	int OnCreate(LPCREATESTRUCT lpCreateStruct);
	void OnSize(UINT nType, int cx, int cy);
	void OnPaint();
	void OnVScroll(UINT nSBCode, UINT nPos, HWND hwndScrollBar);
	void OnEnterMenuLoop(BOOL bIsTrackPopupMenu);
	void OnActivate(UINT nState, HWND hwndOther, BOOL bMinimized);
	virtual void PostNcDestroy();

private:
	bool m_bActive;				//!< ANeBu tO
	UINT m_nVPos;				//!< ʒu
	UINT m_nVLines;				//!< C
	UINT m_nVPage;				//!< 1y[W̕\
	UINT m_nVMultiple;			//!< {
	CDebugUtyItem* m_lpItem;	//!< \ACe
	static DWORD sm_dwLastTick;	//!< ŌTick
	void SetMode(UINT nID);
	void SetSegmentItem(HMENU hMenu, int nId, LPCTSTR lpSegment, UINT nSegment);
	void UpdateView();
	static void UpdateActive();
};

/**
 * ݂̈ʒuԂ
 * @return ʒu
 */
inline UINT32 CDebugUtyView::GetVScrollPos() const
{
	return m_nVPos;
}
