#include "common.h"

extern Pixmap digitXpms[10];
extern Display *display;
extern Window win;
extern GC gc;
extern void error(int errorCode);
extern XpmAttributes myXpmAttributes;

numericDisplay::numericDisplay(int newDigits, int newValue, int newX, int newY) {

  digits = newDigits;
  value = newValue;
  x = newX;
  y = newY;
}

numericDisplay::~numericDisplay() {
}

void numericDisplay::setValue(int newValue) {
  value = newValue;
}

void numericDisplay::draw() {
  int i, digit;

  for(i = 0; i < digits; i++) {
    digit = (int)pow(10.0,((float)digits - (float)i - 1.0));
    digit = value / digit % 10;
    XCopyArea(display, digitXpms[digit], win, gc, 0, 0, 10, 20, x+i*10, y);
  }
}
