/* XNibbles - A simple X11 snake game
   Copyright (C) 1998 Sean MacIsaac and Ian Peters
  
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
  
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY of FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
  
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
  
   Specific questions about this program can be addressed to the authors,
   Sean Macisaac (sjm@acm.org), and Ian Peters (ipeters@acm.org). */

#include "common.h"

extern Display *display;
extern Window win;
extern GC gc;
extern void error(int errorCode);
extern XpmAttributes myXpmAttributes;

walls::walls() {
  makePixmap(wall1_xpm, &images[0]);
  makePixmap(wall2_xpm, &images[1]);
  makePixmap(wall3_xpm, &images[2]);
  makePixmap(wall4_xpm, &images[3]);
  makePixmap(wall5_xpm, &images[4]);
  makePixmap(wall6_xpm, &images[5]);
  makePixmap(wall7_xpm, &images[6]);
  makePixmap(wall8_xpm, &images[7]);
  makePixmap(wall9_xpm, &images[8]);
  makePixmap(wall10_xpm, &images[9]);
  makePixmap(wall11_xpm, &images[10]);
}

void walls::draw(char which, char x, char y) {
  XCopyArea(display, images[which - 'b'], win, gc, 0, 0, 10, 10, x*10, y*10); 
}

walls::~walls() {
  int count;

  for (count = 0; count < 11; count++) {
    XFreePixmap(display, images[count]);
  }
}
