/* XNibbles - A simple X11 snake game
   Copyright (C) 1998 Sean MacIsaac and Ian Peters
  
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
  
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY of FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
  
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
  
   Specific questions about this program can be addressed to the authors,
   Sean Macisaac (sjm@acm.org), and Ian Peters (ipeters@acm.org). */

#include "common.h"

extern int drops;
extern int keys[5][2];

people::people(int numGuys1, char name1[], char name2[], int c1, int c2) {
  int temp;

  numGuys = numGuys1;
  temp = (strlen(name1)>10)?10:strlen(name1);

  guys[0] = new worm(keys[0][0], keys[1][0], keys[2][0], keys[3][0], keys[4][0], name1, 15, HEIGHT-25, c1, 0);
  if (numGuys == 2)
    guys[1] = new worm(keys[0][1], keys[1][1], keys[2][1], keys[3][1], keys[4][1], name2, 5+(temp*10)+190, HEIGHT-25, c2, 1);
}

people::~people() {
  delete guys[0];
  if (numGuys == 2) {
    delete guys[1];
  }
}

void people::setPosDir(int which, int x, int y, int dx, int dy) {
  if (which == 1)
    guys[0]->newLevel(x, y, dx, dy);
  if (which == 2 && numGuys == 2)
    guys[1]->newLevel(x, y, dx, dy);
}

void people::showStatusMaybe() {
  guys[0]->showStatusMaybe();
  if (numGuys == 2)
    guys[1]->showStatusMaybe();
}

void people::showStatus(int which) {
  guys[0]->showStatus(which);
  if (numGuys == 2)
    guys[1]->showStatus(which);
}

void people::drawAll() {
  guys[0]->drawAll();
  if (numGuys == 2)
    guys[1]->drawAll();
}

void people::eraseAll() {
  guys[0]->eraseAll();
  if (numGuys == 2)
    guys[1]->eraseAll();
}

int people::moveOrGrow() {
  if (numGuys == 1) {
    guys[0]->moveTail();
    return (guys[0]->move());
  }
  else {
    int x1, x2;
    guys[0]->moveTail();
    guys[1]->moveTail();
    x1 = guys[0]->move();
    x2 = guys[1]->move();
    if (guys[0]->getHead()->getX() == guys[1]->getHead()->getX() &&
        guys[0]->getHead()->getY() == guys[1]->getHead()->getY())
      guys[0]->killMe();
    return (x1 || x2);
  }
}

int people::getLives() {
  if (numGuys == 1)
    return guys[0]->getLives();
  else if (guys[0]->getLives() < guys[1]->getLives())
    return guys[0]->getLives();
  else
    return guys[1]->getLives();
}

int people::changeDir(int key) {
  if (numGuys == 1)
    return guys[0]->changeDir(key);
  else
    return ((guys[0]->changeDir(key)) | (guys[1]->changeDir(key)));
}

void people::setGrow(int grow) {
  guys[0]->setGrow(grow);
  if (numGuys > 1) guys[1]->setGrow(grow);
}

void people::subs() {
  int barfbags;
  
  barfbags = guys[0]->getScore() - 1;
  if (barfbags >= 0) {
    guys[0]->setRealScore(barfbags);
    showStatus(2);
  }
  if (numGuys > 1) {
    barfbags = guys[1]->getScore() - 1;
    if (barfbags >= 0) {
      guys[1]->setRealScore(barfbags);
      showStatus(2);
    }
  }
}

int people::melt() {
  int toReturn;
  int toReturn2;

  toReturn = guys[0]->melt();
  if (numGuys > 1)
    toReturn2 = guys[1]->melt();
  else
    toReturn2 = 0;
  return (toReturn || toReturn2);
}

void people::resetMelt() {
  guys[0]->resetMelt();
  if (numGuys > 1)
    guys[1]->resetMelt();
}

int people::unPause() {

  return guys[0]->unPause() & ((numGuys>1)?guys[1]->unPause():1);
}

void people::reverse(int which) {
  guys[which]->reverse();
}
