/* XNibbles - A simple X11 snake game
   Copyright (C) 1998 Sean MacIsaac and Ian Peters

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY of FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

   Specific questions about this program can be addressed to the authors,
   Sean Macisaac (sjm@acm.org), and Ian Peters (ipeters@acm.org). */

#include "common.h"

extern Window win;
extern GC gc;
extern Display *display;
extern XpmAttributes myXpmAttributes;
extern void error(int errorCode);
extern int stayOnLevel;

counter::counter(int ax, int ay) {
  x = ax;
  y = ay;
  makePixmap(num0_xpm, &numbers[0]);
  makePixmap(num1_xpm, &numbers[1]);
  makePixmap(num2_xpm, &numbers[2]);
  makePixmap(num3_xpm, &numbers[3]);
  makePixmap(num4_xpm, &numbers[4]);
  makePixmap(num5_xpm, &numbers[5]);
  makePixmap(num6_xpm, &numbers[6]);
  makePixmap(num7_xpm, &numbers[7]);
  makePixmap(num8_xpm, &numbers[8]);
  makePixmap(num9_xpm, &numbers[9]);
  makePixmap(unused_xpm, &numbers[10]);
}

counter::~counter() {
  int foo;

  for (foo = 0; foo < 11; foo++)
    XFreePixmap(display, numbers[foo]);
}

void counter::draw(int numAs) {
  int i;

  if (stayOnLevel) {
    i = numAs + 1;
  }
  else {
    i = 10 - numAs;
  }
  if (i < 10) {
    XCopyArea(display, numbers[10], win, gc, 0, 0, 10, 20, x - 10, y);
    XCopyArea(display, numbers[i], win, gc, 0, 0, 10, 20, x, y);
  }
  else {
    XCopyArea(display, numbers[i/10], win, gc, 0, 0, 10, 20, x - 10, y);
    XCopyArea(display, numbers[i%10], win, gc, 0, 0, 10, 20, x, y);
  }
}
