/* XNibbles - A simple X11 snake game
   Copyright (C) 1998 Sean MacIsaac and Ian Peters
  
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
  
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY of FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
  
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
  
   Specific questions about this program can be addressed to the authors,
   Sean Macisaac (sjm@acm.org), and Ian Peters (ipeters@acm.org). */

#include "common.h"

extern Display *display;
extern char objects[BWIDTH][BHEIGHT];
extern int punishment;
extern int stayOnLevel;

boni::boni() {
  int foo;

  numBonus = 0;
  for (foo = 0; foo < MAXBONI; foo++)
    bonuses[foo] = NULL;
  numAs = 0;
  gotem = new counter(WIDTH-15, HEIGHT-25);
}

boni::~boni() {
  for (int foo = 0; foo < numBonus; foo++) {
    bonuses[foo]->erase(); 
    delete bonuses[foo];
  }
  delete gotem;
}

void boni::drawAll() {
  for (int foo = 0; foo < numBonus; foo++) {
    bonuses[foo]->draw();
  }
}

void boni::eraseAll() {
  for (int foo = 0; foo < numBonus; foo++) {
    bonuses[foo]->erase();
  }
  reset();
}

void boni::addBonus(char which, int which2) {
  char x, y;

  do {
    x = random() % (BWIDTH-1);
    y = random() % (BHEIGHT-1);
  } while (objects[x][y] != 'a' || objects[x + 1][y] != 'a' || objects[x][y + 1] != 'a' || objects[x + 1][y + 1] != 'a'); 
  bonuses[numBonus++] = new bonus(which, x, y, which2);
}

void boni::addBonus(char which, int which2, int xx, int yy) {
  bonuses[numBonus++] = new bonus(which, xx, yy, which2);
}

void boni::removeBonus(char x, char y) {
  int which = numBonus;
  int foo;

  for (foo = 0; foo < numBonus; foo++)
    if (bonuses[foo]->me(x,y)) {
      if (objects[x][y] == 'A') {
        numAs++;
        gotem->draw(numAs);
      }
      bonuses[foo]->erase();
      delete bonuses[foo];
      which = foo;
    }
  numBonus--;
  for (foo = which; foo < numBonus; foo++)
    bonuses[foo] = bonuses[foo + 1];
}

void boni::reset() {
  numBonus = 0;
  for (int foo = 0; foo < numBonus; foo++)
    delete bonuses[foo];
  numAs = 0;
} 

int boni::getNumAs() {
  return numAs;
}

void boni::scan() {
  int bob, foo;
  int george;

  for (bob=0; bob < numBonus; bob++)
    if ((george = bonuses[bob]->checkme())) {
      bonuses[bob]->erase();
      delete bonuses[bob];
      numBonus--;
      for (foo = bob; foo < numBonus; foo++)
        bonuses[foo] = bonuses[foo + 1];
      bob--;
      if (george == 'A') {
        addBonus('A', 0);
        drawAll();
        punishment--;
      }
    }
}

void boni::counterDraw() {
  gotem->draw(numAs);
}
