#!/bin/sh

SCRIPT=$(readlink -f $0)
DIR=$(dirname $SCRIPT)

XNEDIT_BIN=$DIR/xnedit-bin

CONFIG_DIR=/tmp/xnedit/etc

FONTS_CONFIG_DIR=$CONFIG_DIR/fonts


if [ ! -d "$FONTS_CONFIG_DIR" ]; then
	mkdir -p $FONTS_CONFIG_DIR
fi

if [ ! -f "$FONTS_CONFIG_DIR/fonts.conf" ]; then
	cat > $FONTS_CONFIG_DIR/fonts.conf << __EOF__
<?xml version="1.0"?>
<!DOCTYPE fontconfig SYSTEM "urn:fontconfig:fonts.dtd">
<!-- /etc/fonts/fonts.conf file to configure system font access -->
<fontconfig>
	<description>Default configuration file</description>

<!--
	DO NOT EDIT THIS FILE.
	IT WILL BE REPLACED WHEN FONTCONFIG IS UPDATED.
	LOCAL CHANGES BELONG IN 'local.conf'.

	The intent of this standard configuration file is to be adequate for
	most environments.  If you have a reasonably normal environment and
	have found problems with this configuration, they are probably
	things that others will also want fixed.  Please submit any problems
	to the fontconfig issue tracking system located at fontconfig.org

	Note that the normal 'make install' procedure for fontconfig is to
	replace any existing fonts.conf file with the new version.  Place
	any local customizations in local.conf which this file references.

	Keith Packard
-->

<!-- Font directory list -->

	<dir>/System/Library/Fonts</dir> <dir>/Library/Fonts</dir> <dir>~/Library/Fonts</dir> <dir>/System/Library/Assets/com_apple_MobileAsset_Font3</dir> <dir>/System/Library/Assets/com_apple_MobileAsset_Font4</dir>
	
	<dir prefix="xdg">fonts</dir>
	<!-- the following element will be removed in the future -->
	<dir>~/.fonts</dir>

<!--
  Accept deprecated 'mono' alias, replacing it with 'monospace'
-->
	<match target="pattern">
		<test qual="any" name="family">
			<string>mono</string>
		</test>
		<edit name="family" mode="assign" binding="same">
			<string>monospace</string>
		</edit>
	</match>

<!--
  Accept alternate 'sans serif' spelling, replacing it with 'sans-serif'
-->
	<match target="pattern">
		<test qual="any" name="family">
			<string>sans serif</string>
		</test>
		<edit name="family" mode="assign" binding="same">
			<string>sans-serif</string>
		</edit>
	</match>

<!--
  Accept deprecated 'sans' alias, replacing it with 'sans-serif'
-->
	<match target="pattern">
		<test qual="any" name="family">
			<string>sans</string>
		</test>
		<edit name="family" mode="assign" binding="same">
			<string>sans-serif</string>
		</edit>
	</match>
<!--
  Accept alternate 'system ui' spelling, replacing it with 'system-ui'
-->
	<match target="pattern">
		<test qual="any" name="family">
			<string>system ui</string>
		</test>
		<edit name="family" mode="assign" binding="same">
			<string>system-ui</string>
		</edit>
	</match>

<!--
  Load local system customization file
-->
	<include ignore_missing="yes">conf.d</include>

<!-- Font cache directory list -->

	<cachedir>/tmp/xnedit/var/cache/fontconfig</cachedir>
	<cachedir prefix="xdg">fontconfig</cachedir>
	<!-- the following element will be removed in the future -->
	<cachedir>~/.fontconfig</cachedir>

	<config>
<!--
  Rescan configuration every 30 seconds when FcFontSetList is called
 -->
		<rescan>
			<int>30</int>
		</rescan>
	</config>

</fontconfig>
__EOF__

fi

if [ ! -d "$FONTS_CONFIG_DIR/conf.d" ]; then
	mkdir -p $FONTS_CONFIG_DIR/conf.d

	cat > $FONTS_CONFIG_DIR/conf.d/10-hinting-slight.conf << __EOF__
<?xml version="1.0"?>
<!DOCTYPE fontconfig SYSTEM "urn:fontconfig:fonts.dtd">
<fontconfig>
  <description>Set hintslight to hintstyle</description>

  <match target="pattern">
    <edit name="hintstyle" mode="append"><const>hintslight</const></edit>
  </match>
</fontconfig>
__EOF__
	
	cat > $FONTS_CONFIG_DIR/conf.d/10-sub-pixel-none.conf << __EOF__
<?xml version="1.0"?>
<!DOCTYPE fontconfig SYSTEM "urn:fontconfig:fonts.dtd">
<fontconfig>
  <description>Disable sub-pixel rendering</description>
<!--  Disable sub-pixel rendering --> 
  <match target="pattern">
    <edit name="rgba" mode="append"><const>none</const></edit>
  </match>
</fontconfig>
__EOF__
	
	cat > $FONTS_CONFIG_DIR/conf.d/10-yes-antialias.conf << __EOF__
<?xml version="1.0"?>
<!DOCTYPE fontconfig SYSTEM "urn:fontconfig:fonts.dtd">
<fontconfig>
  <description>Enable antialiasing</description>
  <match target="pattern">
    <edit name="antialias" mode="append"><bool>true</bool></edit>
  </match>
</fontconfig>
__EOF__
	
	cat > $FONTS_CONFIG_DIR/conf.d/11-lcdfilter-default.conf << __EOF__
<?xml version="1.0"?>
<!DOCTYPE fontconfig SYSTEM "urn:fontconfig:fonts.dtd">
<fontconfig>
  <description>Use lcddefault as default for LCD filter</description>
<!--  Use lcddefault as default for LCD filter -->
  <match target="pattern">
    <!--
      This sort of configuration is available on the major desktop environments
      and we don't have to break it with "assign" unconditionally. however, we
      want to set something for others. So we use "append" here to get this working
      in both cases so that most clients would takes a look at the first place only.
    -->
    <edit mode="append" name="lcdfilter">
      <const>lcddefault</const>
    </edit>
  </match>
</fontconfig>
__EOF__

	cat > $FONTS_CONFIG_DIR/conf.d/30-metric-aliases.conf << __EOF__
<?xml version="1.0"?>
<!DOCTYPE fontconfig SYSTEM "urn:fontconfig:fonts.dtd">
<fontconfig>
  <description>Set substitutions for similar/metric-compatible families</description>

<!--

Alias similar/metric-compatible families from various sources:

PostScript fonts:       URW fonts:           GUST fonts:        Windows fonts:
======================  ==================  =================  ==================
Helvetica               Nimbus Sans         TeX Gyre Heros
Helvetica Narrow        Nimbus Sans Narrow  TeX Gyre Heros Cn
Times                   Nimbus Roman        TeX Gyre Termes
Courier                 Nimbus Mono PS      TeX Gyre Cursor
ITC Avant Garde Gothic  URW Gothic          TeX Gyre Adventor
ITC Bookman             URW Bookman         TeX Gyre Bonum     Bookman Old Style
ITC Zapf Chancery       Z003                TeX Gyre Chorus
Palatino                P052                TeX Gyre Pagella   Palatino Linotype
New Century Schoolbook  C059                TeX Gyre Schola    Century Schoolbook

Microsoft fonts:  Liberation fonts:       Google CrOS core fonts:  StarOffice fonts:  AMT fonts:
================  ======================  =======================  =================  ==============
Arial             Liberation Sans         Arimo                    Albany             Albany AMT
Arial Narrow      Liberation Sans Narrow
Times New Roman   Liberation Serif        Tinos                    Thorndale          Thorndale AMT
Courier New       Liberation Mono         Cousine                  Cumberland         Cumberland AMT
Cambria                                   Caladea
Calibri                                   Carlito
Symbol                                    SymbolNeu

Microsoft fonts:  Other fonts:
================  ============
Georgia           Gelasio

We want for each of them to fallback to any of these available,
but in an order preferring similar designs first.  We do this in three steps:

1) Alias each specific to its generic family.
   e.g. Liberation Sans to Arial

2) Weak alias each generic to the other generic of its family.
   e.g. Arial to Helvetica

3) Alias each generic to its specifics.
   e.g. Arial to Liberation Sans, Arimo, Albany, and Albany AMT

NOTE: The (URW)++ fonts mappings of generics to specifics were removed, because
      upstream now includes them in their release of (URW)++ Core Font Set here:
      https://github.com/ArtifexSoftware/urw-base35-fonts/tree/master/fontconfig
-->

<!-- Map specifics to generics -->

	<!-- PostScript -->
	<alias binding="same">
	  <family>Nimbus Sans L</family>
	  <default>
	  <family>Helvetica</family>
	  </default>
	</alias>

	<alias binding="same">
	  <family>Nimbus Sans</family>
	  <default>
	  <family>Helvetica</family>
	  </default>
	</alias>

	<alias binding="same">
	  <family>TeX Gyre Heros</family>
	  <default>
	  <family>Helvetica</family>
	  </default>
	</alias>

	<alias binding="same">
	  <family>Nimbus Sans Narrow</family>
	  <default>
	  <family>Helvetica Narrow</family>
	  </default>
	</alias>

	<alias binding="same">
	  <family>TeX Gyre Heros Cn</family>
	  <default>
	  <family>Helvetica Narrow</family>
	  </default>
	</alias>

	<alias binding="same">
	  <family>Nimbus Roman No9 L</family>
	  <default>
	  <family>Times</family>
	  </default>
	</alias>

	<alias binding="same">
	  <family>Nimbus Roman</family>
	  <default>
	  <family>Times</family>
	  </default>
	</alias>

	<alias binding="same">
	  <family>TeX Gyre Termes</family>
	  <default>
	  <family>Times</family>
	  </default>
	</alias>

	<alias binding="same">
	  <family>Nimbus Mono L</family>
	  <default>
	  <family>Courier</family>
	  </default>
	</alias>

	<alias binding="same">
	  <family>Nimbus Mono</family>
	  <default>
	  <family>Courier</family>
	  </default>
	</alias>

	<alias binding="same">
	  <family>Nimbus Mono PS</family>
	  <default>
	  <family>Courier</family>
	  </default>
	</alias>

	<alias binding="same">
	  <family>TeX Gyre Cursor</family>
	  <default>
	  <family>Courier</family>
	  </default>
	</alias>

	<alias binding="same">
	  <family>Avant Garde</family>
	  <default>
	  <family>ITC Avant Garde Gothic</family>
	  </default>
	</alias>

	<alias binding="same">
	  <family>URW Gothic L</family>
	  <default>
	  <family>ITC Avant Garde Gothic</family>
	  </default>
	</alias>

	<alias binding="same">
	  <family>URW Gothic</family>
	  <default>
	  <family>ITC Avant Garde Gothic</family>
	  </default>
	</alias>

	<alias binding="same">
	  <family>TeX Gyre Adventor</family>
	  <default>
	  <family>ITC Avant Garde Gothic</family>
	  </default>
	</alias>

	<alias binding="same">
	  <family>Bookman</family>
	  <default>
	  <family>ITC Bookman</family>
	  </default>
	</alias>

	<alias binding="same">
	  <family>URW Bookman L</family>
	  <default>
	  <family>ITC Bookman</family>
	  </default>
	</alias>

	<alias binding="same">
	  <family>Bookman URW</family>
	  <default>
	  <family>ITC Bookman</family>
	  </default>
	</alias>

	<alias binding="same">
	  <family>URW Bookman</family>
	  <default>
	  <family>ITC Bookman</family>
	  </default>
	</alias>

	<alias binding="same">
	  <family>TeX Gyre Bonum</family>
	  <default>
	  <family>ITC Bookman</family>
	  </default>
	</alias>

	<alias binding="same">
	  <family>Bookman Old Style</family>
	  <default>
	  <family>ITC Bookman</family>
	  </default>
	</alias>

	<alias binding="same">
	  <family>Zapf Chancery</family>
	  <default>
	  <family>ITC Zapf Chancery</family>
	  </default>
	</alias>

	<alias binding="same">
	  <family>URW Chancery L</family>
	  <default>
	  <family>ITC Zapf Chancery</family>
	  </default>
	</alias>

	<alias binding="same">
	  <family>Chancery URW</family>
	  <default>
	  <family>ITC Zapf Chancery</family>
	  </default>
	</alias>

	<alias binding="same">
	  <family>Z003</family>
	  <default>
	  <family>ITC Zapf Chancery</family>
	  </default>
	</alias>

	<alias binding="same">
	  <family>TeX Gyre Chorus</family>
	  <default>
	  <family>ITC Zapf Chancery</family>
	  </default>
	</alias>

	<alias binding="same">
	  <family>URW Palladio L</family>
	  <default>
	  <family>Palatino</family>
	  </default>
	</alias>

	<alias binding="same">
	  <family>Palladio URW</family>
	  <default>
	  <family>Palatino</family>
	  </default>
	</alias>

	<alias binding="same">
	  <family>P052</family>
	  <default>
	  <family>Palatino</family>
	  </default>
	</alias>

	<alias binding="same">
	  <family>TeX Gyre Pagella</family>
	  <default>
	  <family>Palatino</family>
	  </default>
	</alias>

	<alias binding="same">
	  <family>Palatino Linotype</family>
	  <default>
	  <family>Palatino</family>
	  </default>
	</alias>

	<alias binding="same">
	  <family>Century Schoolbook L</family>
	  <default>
	  <family>New Century Schoolbook</family>
	  </default>
	</alias>

	<alias binding="same">
	  <family>Century SchoolBook URW</family>
	  <default>
	  <family>New Century Schoolbook</family>
	  </default>
	</alias>

	<alias binding="same">
	  <family>C059</family>
	  <default>
	  <family>New Century Schoolbook</family>
	  </default>
	</alias>

	<alias binding="same">
	  <family>TeX Gyre Schola</family>
	  <default>
	  <family>New Century Schoolbook</family>
	  </default>
	</alias>

	<alias binding="same">
	  <family>Century Schoolbook</family>
	  <default>
	  <family>New Century Schoolbook</family>
	  </default>
	</alias>

	<!-- Microsoft -->
	<alias binding="same">
	  <family>Arimo</family>
	  <default>
	    <family>Arial</family>
	  </default>
	</alias>

	<alias binding="same">
	  <family>Liberation Sans</family>
	  <default>
	  <family>Arial</family>
	  </default>
	</alias>

	<alias binding="same">
	  <family>Liberation Sans Narrow</family>
	  <default>
	    <family>Arial Narrow</family>
	  </default>
	</alias>

	<alias binding="same">
	  <family>Albany</family>
	  <default>
	  <family>Arial</family>
	  </default>
	</alias>

	<alias binding="same">
	  <family>Albany AMT</family>
	  <default>
	  <family>Arial</family>
	  </default>
	</alias>

	<alias binding="same">
	  <family>Tinos</family>
	  <default>
	    <family>Times New Roman</family>
	  </default>
	</alias>

	<alias binding="same">
	  <family>Liberation Serif</family>
	  <default>
	  <family>Times New Roman</family>
	  </default>
	</alias>

	<alias binding="same">
	  <family>Thorndale</family>
	  <default>
	  <family>Times New Roman</family>
	  </default>
	</alias>

	<alias binding="same">
	  <family>Thorndale AMT</family>
	  <default>
	  <family>Times New Roman</family>
	  </default>
	</alias>

	<alias binding="same">
	  <family>Cousine</family>
	  <default>
	    <family>Courier New</family>
	  </default>
	</alias>

	<alias binding="same">
	  <family>Liberation Mono</family>
	  <default>
	  <family>Courier New</family>
	  </default>
	</alias>

	<alias binding="same">
	  <family>Cumberland</family>
	  <default>
	  <family>Courier New</family>
	  </default>
	</alias>

	<alias binding="same">
	  <family>Cumberland AMT</family>
	  <default>
	  <family>Courier New</family>
	  </default>
	</alias>

	<alias binding="same">
	  <family>Gelasio</family>
	  <default>
	  <family>Georgia</family>
	  </default>
	</alias>

	<alias binding="same">
	  <family>Caladea</family>
	  <default>
	  <family>Cambria</family>
	  </default>
	</alias>

	<alias binding="same">
	  <family>Carlito</family>
	  <default>
	  <family>Calibri</family>
	  </default>
	</alias>

	<alias binding="same">
	  <family>SymbolNeu</family>
	  <default>
	  <family>Symbol</family>
	  </default>
  </alias>

<!-- Accept the other group as fallback -->

	<!-- PostScript -->
	<alias>
	  <family>Helvetica</family>
	  <default>
	  <family>Arial</family>
	  </default>
	</alias>

	<alias>
	  <family>Helvetica Narrow</family>
	  <default>
	  <family>Arial Narrow</family>
	  </default>
	</alias>

	<alias>
	  <family>Times</family>
	  <default>
	  <family>Times New Roman</family>
	  </default>
	</alias>

	<alias>
	  <family>Courier</family>
	  <default>
	  <family>Courier New</family>
	  </default>
	</alias>

	<!-- Microsoft -->
	<alias>
	  <family>Arial</family>
	  <default>
	  <family>Helvetica</family>
	  </default>
	</alias>

	<alias>
	  <family>Arial Narrow</family>
	  <default>
	  <family>Helvetica Narrow</family>
	  </default>
	</alias>

	<alias>
	  <family>Times New Roman</family>
	  <default>
	  <family>Times</family>
	  </default>
	</alias>

	<alias>
	  <family>Courier New</family>
	  <default>
	  <family>Courier</family>
	  </default>
	</alias>

<!-- Map generics to specifics -->

	<!-- PostScript -->
	<alias binding="same">
	  <family>Helvetica</family>
	  <accept>
	  <family>TeX Gyre Heros</family>
	  </accept>
	</alias>

	<alias binding="same">
	  <family>Helvetica Narrow</family>
	  <accept>
	  <family>TeX Gyre Heros Cn</family>
	  </accept>
	</alias>

	<alias binding="same">
	  <family>Times</family>
	  <accept>
	  <family>TeX Gyre Termes</family>
	  </accept>
	</alias>

	<alias binding="same">
	  <family>Courier</family>
	  <accept>
	  <family>TeX Gyre Cursor</family>
	  </accept>
	</alias>

	<alias binding="same">
	  <family>Courier Std</family>
	  <accept>
	  <family>Courier</family>
	  </accept>
	</alias>

	<alias binding="same">
	  <family>ITC Avant Garde Gothic</family>
	  <accept>
	  <family>TeX Gyre Adventor</family>
	  </accept>
	</alias>

	<alias binding="same">
	  <family>ITC Bookman</family>
	  <accept>
	  <family>Bookman Old Style</family>
	  <family>TeX Gyre Bonum</family>
	  </accept>
	</alias>

	<alias binding="same">
	  <family>ITC Zapf Chancery</family>
	  <accept>
	  <family>TeX Gyre Chorus</family>
	  </accept>
	</alias>

	<alias binding="same">
	  <family>Palatino</family>
	  <accept>
	  <family>Palatino Linotype</family>
	  <family>TeX Gyre Pagella</family>
	  </accept>
	</alias>

	<alias binding="same">
	  <family>New Century Schoolbook</family>
	  <accept>
	  <family>Century Schoolbook</family>
	  <family>TeX Gyre Schola</family>
	  </accept>
	</alias>

	<!-- Microsoft -->
	<alias binding="same">
	  <family>Arial</family>
	  <accept>
	    <family>Arimo</family>
	    <family>Liberation Sans</family>
	    <family>Albany</family>
	    <family>Albany AMT</family>
	  </accept>
	</alias>

	<alias binding="same">
	  <family>Arial Narrow</family>
	  <accept>
	    <family>Liberation Sans Narrow</family>
	  </accept>
	</alias>

	<alias binding="same">
	  <family>Times New Roman</family>
	  <accept>
	    <family>Tinos</family>
	    <family>Liberation Serif</family>
	    <family>Thorndale</family>
	    <family>Thorndale AMT</family>
	  </accept>
	</alias>

	<alias binding="same">
	  <family>Courier New</family>
	  <accept>
	    <family>Cousine</family>
	    <family>Liberation Mono</family>
	    <family>Cumberland</family>
	    <family>Cumberland AMT</family>
	  </accept>
	</alias>

	<alias binding="same">
	  <family>Georgia</family>
	  <accept>
	    <family>Gelasio</family>
	  </accept>
	</alias>

	<alias binding="same">
	  <family>Cambria</family>
	  <accept>
	    <family>Caladea</family>
	  </accept>
	</alias>

	<alias binding="same">
	  <family>Calibri</family>
	  <accept>
	    <family>Carlito</family>
	  </accept>
  </alias>

	<alias binding="same">
	  <family>Symbol</family>
	  <accept>
	    <family>SymbolNeu</family>
	  </accept>
  </alias>

</fontconfig>
__EOF__
	
	cat > $FONTS_CONFIG_DIR/conf.d/40-nonlatin.conf << __EOF__
<?xml version="1.0"?>
<!DOCTYPE fontconfig SYSTEM "urn:fontconfig:fonts.dtd">
<fontconfig>
  <description>Set substitutions for non-Latin fonts</description>
<!--
  Mark common families with their generics so we'll get
  something reasonable
-->

<!--
  Serif faces
 -->
	<alias>
		<family>Nazli</family>
		<default><family>serif</family></default>
	</alias>
	<alias>
		<family>Lotoos</family>
		<default><family>serif</family></default>
	</alias>
	<alias>
		<family>Mitra</family>
		<default><family>serif</family></default>
	</alias>
	<alias>
		<family>Ferdosi</family>
		<default><family>serif</family></default>
	</alias>
	<alias>
		<family>Badr</family>
		<default><family>serif</family></default>
	</alias>
	<alias>
		<family>Zar</family>
		<default><family>serif</family></default>
	</alias>
	<alias>
		<family>Titr</family>
		<default><family>serif</family></default>
	</alias>
	<alias>
		<family>Jadid</family>
		<default><family>serif</family></default>
	</alias>
	<alias>
		<family>Kochi Mincho</family>
		<default><family>serif</family></default>
	</alias>
	<alias>
		<family>AR PL SungtiL GB</family>
		<default><family>serif</family></default>
	</alias>
	<alias>
		<family>AR PL Mingti2L Big5</family>
		<default><family>serif</family></default>
	</alias>
	<alias>
		<family>ＭＳ 明朝</family>
		<default><family>serif</family></default>
	</alias>
	<alias>
		<family>NanumMyeongjo</family>
		<default><family>serif</family></default>
	</alias>
	<alias>
		<family>UnBatang</family>
		<default><family>serif</family></default>
	</alias>
	<alias>
		<family>Baekmuk Batang</family>
		<default><family>serif</family></default>
	</alias>
	<alias>
		<family>MgOpen Canonica</family>
		<default><family>serif</family></default>
	</alias>
	<alias>
		<family>Sazanami Mincho</family>
		<default><family>serif</family></default>
	</alias>
	<alias>
		<family>AR PL ZenKai Uni</family>
		<default><family>serif</family></default>
	</alias>
	<alias>
		<family>ZYSong18030</family>
		<default><family>serif</family></default>
	</alias>
	<alias>
		<family>FreeSerif</family>
		<default><family>serif</family></default>
	</alias>
	<alias>
		<family>SimSun</family>
		<default><family>serif</family></default>
	</alias>
<!--
  Sans-serif faces
 -->
	<alias>
		<family>Arshia</family>
		<default><family>sans-serif</family></default>
	</alias>
	<alias>
		<family>Elham</family>
		<default><family>sans-serif</family></default>
	</alias>
	<alias>
		<family>Farnaz</family>
		<default><family>sans-serif</family></default>
	</alias>
	<alias>
		<family>Nasim</family>
		<default><family>sans-serif</family></default>
	</alias>
	<alias>
		<family>Sina</family>
		<default><family>sans-serif</family></default>
	</alias>
	<alias>
		<family>Roya</family>
		<default><family>sans-serif</family></default>
	</alias>
	<alias>
		<family>Koodak</family>
		<default><family>sans-serif</family></default>
	</alias>
	<alias>
		<family>Terafik</family>
		<default><family>sans-serif</family></default>
	</alias>
	<alias>
		<family>Kochi Gothic</family>
		<default><family>sans-serif</family></default>
	</alias>
	<alias>
		<family>AR PL KaitiM GB</family>
		<default><family>sans-serif</family></default>
	</alias>
	<alias>
		<family>AR PL KaitiM Big5</family>
		<default><family>sans-serif</family></default>
	</alias>
	<alias>
		<family>ＭＳ ゴシック</family>
		<default><family>sans-serif</family></default>
	</alias>
	<alias>
		<family>NanumGothic</family>
		<default><family>sans-serif</family></default>
	</alias>
	<alias>
		<family>UnDotum</family>
		<default><family>sans-serif</family></default>
	</alias>
	<alias>
		<family>Baekmuk Dotum</family>
		<default><family>sans-serif</family></default>
	</alias>
	<alias>
		<family>MgOpen Modata</family>
		<default><family>sans-serif</family></default>
	</alias>
	<alias>
		<family>Sazanami Gothic</family>
		<default><family>sans-serif</family></default>
	</alias>
	<alias>
		<family>AR PL ShanHeiSun Uni</family>
		<default><family>sans-serif</family></default>
	</alias>
	<alias>
		<family>ZYSong18030</family>
		<default><family>sans-serif</family></default>
	</alias>
	<alias>
		<family>FreeSans</family>
		<default><family>sans-serif</family></default>
	</alias>
<!--
  Monospace faces
 -->
	<alias>
		<family>NSimSun</family>
		<default><family>monospace</family></default>
	</alias>
	<alias>
		<family>ZYSong18030</family>
		<default><family>monospace</family></default>
	</alias>
	<alias>
		<family>NanumGothicCoding</family>
		<default><family>monospace</family></default>
	</alias>
	<alias>
		<family>FreeMono</family>
		<default><family>monospace</family></default>
	</alias>

<!--
  Fantasy faces
 -->
	<alias>
		<family>Homa</family>
		<default><family>fantasy</family></default>
	</alias>
	<alias>
		<family>Kamran</family>
		<default><family>fantasy</family></default>
	</alias>
	<alias>
		<family>Fantezi</family>
		<default><family>fantasy</family></default>
	</alias>
	<alias>
		<family>Tabassom</family>
		<default><family>fantasy</family></default>
	</alias>

<!--
  Cursive faces
 -->
	<alias>
		<family>IranNastaliq</family>
		<default><family>cursive</family></default>
	</alias>
	<alias>
		<family>Nafees Nastaleeq</family>
		<default><family>cursive</family></default>
	</alias>

<!--
  system-ui
-->
	<alias>
		<family>Noto Sans Arabic UI</family>
		<default><family>system-ui</family></default>
	</alias>
	<alias>
		<family>Noto Sans Bengali UI</family>
		<default><family>system-ui</family></default>
	</alias>
	<alias>
		<family>Noto Sans Devanagari UI</family>
		<default><family>system-ui</family></default>
	</alias>
	<alias>
		<family>Noto Sans Gujarati UI</family>
		<default><family>system-ui</family></default>
	</alias>
	<alias>
		<family>Noto Sans Gurmukhi UI</family>
		<default><family>system-ui</family></default>
	</alias>
	<alias>
		<family>Noto Sans Kannada UI</family>
		<default><family>system-ui</family></default>
	</alias>
	<alias>
		<family>Noto Sans Khmer UI</family>
		<default><family>system-ui</family></default>
	</alias>
	<alias>
		<family>Noto Sans Lao UI</family>
		<default><family>system-ui</family></default>
	</alias>
	<alias>
		<family>Noto Sans Malayalam UI</family>
		<default><family>system-ui</family></default>
	</alias>
	<alias>
		<family>Noto Sans Myanmar UI</family>
		<default><family>system-ui</family></default>
	</alias>
	<alias>
		<family>Noto Sans Oriya UI</family>
		<default><family>system-ui</family></default>
	</alias>
	<alias>
		<family>Noto Sans Sinhala UI</family>
		<default><family>system-ui</family></default>
	</alias>
	<alias>
		<family>Noto Sans Tamil UI</family>
		<default><family>system-ui</family></default>
	</alias>
	<alias>
		<family>Noto Sans Telugu UI</family>
		<default><family>system-ui</family></default>
	</alias>
	<alias>
		<family>Noto Sans Thai UI</family>
		<default><family>system-ui</family></default>
	</alias>
	<alias>
		<family>Leelawadee UI</family>
		<default><family>system-ui</family></default>
	</alias>
	<alias>
		<family>Nirmala UI</family>
		<default><family>system-ui</family></default>
	</alias>
	<alias>
		<family>Yu Gothic UI</family>
		<default><family>system-ui</family></default>
	</alias>
	<alias>
		<family>Meiryo UI</family>
		<default><family>system-ui</family></default>
	</alias>
	<alias>
		<family>MS UI Gothic</family>
		<default><family>system-ui</family></default>
	</alias>
	<alias>
		<family>Khmer UI</family>
		<default><family>system-ui</family></default>
	</alias>
	<alias>
		<family>Lao UI</family>
		<default><family>system-ui</family></default>
	</alias>
	<alias>
		<family>Microsoft JhengHei UI</family>
		<default><family>system-ui</family></default>
	</alias>
	<alias>
		<family>Microsoft YaHei UI</family>
		<default><family>system-ui</family></default>
	</alias>

</fontconfig>
__EOF__

	cat > $FONTS_CONFIG_DIR/conf.d/45-generic.conf << __EOF__
<?xml version="1.0"?>
<!DOCTYPE fontconfig SYSTEM "urn:fontconfig:fonts.dtd">
<fontconfig>
  <description>Set substitutions for emoji/math fonts</description>

<!-- Keep in sync with 60-generic.conf -->

<!-- Emoji -->

	<!-- System emoji -->
	<alias binding="same">
		<family>Noto Color Emoji</family> <!-- Google -->
		<default><family>emoji</family></default>
	</alias>
	<alias binding="same">
		<family>Apple Color Emoji</family> <!-- Apple -->
		<default><family>emoji</family></default>
	</alias>
	<alias binding="same">
		<family>Segoe UI Emoji</family> <!-- Microsoft -->
		<default><family>emoji</family></default>
	</alias>
	<alias binding="same">
		<family>Twitter Color Emoji</family> <!-- Twitter -->
		<default><family>emoji</family></default>
	</alias>
	<alias binding="same">
		<family>EmojiOne Mozilla</family> <!-- Mozilla -->
		<default><family>emoji</family></default>
	</alias>
	<!-- Third-party emoji -->
	<alias binding="same">
		<family>Emoji Two</family>
		<default><family>emoji</family></default>
	</alias>
	<alias binding="same">
		<family>JoyPixels</family>
		<default><family>emoji</family></default>
	</alias>
	<alias binding="same">
		<family>Emoji One</family>
		<default><family>emoji</family></default>
	</alias>
	<!-- B&W -->
	<alias binding="same">
		<family>Noto Emoji</family> <!-- Google -->
		<default><family>emoji</family></default>
	</alias>
	<alias binding="same">
		<family>Android Emoji</family> <!-- Google -->
		<default><family>emoji</family></default>
	</alias>

	<!-- Add language for emoji, to match other emoji fonts. -->
	<match>
		<test name="family">
			<string>emoji</string>
		</test>
		<edit name="lang" mode="prepend">
			<string>und-zsye</string>
		</edit>
	</match>

	<match>
		<test name="lang">
			<string>und-zsye</string>
		</test>
		<test qual="all" name="family" compare="not_eq">
			<string>emoji</string>
		</test>

		<!-- Add generic family. -->
		<edit name="family" mode="append" binding="strong">
			<string>emoji</string>
		</edit>
	</match>


<!-- Math -->

	<!-- https://en.wikipedia.org/wiki/Category:Mathematical_OpenType_typefaces -->
	<alias binding="same">
		<family>XITS Math</family> <!-- Khaled Hosny -->
		<default><family>math</family></default>
	</alias>
	<alias binding="same">
		<family>STIX Two Math</family> <!-- AMS -->
		<default><family>math</family></default>
	</alias>
	<alias binding="same">
		<family>Cambria Math</family> <!-- Microsoft -->
		<default><family>math</family></default>
	</alias>
	<alias binding="same">
		<family>Latin Modern Math</family> <!-- TeX -->
		<default><family>math</family></default>
	</alias>
	<alias binding="same">
		<family>Minion Math</family> <!-- Adobe -->
		<default><family>math</family></default>
	</alias>
	<alias binding="same">
		<family>Lucida Math</family> <!-- Adobe -->
		<default><family>math</family></default>
	</alias>
	<alias binding="same">
		<family>Asana Math</family>
		<default><family>math</family></default>
	</alias>

	<!-- Add language for math, to match other math fonts. -->
	<match>
		<test name="family">
			<string>math</string>
		</test>
		<edit name="lang" mode="prepend">
			<string>und-zmth</string>
		</edit>
	</match>

	<match>
		<test name="lang">
			<string>und-zmth</string>
		</test>
		<test qual="all" name="family" compare="not_eq">
			<string>math</string>
		</test>

		<!-- Add generic family -->
		<edit name="family" mode="append" binding="strong">
			<string>math</string>
		</edit>
	</match>


</fontconfig>
__EOF__
	
	cat > $FONTS_CONFIG_DIR/conf.d/45-latin.conf << __EOF__
<?xml version="1.0"?>
<!DOCTYPE fontconfig SYSTEM "urn:fontconfig:fonts.dtd">
<fontconfig>
  <description>Set substitutions for Latin fonts</description>
<!--
  Mark common families with their generics so we'll get
  something reasonable
-->

<!--
  Serif faces
 -->
	<alias>
		<family>Bitstream Vera Serif</family>
		<default><family>serif</family></default>
	</alias>
	<alias>
		<family>Cambria</family>
		<default><family>serif</family></default>
	</alias>
	<alias>
		<family>Constantia</family>
		<default><family>serif</family></default>
	</alias>
	<alias>
		<family>DejaVu Serif</family>
		<default><family>serif</family></default>
	</alias>
	<alias>
		<family>Elephant</family>
		<default><family>serif</family></default>
	</alias>
	<alias>
		<family>Garamond</family>
		<default><family>serif</family></default>
	</alias>
	<alias>
		<family>Georgia</family>
		<default><family>serif</family></default>
	</alias>
	<alias>
		<family>Liberation Serif</family>
		<default><family>serif</family></default>
	</alias>
	<alias>
		<family>Luxi Serif</family>
		<default><family>serif</family></default>
	</alias>
	<alias>
		<family>MS Serif</family>
		<default><family>serif</family></default>
	</alias>
	<alias>
		<family>Nimbus Roman No9 L</family>
		<default><family>serif</family></default>
	</alias>
	<alias>
		<family>Nimbus Roman</family>
		<default><family>serif</family></default>
	</alias>
	<alias>
		<family>Palatino Linotype</family>
		<default><family>serif</family></default>
	</alias>
	<alias>
		<family>Thorndale AMT</family>
		<default><family>serif</family></default>
	</alias>
	<alias>
		<family>Thorndale</family>
		<default><family>serif</family></default>
	</alias>
	<alias>
		<family>Times New Roman</family>
		<default><family>serif</family></default>
	</alias>
	<alias>
		<family>Times</family>
		<default><family>serif</family></default>
	</alias>
<!--
  Sans-serif faces
 -->
	<alias>
		<family>Albany AMT</family>
		<default><family>sans-serif</family></default>
	</alias>
	<alias>
		<family>Albany</family>
		<default><family>sans-serif</family></default>
	</alias>
	<alias>
		<family>Arial Unicode MS</family>
		<default><family>sans-serif</family></default>
	</alias>
	<alias>
		<family>Arial</family>
		<default><family>sans-serif</family></default>
	</alias>
	<alias>
		<family>Bitstream Vera Sans</family>
		<default><family>sans-serif</family></default>
	</alias>
	<alias>
		<family>Britannic</family>
		<default><family>sans-serif</family></default>
	</alias>
	<alias>
		<family>Calibri</family>
		<default><family>sans-serif</family></default>
	</alias>
	<alias>
		<family>Candara</family>
		<default><family>sans-serif</family></default>
	</alias>
	<alias>
		<family>Century Gothic</family>
		<default><family>sans-serif</family></default>
	</alias>
	<alias>
		<family>Corbel</family>
		<default><family>sans-serif</family></default>
	</alias>
	<alias>
		<family>DejaVu Sans</family>
		<default><family>sans-serif</family></default>
	</alias>
	<alias>
		<family>Helvetica</family>
		<default><family>sans-serif</family></default>
	</alias>
	<alias>
		<family>Haettenschweiler</family>
		<default><family>sans-serif</family></default>
	</alias>
	<alias>
		<family>Liberation Sans</family>
		<default><family>sans-serif</family></default>
	</alias>
	<alias>
		<family>MS Sans Serif</family>
		<default><family>sans-serif</family></default>
	</alias>
	<alias>
		<family>Nimbus Sans L</family>
		<default><family>sans-serif</family></default>
	</alias>
	<alias>
		<family>Nimbus Sans</family>
		<default><family>sans-serif</family></default>
	</alias>
	<alias>
		<family>Luxi Sans</family>
		<default><family>sans-serif</family></default>
	</alias>
	<alias>
		<family>Tahoma</family>
		<default><family>sans-serif</family></default>
	</alias>
	<alias>
		<family>Trebuchet MS</family>
		<default><family>sans-serif</family></default>
	</alias>
	<alias>
		<family>Twentieth Century</family>
		<default><family>sans-serif</family></default>
	</alias>
	<alias>
		<family>Verdana</family>
		<default><family>sans-serif</family></default>
	</alias>
<!--
  Monospace faces
 -->
	<alias>
		<family>Andale Mono</family>
		<default><family>monospace</family></default>
	</alias>
 	<alias>
		<family>Bitstream Vera Sans Mono</family>
		<default><family>monospace</family></default>
	</alias>
	<alias>
		<family>Consolas</family>
		<default><family>monospace</family></default>
	</alias>
	<alias>
		<family>Courier New</family>
		<default><family>monospace</family></default>
	</alias>
	<alias>
		<family>Courier</family>
		<default><family>monospace</family></default>
	</alias>
	<alias>
		<family>Courier Std</family>
		<default><family>monospace</family></default>
	</alias>
	<alias>
		<family>Cumberland AMT</family>
		<default><family>monospace</family></default>
	</alias>
	<alias>
		<family>Cumberland</family>
		<default><family>monospace</family></default>
	</alias>
	<alias>
		<family>DejaVu Sans Mono</family>
		<default><family>monospace</family></default>
	</alias>
	<alias>
		<family>Fixedsys</family>
		<default><family>monospace</family></default>
	</alias>
	<alias>
		<family>Inconsolata</family>
		<default><family>monospace</family></default>
	</alias>
	<alias>
		<family>Liberation Mono</family>
		<default><family>monospace</family></default>
	</alias>
	<alias>
		<family>Luxi Mono</family>
		<default><family>monospace</family></default>
	</alias>
	<alias>
		<family>Nimbus Mono L</family>
		<default><family>monospace</family></default>
	</alias>
	<alias>
		<family>Nimbus Mono</family>
		<default><family>monospace</family></default>
	</alias>
	<alias>
		<family>Nimbus Mono PS</family>
		<default><family>monospace</family></default>
	</alias>
	<alias>
		<family>Terminal</family>
		<default><family>monospace</family></default>
	</alias>
<!--
  Fantasy faces
 -->
	<alias>
		<family>Bauhaus Std</family>
		<default><family>fantasy</family></default>
	</alias>
	<alias>
		<family>Cooper Std</family>
		<default><family>fantasy</family></default>
	</alias>
	<alias>
		<family>Copperplate Gothic Std</family>
		<default><family>fantasy</family></default>
	</alias>
	<alias>
		<family>Impact</family>
		<default><family>fantasy</family></default>
	</alias>
<!--
  Cursive faces
  -->
	<alias>
		<family>Comic Sans MS</family>
		<default><family>cursive</family></default>
	</alias>
	<alias>
		<family>ITC Zapf Chancery Std</family>
		<default><family>cursive</family></default>
	</alias>
	<alias>
		<family>Zapfino</family>
		<default><family>cursive</family></default>
	</alias>
<!--
  system-ui
-->
	<alias>
		<family>Cantarell</family>
		<default><family>system-ui</family></default>
	</alias>
	<alias>
		<family>Noto Sans UI</family>
		<default><family>system-ui</family></default>
	</alias>
	<alias>
		<family>Segoe UI</family>
		<default><family>system-ui</family></default>
	</alias>
	<alias>
		<family>Segoe UI Historic</family>
		<default><family>system-ui</family></default>
	</alias>
	<alias>
		<family>Segoe UI Symbol</family>
		<default><family>system-ui</family></default>
	</alias>

</fontconfig>
__EOF__
	
	cat > $FONTS_CONFIG_DIR/conf.d/60-latin.conf << __EOF__
<?xml version="1.0"?>
<!DOCTYPE fontconfig SYSTEM "urn:fontconfig:fonts.dtd">
<fontconfig>
  <description>Set preferable fonts for Latin</description>
	<alias>
		<family>serif</family>
		<prefer>
			<family>Noto Serif</family>
			<family>DejaVu Serif</family>
			<family>Times New Roman</family>
			<family>Thorndale AMT</family>
			<family>Luxi Serif</family>
			<family>Nimbus Roman No9 L</family>
			<family>Nimbus Roman</family>
			<family>Times</family>
		</prefer>
	</alias>
	<alias>
		<family>sans-serif</family>
		<prefer>
			<family>Noto Sans</family>
			<family>DejaVu Sans</family>
			<family>Verdana</family>
			<family>Arial</family>
			<family>Albany AMT</family>
			<family>Luxi Sans</family>
			<family>Nimbus Sans L</family>
			<family>Nimbus Sans</family>
			<family>Helvetica</family>
			<family>Lucida Sans Unicode</family>
			<family>BPG Glaho International</family> <!-- lat,cyr,arab,geor -->
			<family>Tahoma</family> <!-- lat,cyr,greek,heb,arab,thai -->
		</prefer>
	</alias>
	<alias>
		<family>monospace</family>
		<prefer>
			<family>Noto Sans Mono</family>
			<family>DejaVu Sans Mono</family>
			<family>Inconsolata</family>
			<family>Andale Mono</family>
			<family>Courier New</family>
			<family>Cumberland AMT</family>
			<family>Luxi Mono</family>
			<family>Nimbus Mono L</family>
			<family>Nimbus Mono</family>
			<family>Nimbus Mono PS</family>
			<family>Courier</family>
		</prefer>
	</alias>
<!--
  Fantasy faces
 -->
 	<alias>
		<family>fantasy</family>
		<prefer>
			<family>Impact</family>
			<family>Copperplate Gothic Std</family>
			<family>Cooper Std</family>
			<family>Bauhaus Std</family>
		</prefer>
	</alias>
<!--
  Cursive faces
  -->
	<alias>
		<family>cursive</family>
		<prefer>
			<family>ITC Zapf Chancery Std</family>
			<family>Zapfino</family>
			<family>Comic Sans MS</family>
		</prefer>
	</alias>
<!--
  system-ui
-->
	<alias>
		<family>system-ui</family>
		<prefer>
			<family>Cantarell</family>
			<family>Noto Sans UI</family>
			<family>Segoe UI</family>
			<family>Segoe UI Historic</family>
			<family>Segoe UI Symbol</family>
		</prefer>
	</alias>

</fontconfig>
__EOF__

	cat > $FONTS_CONFIG_DIR/conf.d/69-unifont.conf << __EOF__
<?xml version="1.0"?>
<!DOCTYPE fontconfig SYSTEM "urn:fontconfig:fonts.dtd">
<fontconfig>
	<alias>
		<family>serif</family>
		<prefer>
			<family>FreeSerif</family>
			<family>Code2000</family>
			<family>Code2001</family> <!-- plane1 and beyond -->
		</prefer>
	</alias>
	<alias>
		<family>sans-serif</family>
		<prefer>
			<family>FreeSans</family>
			<family>Arial Unicode MS</family>
			<family>Arial Unicode</family>
			<family>Code2000</family> <!-- almost everything; serif actually -->
			<family>Code2001</family> <!-- plane1 and beyond -->
		</prefer>
	</alias>
	<alias>
		<family>monospace</family>
		<prefer>
			<family>FreeMono</family>
		</prefer>
	</alias>
</fontconfig>
__EOF__
fi

# start xnedit
$XNEDIT_BIN "$@"
