/*
 * Copyright 1991-1998, Brown University, Providence, RI.
 * 
 *                         All Rights Reserved
 * 
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose other than its incorporation into a
 * commercial product is hereby granted without fee, provided that the
 * above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of Brown University not be used in
 * advertising or publicity pertaining to distribution of the software
 * without specific, written prior permission.
 * 
 * BROWN UNIVERSITY DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR ANY
 * PARTICULAR PURPOSE.  IN NO EVENT SHALL BROWN UNIVERSITY BE LIABLE FOR
 * ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
 * OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */
/************************************************************************
*									*
*   rs.c								*
*									*
*	Reply stamp routines.  For marking chunks containing replies	*
*	with the major and minor reply codes.				*
*									*
************************************************************************/
#include "xmx.h"
#include "rs.h"
#include "incl/rs.pvt.h"

static rs_t *rsfree;

void
rs_mark
   AL((chp, major, minor))
   DB chunk_t *chp
   DD u8_t major		/* if zero, it's a connection setup reply */
   DD u16_t minor
   DE
{
   register rs_t *rsp;

#ifdef DEBUG
   if (chp->type != P_NONE) {
      warn("rs_mark: chunk has type %s!\n", debug_proto_type_str(chp->type));
      return;
   }
#endif
   rsp = new_rs();

   rsp->major = major;
   rsp->minor = minor;

   chp->type = P_REPLY;
   chp->dptr = (void *)rsp;
}

void
rs_unmark
   AL((chp))
   DB chunk_t *chp
   DE
{
   register rs_t *rsp;

   if (chp->type == P_REPLY) {
      chp->type = P_NONE;
      rsp = (rs_t *)chp->dptr;
      rsp->next = rsfree;
      rsfree = rsp;
   }
}

static rs_t *
new_rs
   VOID
{
   register rs_t *rsp;

   if (rsfree) {
      rsp = rsfree;
      rsfree = rsfree->next;
   }
   else if (MALLOC(rsp, rs_t *, sizeof(rs_t)))
      return 0;

   return rsp;
}
