/*
 * Copyright 1991-1998, Brown University, Providence, RI.
 * 
 *                         All Rights Reserved
 * 
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose other than its incorporation into a
 * commercial product is hereby granted without fee, provided that the
 * above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of Brown University not be used in
 * advertising or publicity pertaining to distribution of the software
 * without specific, written prior permission.
 * 
 * BROWN UNIVERSITY DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR ANY
 * PARTICULAR PURPOSE.  IN NO EVENT SHALL BROWN UNIVERSITY BE LIABLE FOR
 * ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
 * OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */
/************************************************************************
*									*
*   df.h								*
*									*
************************************************************************/

#define DF_NVALS	256
/*
**  The two broad classes of data we need to handle are integers
**  and pointers.  Since pointers can't portably be cast to integers,
**  the basic datatype is the following union.
*/
typedef union {
   u32_t	i;
   void *	p;
}univ_t;

typedef struct _df_block_t {
   int			refs;
   int			index;
   univ_t		val[DF_NVALS];
   struct _df_block_t *	next;
}df_block_t;

typedef struct _df_t {
   int			index;
   int			curdex;
   int			count;
   df_block_t *		blkp;
   df_block_t *		curblkp;
   struct _df_t *	next;
}df_t;
