/*
 * Copyright 1991-1998, Brown University, Providence, RI.
 * 
 *                         All Rights Reserved
 * 
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose other than its incorporation into a
 * commercial product is hereby granted without fee, provided that the
 * above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of Brown University not be used in
 * advertising or publicity pertaining to distribution of the software
 * without specific, written prior permission.
 * 
 * BROWN UNIVERSITY DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR ANY
 * PARTICULAR PURPOSE.  IN NO EVENT SHALL BROWN UNIVERSITY BE LIABLE FOR
 * ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
 * OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */
#include <xmc.h>
#include <xmclib.h>
#include <xmcp.h>
#include "common.h"

XmcDispInfo *
XmcQueryDisplay
   AL((muxp, dispId))
   DB Mux *muxp
   DD DispId dispId
   DE
{
   register char *cp;
   xmcQueryDisplayReq *p;
   xmcQueryDisplayReply *r;
   XmcDispInfo *disp;

   p = (xmcQueryDisplayReq *)Xmc_allocout(muxp, sz_xmcQueryDisplayReq);

   p->code = XMC_QueryDisplay;
   p->length = sz_xmcQueryDisplayReq;
   p->id = dispId;

   muxp->outseqno++;

   Xmc_flush(muxp);

   if ((r = (xmcQueryDisplayReply *)Xmc_reply(muxp)) == 0)
      return 0;

   if ((disp = (XmcDispInfo *)malloc(sizeof(XmcDispInfo))) == 0)
      ;
   else if (r->nBytesAddress &&
		(disp->addrp = (char *)malloc(r->nBytesAddress)) == 0) {
      free(disp);
      disp = 0;
   }
   else if (r->nBytesTag &&
			(disp->tag = (char *)malloc(r->nBytesTag + 1)) == 0) {
      free(disp->addrp);
      free(disp);
      disp = 0;
   }
   else {
      cp = (char *)(r+1);

      if (r->nBytesAddress) {
         bcopy(cp, (char *)disp->addrp, r->nBytesAddress);
         cp += r->nBytesAddress + PAD(r->nBytesAddress);
      }
      else
         disp->addrp = 0;

      if (r->nBytesTag) {
         bcopy(cp, (char *)disp->tag, r->nBytesTag);
         disp->tag[r->nBytesTag] = '\0';
         cp += r->nBytesTag + PAD(r->nBytesTag);
      }
      else
         disp->tag = 0;

      disp->mode = r->mode;
      disp->screen = r->screen;
      disp->display = r->displayNumber;
      disp->family = r->family;
      disp->addrlen = r->nBytesAddress;
      disp->tpID = r->tpID;
      disp->window = r->window;
   }
   Xmc_inclear(muxp, r->length);
   return disp;
}
