/*
 * Copyright 1991-1998, Brown University, Providence, RI.
 * 
 *                         All Rights Reserved
 * 
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose other than its incorporation into a
 * commercial product is hereby granted without fee, provided that the
 * above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of Brown University not be used in
 * advertising or publicity pertaining to distribution of the software
 * without specific, written prior permission.
 * 
 * BROWN UNIVERSITY DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR ANY
 * PARTICULAR PURPOSE.  IN NO EVENT SHALL BROWN UNIVERSITY BE LIABLE FOR
 * ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
 * OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */
#include <sys/param.h>
#include <sys/types.h>
#include <sys/socket.h>
#ifdef UNIXCONN
#include <sys/un.h>
#endif
#ifdef TCPCONN
#include <netinet/in.h>
#endif
#ifdef SVR4
#include <sys/filio.h>
#endif
#include <fcntl.h>
#include <netdb.h>
#include <xmc.h>
#include <xmclib.h>
#include <xmcp.h>
#include "common.h"

static FUNC(int, handshake, (Mux *, int, int, char *, int, XmcCookie *));
#ifdef UNIXCONN
static FUNC(int, conn_unix, (char *, int, int *, int *, char **));
#endif
#ifdef TCPCONN
static FUNC(int, conn_tcp, (char *, int, int *, int *, char **));
#endif
#ifdef DNETCONN
static FUNC(int, conn_decnet, (char *, int, int *, int *, char **));
#endif
#ifdef STREAMSCONN
static FUNC(int, conn_streams, (char *, int, int *, int *, char **));
#endif

Mux *
XmcOpen
   AL((display, cookie))
   DB char *display
   DD XmcCookie *cookie
   DE
{
   int dno, decnet;
   int family, length;
   char *address;
   register int fd = -1;
   register int net = 1;
   register Mux *muxp;
   char *hostname;
#ifdef FIONBIO
   int flag = 1;
#endif

   if (Xmc_parse_display(display, &hostname, &dno, 0, &decnet))
      return 0;
						/* open connection */
   if (hostname == 0 || strcmp(hostname, "unix") == 0) {
      if (hostname)
         free(hostname);
      hostname = Xmc_host_me();
#ifdef UNIXCONN
      fd = conn_unix(hostname, dno, &family, &length, &address);
      net = 0;
#endif
   }
   if (net) {
      if (decnet)
#ifdef DNETCONN
         fd = conn_decnet(hostname, dno, &family, &length, &address);
#else
         ;
#endif
      else
#ifdef TCPCONN
         fd = conn_tcp(hostname, dno, &family, &length, &address);
#else
#ifdef STREAMSCONN
         fd = conn_streams(hostname, dno, &family, &length, &address);
#else
         ;
#endif
#endif
   }
   if (fd >= 0) {				/* connection established */
      /*
      **	This is a non-blocking connection
      */
#ifdef O_NONBLOCK
      (void)fcntl(fd, F_SETFL, O_NONBLOCK);
#else
#ifdef FNDELAY
      (void)fcntl(fd, F_SETFL, FNDELAY);
#else
#ifdef FIONBIO
      (void)ioctl(fd, FIONBIO, &flag);
#else
      cannot make socket non blocking	/* break compile */
#endif
#endif
#endif
      if (muxp = (Mux *)malloc(sizeof(Mux))) {
         muxp->fd = fd;
         muxp->hostname = hostname;
         Xmc_zerobuf(&muxp->inbuf);
         Xmc_zerobuf(&muxp->outbuf);
         muxp->outseqno = 0;
         muxp->inseqno = 0;

         if (handshake(muxp, family, length, address, dno, cookie)) {
            free(muxp);
            goto failure;
         }
         muxp->qlen = 0;
         muxp->qhead = 0;
         muxp->qtail = 0;
         return muxp;
      }
   }
   failure:

   free(hostname);
   return 0;
}

static int
handshake
   AL((muxp, family, length, address, display, cookie))
   DB Mux *muxp
   DD int family
   DD int length
   DD char *address
   DD int display
   DD XmcCookie *cookie
   DE
{
   register int i;
   ushort_t namelen, datalen;
   char *name, *data;
   ushort_t Bl = 0x426c;
   xmcClientConn *p;
   xmcServerConn *sp;
   static char *auths[] = {	/* in order of decreasing preference */
	"SUN-DES-1",
	"XDM-AUTHORIZATION-1",
	"MIT-MAGIC-COOKIE-1"
   };

   if (cookie) {
      namelen = cookie->namelen;
      name = cookie->name;
      datalen = cookie->datalen;
      data = cookie->data;
   }
   else {
      if (Xmc_get_auth(	family, length, address, display,
			sizeof(auths)/sizeof(char *), auths,
			&namelen, &name, &datalen, &data) == 0) {
         namelen = 0;
         datalen = 0;
      }
   }
   p = (xmcClientConn *)Xmc_allocout(muxp, sz_xmcClientConn +
					namelen + PAD(namelen) +
					datalen + PAD(datalen));
   p->byteOrder = *((char *)&Bl);
   p->majorVersion = XMC_MAJOR_VERSION;
   p->minorVersion = XMC_MINOR_VERSION;
   p->nBytesAuthName = namelen;
   p->nBytesAuthData = datalen;

   if (namelen)
      bcopy(name, (char *)(p+1), namelen);
   if (datalen)
      bcopy(data, (char *)(p+1) + namelen + PAD(namelen), datalen);

   Xmc_flush(muxp);	/* send it */

   sp = (xmcServerConn *)Xmc_read(muxp, sz_xmcServerConn);
   if (sp->success == 0) {
      sp = (xmcServerConn *)Xmc_read(muxp, sz_xmcServerConn + sp->nBytesReason);
      printf("ERROR (%s)\n", (char *)(sp+1));
      return -1;
   }
   muxp->configMode = sp->configMode;
   muxp->base = sp->base;
   muxp->mask = sp->mask;
   muxp->deftpID = sp->deftpID;
   for (i=0; (muxp->mask & 1<<i) == 0; i++);
   muxp->shift = i;

   Xmc_inclear(muxp, sz_xmcServerConn);
   return 0;
}

#ifdef UNIXCONN
/*
**	conn_unix - establish a unix domain socket connection
*/
static int
conn_unix
   AL((hostname, dno, famp, lenp, addrp))
   DB char *hostname
   DD int dno
   DD int *famp
   DD int *lenp
   DD char **addrp
   DE
{
   register int fd;
   struct sockaddr_un usock;
   static char addrbuf[MAXPATHLEN];
   static char hostbuf[MAXHOSTNAMELEN];

   usock.sun_family = AF_UNIX;
   sprintf(addrbuf, "%s%d", XMC_UNIX_PATH, dno);
   strcpy(usock.sun_path, addrbuf);
   if ((fd = socket(AF_UNIX, SOCK_STREAM, 0)) < 0) {
      perror(usock.sun_path);
      return -1;
   }
   if (connect(fd, (struct sockaddr *)&usock, sizeof(usock)) < 0) {
      perror(usock.sun_path);
      close(fd);
      return -1;
   }
   if (gethostname(hostbuf, MAXHOSTNAMELEN)) {
      perror("gethostname");
      close(fd);
      return -1;
   }
   *famp = Xmc_family_utox(AF_UNIX);
   *lenp = strlen(hostbuf);
   *addrp = hostbuf;

   return fd;
}
#endif

#ifdef DNETCONN
/*
**	conn_decnet - establish a DECnet socket connection
*/
static int
conn_decnet
   AL((hostname, dno, famp, lenp, addrp))
   DB char *hostname
   DD int dno
   DD int *famp
   DD int *lenp
   DD char **addrp
   DE
{
   return -1;
}
#endif

#ifdef TCPCONN
/*
**	conn_tcp - establish a TCP socket connection
*/
static int
conn_tcp
   AL((hostname, dno, famp, lenp, addrp))
   DB char *hostname
   DD int dno
   DD int *famp
   DD int *lenp
   DD char **addrp
   DE
{
   register char *cp;
   register int fd;
   int family, length;
   char *address;
   static struct sockaddr_in isock;

   if (Xmc_host_addr(hostname, &family, &length, &address))
      return -1;

   isock.sin_family = Xmc_family_xtou(family);
   isock.sin_port = htons((u_short)(XMC_TCP_PORT - dno));
   if ((fd = socket(AF_INET, SOCK_STREAM, 0)) < 0) {
      perror ("tcp socket");
      return -1;
   }
   bcopy((char *)address, (char *)&isock.sin_addr, length);

   if (connect(fd, (struct sockaddr *)&isock, sizeof(isock)) < 0) {
      perror("tcp socket");
      return -1;
   }
   *famp = family;
   *lenp = length;
   *addrp = address;

   return fd;
}
#endif

#ifdef STREAMSCONN
/*
**	conn_streams - establish a streams connection
*/
static int
conn_streams
   AL((hostname, dno, famp, lenp, addrp))
   DB char *hostname
   DD int dno
   DD int *famp
   DD int *lenp
   DD char **addrp
   DE
{
   return -1;
}
#endif
