/************************************************************************
*									*
*	funcproto.h							*
*									*
*	We want to have our function prototypes and eat them, too.	*
*									*
*	this ends up looking like this:					*
*									*
*		int							*
*		foobar							*
*		   AL((arg1,arg2,arg3))					*
*		   DB int arg1						*
*		   DD short arg2					*
*		   DD float arg3					*
*		   DE							*
*		{							*
*		   ...							*
*		}							*
*									*
************************************************************************/
#ifndef _FUNCPROTO_H
#define _FUNCPROTO_H

#ifdef __STDC__
#define AL(arglist)
#define DB		(
#define DD		,
#define DE		)
#define VOID		(void)
#define VARARG(proto)	proto
#define VA1(al,type,name)\
   va_list al;\
   va_start(al, name)
#define VA2(al,type1,name1,type2,name2)\
   va_list al;\
   va_start(al, name2)
#define USE_STDARG	1
#define NEED_PROTO	1
#else
#define AL(arglist)	arglist
#define DB
#define DD		;
#define DE		;
#define VOID		()
#define VARARG(proto)	(va_alist)
#define VA1(al,type,name)\
   va_list al;\
   type name;\
   va_start(al);\
   name = va_arg(al,type)
#define VA2(al,type1,name1,type2,name2)\
   va_list al;\
   type1 name1;\
   type2 name2;\
   va_start(al);\
   name1 = va_arg(al,type1);\
   name2 = va_arg(al,type2)
#endif

/*
**	function declarations
*/
#ifdef NEED_PROTO
#define FUNC(type,name,proto)	type name proto
#else
#define FUNC(type,name,proto)	type name ()
#endif

#endif
