/*----------------------------------------------------------------------------
--
--  Module:           xitInfoPrint
--
--  Project:          xit - X Internal Toolkit
--  System:           <>
--    Subsystem:      <>
--    Function block: <>
--
--  Description:
--    Interface file to module xitInfoPrint.
--
--  Filename:         xitInfoPrint.h
--
--  Authors:          Roger Larsson, Ulrika Bornetun
--  Creation date:    1992-10-17
--
--
--  (C) Copyright Ulrika Bornetun, Roger Larsson (1995)
--      All rights reserved
--
--  Permission to use, copy, modify, and distribute this software and its
--  documentation for any purpose and without fee is hereby granted,
--  provided that the above copyright notice appear in all copies. Ulrika
--  Bornetun and Roger Larsson make no representations about the usability
--  of this software for any purpose. It is provided "as is" without express
--  or implied warranty.
----------------------------------------------------------------------------*/

/* SCCS module identifier. */
/* SCCSID = @(#) Module: xitInfoPrint.h, Version: 1.1, Date: 95/02/18 15:10:38 */


/* Only include this module once. */
#ifndef define_xitInfoPrint_h
#  define define_xitInfoPrint_h


/*----------------------------------------------------------------------------
--  Include files
----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
--  Macro definitions
----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
--  Type declarations
----------------------------------------------------------------------------*/

/* Reasons when the action routine is called. */
typedef enum {
  XIT_IP_REASON_DESTROY,
  XIT_IP_REASON_POPDOWN
} XIT_IP_REASON;


/* Callback function. */
typedef void  ( *XIT_IP_ACTION_CB ) ( XIT_IP_REASON, void * );

/* Handle to the print window. */
typedef void  *XIT_IP_HANDLE;


/*----------------------------------------------------------------------------
--  Global definitions
----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
--  Function prototypes
----------------------------------------------------------------------------*/

void
  xitIpDestroy( XIT_IP_HANDLE  printer_handle );

void 
  xitIpDisplayPrinter( XIT_IP_HANDLE  printer_handle,
                       char           *book,
                       char           *chapter_id,
                       int            section_no,
                       char           *book_file );

XIT_IP_HANDLE
  xitIpInitialize( Widget            parent,
                   char              *system_pr_file,
                   char              *user_pr_file,
                   char              *print_script,
                   XIT_IP_ACTION_CB  actionCB,
                   void              *user_data );


#endif
