/*----------------------------------------------------------------------------
--
--  Module:           xtmPickDiary
--
--  Project:          XDiary
--  System:           xtm - X Desktop Calendar
--    Subsystem:      <>
--    Function block: <>
--
--  Description:
--    Interface file for module xtmPickDiary.
--
--  Filename:         xtmPickDiary.h
--
--  Authors:          Roger Larsson, Ulrika Bornetun
--  Creation date:    1992-07-01
--
--
--  (C) Copyright Ulrika Bornetun, Roger Larsson (1995)
--      All rights reserved
--
--  Permission to use, copy, modify, and distribute this software and its
--  documentation for any purpose and without fee is hereby granted,
--  provided that the above copyright notice appear in all copies. Ulrika
--  Bornetun and Roger Larsson make no representations about the usability
--  of this software for any purpose. It is provided "as is" without express
--  or implied warranty.
----------------------------------------------------------------------------*/

/* SCCS module identifier. */
/* SCCSID = @(#) Module: xtmPickDiary.h, Version: 1.1, Date: 95/02/18 15:52:37 */


/* Include this file only once. */
#ifndef define_xtmPickDiary_h
#  define define_xtmPickDiary_h


/*----------------------------------------------------------------------------
--  Include files
----------------------------------------------------------------------------*/

#include "xtmGlobal.h"
#include "xtmCalDb.h"
#include "xitInfo.h"


/*----------------------------------------------------------------------------
--  Macro definitions
----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
--  Type declarations
----------------------------------------------------------------------------*/

/* Reasons when the action routine is called. */
typedef enum {
  XTM_PD_REASON_OK,
  XTM_PD_REASON_APPLY,
  XTM_PD_REASON_CANCEL,
  XTM_PD_REASON_DESTROY
} XTM_PD_REASON;

/* Handle to use when comminucating with the pick window. */
typedef  void  *XTM_PD_HANDLE;

/* Callback when Apply/OK is selected. */
typedef void ( *XTM_PD_ACTION_CB ) (XTM_PD_REASON, XTM_CD_CAL_INFO *, void *);


/*----------------------------------------------------------------------------
--  Global definitions
----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
--  Function prototypes
----------------------------------------------------------------------------*/



/*----------------------------------------------------------------------------
--  Functions
----------------------------------------------------------------------------*/

void
  xtmPdDestroy( XTM_PD_HANDLE  pick_handle );

void
  xtmPdDisplayPickWindow( XTM_PD_HANDLE  pick_handle,
                          char           *directory,
                          char           *file_pattern );

XTM_PD_HANDLE
  xtmPdInitialize( Widget             parent,
                   Boolean            app_modal,
                   XIT_IN_HANDLE      info_handle,
                   XTM_PD_ACTION_CB   actionCB,
                   void               *user_data );

#endif
