/*----------------------------------------------------------------------------
--
--  Module:           xtmIcons
--
--  Project:          XDiary
--  System:           xtm - X Desktop Calendar
--    Subsystem:      <>
--    Function block: <>
--
--  Description:
--    Interface file for module xtmIcons.
--
--  Filename:         xtmIcons.h
--
--  Authors:          Roger Larsson, Ulrika Bornetun
--  Creation date:    1992-04-03
--
--
--  (C) Copyright Ulrika Bornetun, Roger Larsson (1995)
--      All rights reserved
--
--  Permission to use, copy, modify, and distribute this software and its
--  documentation for any purpose and without fee is hereby granted,
--  provided that the above copyright notice appear in all copies. Ulrika
--  Bornetun and Roger Larsson make no representations about the usability
--  of this software for any purpose. It is provided "as is" without express
--  or implied warranty.
----------------------------------------------------------------------------*/

/* SCCS module identifier. */
/* SCCSID = @(#) Module: xtmIcons.h, Version: 1.1, Date: 95/02/18 15:52:25 */


/* Include this file only once. */
#ifndef define_xtmIcons_h
#  define define_xtmIcons_h


/*----------------------------------------------------------------------------
--  Include files
----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
--  Macro definitions
----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
--  Type declarations
----------------------------------------------------------------------------*/

/* The kinds of icons we have. */
typedef enum {
  XTM_IC_ICON_DEFAULT,
  XTM_IC_ICON_CALENDAR, 
  XTM_IC_ICON_CUSTOM,
  XTM_IC_ICON_EDIT_ENTRY,
  XTM_IC_ICON_MESSAGE,
  XTM_IC_ICON_REMINDER,
  XTM_IC_ICON_ACL,
  XTM_IC_ICON_PRINT,
  XTM_IC_ICON_SCHEDULE,
  XTM_IC_ICON_SUMMARY,
  XTM_IC_ICON_MAIL,
  XTM_IC_ICON_NAV_CAL,
  XTM_IC_ICON_XDIARY_LOGO,
  XTM_IC_ICON_PLANNER,
  XTM_IC_ICON_ANI_MOVE1,
  XTM_IC_ICON_ANI_MOVE2,
  XTM_IC_ICON_ANI_MOVE3,
  XTM_IC_ICON_ANI_MOVE4,
  XTM_IC_ICON_ANI_MOVE5,
  XTM_IC_ICON_ANI_MOVE6,
  XTM_IC_ICON_ANI_MOVE,
  XTM_IC_ICON_CAL_TOP,
  XTM_IC_ICON_CAL_LEFT_TOP,
  XTM_IC_ICON_CAL_RIGHT_TOP,
  XTM_IC_ICON_ALARM_CLOCK1,
  XTM_IC_ICON_ALARM_CLOCK2,
  XTM_IC_ICON_ALARM_CLOCK3,
  XTM_IC_ICON_ALARM_CLOCK4,
  XTM_IC_ICON_ALARM_CLOCK5,
  XTM_IC_ICON_ALARM_CLOCK5INV,
  XTM_IC_ICON_ALARM_CLOCK6,
  XTM_IC_ICON_ALARM_CLOCK7,
  XTM_IC_ICON_ALARM_CLOCK8,
  XTM_IC_ICON_ALARM_CLOCK9,
  XTM_IC_ICON_DROP_MENU
} XTM_IC_ICON_TYPE;


/*----------------------------------------------------------------------------
--  Global definitions
----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
--  Function prototypes
----------------------------------------------------------------------------*/

Pixmap
  xtmIcFetchSimplePixmap( Widget            colorTemplW,
                          XTM_IC_ICON_TYPE  icon_type,
                          Boolean           invert );

void
  xtmIcSetSimpleIcon( Widget            iconForW,
                      Widget            colorTemplW,
                      XTM_IC_ICON_TYPE  icon_type );

#endif
