/*----------------------------------------------------------------------------
--
--  Module:           xtmGlobal
--
--  Project:          Xdiary
--  System:           xtm - X Desktop Calendar
--    Subsystem:      <>
--    Function block: <>
--
--  Description:
--    Global declarations for Xdiary.
--
--  Filename:         xtmGlobal.h
--
--  Authors:          Roger Larsson, Ulrika Bornetun
--  Creation date:    1990-12-01
--
--
--  (C) Copyright Ulrika Bornetun, Roger Larsson (1995)
--      All rights reserved
--
--  Permission to use, copy, modify, and distribute this software and its
--  documentation for any purpose and without fee is hereby granted,
--  provided that the above copyright notice appear in all copies. Ulrika
--  Bornetun and Roger Larsson make no representations about the usability
--  of this software for any purpose. It is provided "as is" without express
--  or implied warranty.
----------------------------------------------------------------------------*/

/* SCCS module identifier. */
/* SCCSID = @(#) Module: xtmGlobal.h, Version: 1.1, Date: 95/02/18 15:52:23 */


/* Only include this module once. */
#ifndef define_xtmGlobal_h
#  define define_xtmGlobal_h


/*----------------------------------------------------------------------------
--  Include files
----------------------------------------------------------------------------*/

#include "Standard.h"
#include "TimDate.h"
#include "LstLinked.h"

#include "xtmReminder.h"
#include "xitClipboard.h"
#include "xitMsgWin.h"
#include "xitInfo.h"


/*----------------------------------------------------------------------------
--  Macro definitions
----------------------------------------------------------------------------*/

/* Name of application. */
#define APPLICATION_NAME    "XDiary"


/* Max number of running alarms. */
#define XTM_GL_MAX_ALARM_PRC    50

/* Max length of an archive name. */
#define XTM_GL_MAX_ARCH_NAME    15

/* Max length of a calendar name. */
#define XTM_GL_MAX_CAL_NAME     15

/* Max number of colors in color list. */
#define XTM_GL_MAX_COLORS       30

/* Max length of comment. */
#define XTM_GL_MAX_COMMENT      20

/* Max length of an external connection type. */
#define XTM_GL_MAX_EXTERN_TYPE  10

/* Max length of directory location. */
#define XTM_GL_MAX_DIR          75

/* Max number of dayl list views that can be active. */
#define XTM_GL_MAX_DL_VIEW       5

/* Max length of entry tag. */
#define XTM_GL_MAX_ENTRY_TAG     4

/* Max length of a host name. */
#define XTM_GL_MAX_HOSTNAME     40

/* Max length of calendar location. */
#define XTM_GL_MAX_LOCATION     50

/* Max length of mail address. */
#define XTM_GL_MAX_MAIL_ADDR    40

/* Max length of a password. */
#define XTM_GL_MAX_PASSWORD     20

/* Max length of a user ID. */
#define XTM_GL_MAX_USERID       20


/* Flags to signal various actions to take. */
#define XTM_GL_TOOLS_DONE         (1<<1)
#define XTM_GL_UPDATE_MAIN_CAL    (1<<2)
#define XTM_GL_UPDATE_DAY_CAL     (1<<3)
#define XTM_GL_UPDATE_CLOCK       (1<<4)
#define XTM_GL_UPDATE_ALL         (1<<5)

/* Exception handler (raise exception). */
#define raise  goto


/*----------------------------------------------------------------------------
--  Type declarations
----------------------------------------------------------------------------*/

/* The layout of the appointments in the day list. */
typedef enum {
  XTM_GL_LAYOUT_TIME,
  XTM_GL_LAYOUT_DURATION
} XTM_GL_ENTRY_LAYOUT;


/* List of colors. */
typedef struct {
  int    no_colors;
  Pixel  color[ XTM_GL_MAX_COLORS ];
} XTM_GL_COLOR_LIST;


/* Data structure describing included file. */
typedef struct {

  /* File name (expanded). */
  char  *file_name;

  /* File name (original). */
  char  *orig_file_name;

} XTM_GL_INCLUDE_FILE;


/* Data structure describing data from the customization file. */
typedef struct {

  /* Reminder alarm for new appointments. */
  Boolean  alarm_for_new_app;

  /* Default alarm offsets valid. */
  Boolean  alarm_valid[ 5 ];

  /* Display an extended monthe in calendars. */
  Boolean  cal_month_extend;

  /* Make a new day view when clicking on a date in the calendar. */
  Boolean  click_date_new_view;

  /* Require confirmation for certain important actions like delete? */
  Boolean  confirm_actions;

  /* Run in debug mode? */
  Boolean  debug_mode;

  /* Display flags for entries in the day view. */
  Boolean  display_entry_flags;

  /* In the schedule window, display the navigate calendar automatically. */
  Boolean  display_nav_cal;

  /* Do calendar refresh? */
  Boolean  do_refresh;

  /* Interactive operations in the day view. */
  Boolean  entries_interactive;

  /* Sound alarms? */
  Boolean  give_alarm;

  /* Show schedule with a list layout. */
  Boolean  list_layout;

  /* New release of XDiary? */
  Boolean  new_release;

  /* Print only working days. */
  Boolean  pr_only_workdays;

  /* Print in 3D? */
  Boolean  pr_in_3d;

  /* Prompt with the repeating window? */
  Boolean  prompt_repeat_win;

  /* Run in read-only mode? */
  Boolean  read_only_mode;

  /* Show week numbers in the calendar? */
  Boolean  show_week_numbers;

  /* Show standing entries in the calendar? */
  Boolean  show_stand_in_cal;

  /* At start time, show what is up today? */
  Boolean  show_day_to_do;

  /* Uset standard UNIX week numbering (is really wrong). */
  Boolean  std_unix_week_numbers;

  /* Display true colors for entries in included calendars. */
  Boolean  true_color_included;

  /* Use file locking or not? */
  Boolean  use_file_lock;

  /* A valid resource file? */
  Boolean  valid_resource_file;

  /* Do widget caching? */
  Boolean  widget_caching;

  /* The workdays (Mon - Sun). */
  Boolean  workdays[ 7 ];

  /* Wrap X-Server bug? */
  Boolean  wrap_bug;

  /* Fancy calendar style? */
  Boolean  cal_is_fancy;

  /* Free flags to use. */
  Boolean  free_flag_1;
  Boolean  free_flag_2;
  Boolean  free_flag_3;
  Boolean  free_flag_4;
  Boolean  free_flag_5;

  /* Marker for entries with action alarms. */
  int  action_alarm_marker;

  /* File system identifier for AFS files. */
  int  afs_vfs_id;

  /* Marker for entries with alarms. */
  int  alarm_marker;

  /* Default alarm offsets. */
  int  alarm_offset[ 5 ];

  /* The default number of lines to show for an alarm. */
  int  alarm_show_lines;

  /* Volume for alarms. */
  int  alarm_volume;

  /* Size (in pixels) for the appointment pane in the day view. */
  int  app_pane_height;

  /* Marker for archived entries. */
  int  archive_marker;

  /* Style to use for day marks in calendar. */
  int  cal_button_style;

  /* Shadow thickness for days with entries. */
  int  cal_entry_shadow;

  /* Switch day in the day list? */
  int  day_view_day_switch;

  /* Number of days to display in the day view. */
  int  day_view_days;

  /* Default entry delta (in minutes). */
  int  default_entry_delta;

  /* Default paper size. */
  int  default_paper_size;

  /* Default tune to use. */
  int  default_tune;

  /* Width for days in the day view (0 - use default values). */
  int  def_day_width;

  /* Default duration for an entry. */
  int  entry_default_duration;

  /* Width (in pixels) for the entry pane in the day view. */
  int  entry_pane_width;

  /* Shadow for the buttons representing entries. */
  int  entry_shadow_thickness;

  /* The default number of lines to show for each entry in the day list. */
  int  entry_show_lines;

  /* Marker for important entries. */
  int  important_marker;

  /* Depth of include files. */
  int  incl_depth;

  /* Marker for included entries. */
  int  include_marker;

  /* Marker for a 'done' note. */ 
  int  note_done_marker;

  /* Marker for a note 'not done'. */
  int  note_not_done_marker;

  /* Size (in pixels) for the note pane in the day view. */
  int  note_pane_height;

  /* Number of lines in the print window. */
  int  print_def_lines;

  /* Number of sheets per page when printing. */
  int  print_def_sheets;

  /* Marker for a private entry. */
  int  private_marker;

  /* Refresh rate in minutes for XDiary. */
  int  refresh_rate;

  /* Marker for a standing entry. */
  int  standing_marker;

  /* The day to start the day view on. */
  int  start_day_view_on;

  /* Start time for entries in the day list. */
  int  start_hour;

  /* End time for entries in the day list. */
  int  stop_hour;

  /* Number of lines in the summary. */
  int  summary_def_lines;

  /* Position for text marker in the appointment window. */
  int  text_marker_pos;

  /* Duration delta for tune. */
  int  tune_dur_delta;

  /* Free int to use. */
  int  free_int_1;
  int  free_int_2;
  int  free_int_3;
  int  free_int_4;
  int  free_int_5;

  /* Format for dates. */
  char  date_format[ 50 ];

  /* Selected language. */
  char  msg_language[ 20 ];

  /* Format for times. */
  char  time_format[ 50 ];

  /* Script (program) for access control. */
  char  *acl_script;

  /* Script (program) to start the alarm process. */
  char  *alarm_script;

  /* Type of text to display in the calendar icon window. */
  char  *cal_icon_text;

  /* File to contain user custom data. */
  char  *custom_file;

  /* Pre-processor for user custom data. */
  char  *custom_file_pp;

  /* Script (program) for XDiary customization. */
  char  *custom_script;

  /* List with background colors to use for databases. */
  char  *db_color_bg_list;

  /* Directory for diary descriptions. */
  char  *db_selection_dir;

  /* Default date format. */
  char  *default_date_format;

  /* Default entry tag. */
  char  *default_entry_tag;

  /* Default text for entries. */
  char  *default_entry_text;

  /* Default printer to use. */
  char  *default_printer;

  /* Default printer type to use. */
  char  *default_printer_type;

  /* Default time format. */
  char  *default_time_format;

  /* List with background colors to use. */
  char  *color_bg_list;

  /* List with foreground colors to use. */
  char  *color_fg_list;

  /* Default entry tags filter. */
  char  *entry_tags_filter;

  /* Default tags to select in the tag selection menu. */
  char  *entry_tags_menu;

  /* File for error logs. */
  char  *error_log_file;

  /* Default tags to use in the day list. */
  char  *filter_day_view_tags;

  /* Default tags to use for the alarm. */
  char  *filter_alarm_tags;

  /* Script (program) to find calendar location. */
  char  *find_location_script;

  /* Generic print command to use. */
  char  *gen_print_command;

  /* Directory containing the holidays databases. */
  char *holidays_db_dir;

  /* Script (program) to run when entries are printed. */
  char  *print_script;

  /* Types of printer we can handle. */
  char  *printer_types;

  /* Remote script to upload/download external calendars. */
  char  *remote_script;

  /* File to contain system custom data. */
  char  *system_custom_file;

  /* Pre-processor for system custom data. */
  char  *system_custom_file_pp;

  /* Name of the file containing system printers. */
  char  *system_printer_file;

  /* Colors tor tags. */
  char  *tags_colors;

  /* Times to use in the time select fields. */
  char  *time_sel_values;

  /* Files containing tunes to play. */
  char *tune_file[ 5 ];

  /* Tune program to use. */
  char *tune_player;

  /* String to use when calling the editor. */
  char  *user_editor;

  /* Name of the file containing the user specified printers. */
  char  *user_printer_file;

  /* System wide and user books in the info system. */
  char  *system_books;
  char  *user_books;

  /* Tune program parameters. */
  char *tune_player_param;

  char  *free_char_1;
  char  *free_char_2;
  char  *free_char_3;
  char  *free_char_4;

  /* Background color for all dates in the calendar. */
  Pixel  date_mark_bg;

  /* Background color for a entry button in the day list. */
  Pixel  entry_button_unselect_bg;

  /* Foreground color for date in calendar when entry exist that day. */
  Pixel  entry_exist_fg;

  /* Background color for a read-only entry in the day list. */
  Pixel  entry_include_bg;

  /* Foreground color for an important entry in the day list. */
  Pixel  entry_important_fg;

  /* Background color for a selected entry in the day list. */
  Pixel  entry_select_bg;

  /* Background color for an unselected entry in the day list. */
  Pixel  entry_unselect_bg;

  /* Foreground color for a normal entry in the day list. */
  Pixel  entry_normal_fg;

  /* Foreground color for a note entry in the day list. */
  Pixel  entry_note_fg;

  /* Foreground color for dates marked as holidays. */
  Pixel  holiday_fg;

  /* Foreground color for weekdays (Mon - Sun). */
  Pixel  monday_fg;
  Pixel  tuesday_fg;
  Pixel  wednesday_fg;
  Pixel  thursday_fg;
  Pixel  friday_fg;
  Pixel  saturday_fg;
  Pixel  sunday_fg;

  /* Background color for today. */
  Pixel  today_bg;

  /* Foreground color for the week numbers. */
  Pixel  week_number_fg;

  /* Calendar database. */
  void  *cal_db_handle;

  /* Group lists (XDiary messages). */
  void  *group_db_handle;

  /* Tags database. */
  void  *tags_db;

  /* Archive files. */
  LST_DESC_TYPE  archive_files;

  /* Include files. */
  LST_DESC_TYPE  include_files;

  /* Background colors DB. */
  XTM_GL_COLOR_LIST  colorsDB_bg;

  /* Foreground colors DB. */
  XTM_GL_COLOR_LIST  colorsDB_fg;

  /* Background colors for databases. */
  XTM_GL_COLOR_LIST  db_colors_bg;

  /* Original argc and argv (command line). */
  unsigned int  orig_argc;
  char**        orig_argv;
  
  /* Reserve data references. */
  void  *extra1;
  void  *extra2;
  void  *extra3;
  void  *extra4;
  void  *extra5;

} XTM_GL_CUSTOM_DATA, *XTM_GL_CUSTOM_DATA_REF;


/* Structure describing a single alarm process. */
typedef struct {

  /* Database name. */
  char  db_name[ 20 ];

} XTM_GL_ALARM_PRC;


/* Running alarm process. */
typedef struct {

  /* Window with alarm process information. */
  Widget  mainFo;

  /* Process ID for the alarm process. */
  int  alarm_pid;

  /* The running alarm processes. */
  XTM_GL_ALARM_PRC  processes[ XTM_GL_MAX_ALARM_PRC ];  

} XTM_GL_PROC_INFO, *XTM_GL_PROC_INFO_REF;


/* Basic data structure for the XDiary application. */
typedef struct {

  /* Command line flags. */
  Boolean  startup_help;
  Boolean  version_help;

  /* Various flags. */
  UINT32  flags;

  /* Use this default db directory? */
  char  *default_db_dir;

  /* Name of FIFO to use when communicating with the alarm process. */
  char  *alarm_fifo_name;

  /* Title of the XDiary session. */
  char  *title;

  /* The toplevel shell for the application. */
  Widget  toplevel;

  /* Window for the main calendar. */
  Widget  calW;

  /* The X application context. */
  XtAppContext  context;

  /* FIFO file when communicating with the alarm process. */
  FILE  *alarm_fifo_ref;

  /* Customization data. */
  XTM_GL_CUSTOM_DATA_REF  custom_data;

  /* Process information. */
  XTM_GL_PROC_INFO_REF  process_info;

  /* Window for error messages. */
  XIT_MSW_HANDLE  msg_win_ref;

  /* Info reference. */
  XIT_IN_HANDLE  info_handle;

  /* Main calendar. */
  void  *cal_handle;

  /* Send message. */
  void  *msg_send_handle;

  /* Reserve data references. */
  void  *extra1;
  void  *extra2;
  void  *extra3;
  void  *extra4;

  /* Start date for calendar. */
  char  *start_date;

} XTM_GL_BASE_DATA, *XTM_GL_BASE_DATA_REF;


/*----------------------------------------------------------------------------
--  Global definitions
----------------------------------------------------------------------------*/

/* Keyboard translations for tab group move. */
extern XtTranslations  xtm_di_tab_group_trans;

/* Keyboard translations for newline in multi-line editor. */
extern XtTranslations  xtm_di_newline_trans;


/*----------------------------------------------------------------------------
--  Function prototypes
----------------------------------------------------------------------------*/


#endif
