/*----------------------------------------------------------------------------
--
--  Module:           xtmEditStabd
--
--  Project:          Xdiary
--  System:           xtm - X Desktop Calendar
--    Subsystem:      <>
--    Function block: <>
--
--  Description:
--    Interface file for xtmEditStand.c.
--
--  Filename:         xtmEditStand.h
--
--  Authors:          Roger Larsson, Ulrika Bornetun
--  Creation date:    1992-10-10
--
--
--  (C) Copyright Ulrika Bornetun, Roger Larsson (1995)
--      All rights reserved
--
--  Permission to use, copy, modify, and distribute this software and its
--  documentation for any purpose and without fee is hereby granted,
--  provided that the above copyright notice appear in all copies. Ulrika
--  Bornetun and Roger Larsson make no representations about the usability
--  of this software for any purpose. It is provided "as is" without express
--  or implied warranty.
----------------------------------------------------------------------------*/

/* SCCS module identifier. */
/* SCCSID = @(#) Module: xtmEditStand.h, Version: 1.1, Date: 95/02/18 15:52:18 */


/* Only include this module once. */
#ifndef define_xtmEditStand_h
#  define define_xtmEditStand_h


/*----------------------------------------------------------------------------
--  Include files
----------------------------------------------------------------------------*/

#include "TimDate.h"
#include "xtmGlobal.h"
#include "xtmDbTools.h"


/*----------------------------------------------------------------------------
--  Macro definitions
----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
--  Type declarations
----------------------------------------------------------------------------*/

/* Values passed to the window. */
typedef struct {
  Boolean                 valid_days[ 7 ];
  int                     every_n;
  int                     valid_every;
  UINT32                  flags;
  UINT32                  skip_week[ 2 ];
  TIM_TIME_REF            default_date;
  TIM_TIME_REF            from;
  TIM_TIME_REF            to;
  XTM_DB_ALL_ENTRY_TYPES  entry_type;
} XTM_ES_SET_STAND_DATA;

/* Result values passed from the window. */
typedef struct {
  Boolean       valid_days[ 7 ];
  int           every_n;
  int           valid_every;
  UINT32        flags;
  UINT32        skip_week[ 2 ];
  TIM_TIME_REF  from;
  TIM_TIME_REF  to;
} XTM_ES_GET_STAND_DATA;


/* Reasons when the action routine is called. */
typedef enum {
  XTM_ES_REASON_CANCEL,
  XTM_ES_REASON_DESTROY,
  XTM_ES_REASON_OK
} XTM_ES_REASON;

/* Callback when the alarm window is destroyed. */
typedef void ( *XTM_ES_ACTION_CB ) ( XTM_ES_REASON, 
                                     void *, XTM_ES_GET_STAND_DATA * );

/* Handle to use when comminucating with the window. */
typedef  void  *XTM_ES_HANDLE;


/*----------------------------------------------------------------------------
--  Global definitions
----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
--  Function prototypes
----------------------------------------------------------------------------*/

void
  xtmEsDestroy( XTM_ES_HANDLE  stand_handle );

void
  xtmEsEditStanding( XTM_ES_HANDLE          stand_handle,
                     XTM_ES_SET_STAND_DATA  *values_ref );

XTM_ES_HANDLE
  xtmEsInitialize( XTM_GL_BASE_DATA_REF  appl_data_ref,
                   Widget                parent,
                   XTM_ES_ACTION_CB      actionCB,
                   void                  *user_data );

#endif

